/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignAnchoringLayoutManager;
import ch.abacus.designcockpit.ide.IDEViewDisplayer;
import ch.abacus.designcockpit.ide.Sizebox;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class Sizeboxes {
    MetaObject theMetaObject;
    JComponent theParentContainer = null;
    Sizebox[] theBoxes = new Sizebox[8];
    SuperDesignCockpit theDesignCockpit = null;

    public Sizeboxes(MetaObject objMetaObject, int width, int height, SuperDesignCockpit theDesignCockpit) {
        this.theMetaObject = objMetaObject;
        this.theDesignCockpit = theDesignCockpit;
        MetaObject theParent = null;
        IDEViewDisplayer theViewDisplayer = theDesignCockpit.theViewDisplayer;
        this.theParentContainer = null;
        if (this.theMetaObject.isPanel() || this.theMetaObject.isGroup() || this.theMetaObject.isScrollPane() || this.theMetaObject.isTabbedPane() || this.theMetaObject.isScrollingPanel() || this.theMetaObject.isJToolBar() || this.theMetaObject.isJMenuBar()) {
            theParent = this.theMetaObject.getVisualContainerObject(true);
        } else if (this.theMetaObject.isAbalet() || this.theMetaObject.isFrame()) {
            this.theParentContainer = theDesignCockpit.theViewDisplayer;
        } else {
            theParent = this.theMetaObject.getVisualContainerObject(false);
        }
        if (this.theParentContainer == null) {
            this.theParentContainer = theParent.theVisualObject;
        }
        DesignAnchoringLayoutManager theManager = null;
        if (this.theParentContainer.getLayout() instanceof DesignAnchoringLayoutManager) {
            theManager = (DesignAnchoringLayoutManager)this.theParentContainer.getLayout();
        }
        if (theParent != null && (theParent.isHorzSplit() || theParent.isVertSplit())) {
            return;
        }
        for (int i = 0; i <= 7; ++i) {
            this.theBoxes[i] = new Sizebox(objMetaObject, i, this, theDesignCockpit);
            this.theBoxes[i].width = width;
            this.theBoxes[i].height = height;
            if (this.theParentContainer.equals(theViewDisplayer)) {
                theViewDisplayer.add(this.theBoxes[i]);
            } else {
                String theName = objMetaObject.getName() + "_SizeBox_" + i;
                if (this.theParentContainer instanceof JLayeredPane) {
                    JLayeredPane thePane = (JLayeredPane)this.theParentContainer;
                    thePane.add(this.theBoxes[i], theName, this.theMetaObject.iDisplayLayer);
                } else {
                    this.theParentContainer.add((Component)this.theBoxes[i], theName);
                }
            }
            if (theManager != null) {
                theManager.setAnchoring(this.theBoxes[i], objMetaObject, false, false, false, false);
            }
            this.theBoxes[i].locate();
        }
    }

    public void kill() {
        for (int i = 0; i <= 7; ++i) {
            if (this.theBoxes[i] == null) continue;
            this.theBoxes[i].kill();
            this.theParentContainer.remove(this.theBoxes[i]);
            this.theBoxes[i] = null;
        }
        this.theParentContainer.repaint();
    }

    public void relocate(int x, int y, int cx, int cy, boolean bStillDragging, boolean bResizeHorizontal, boolean bResizeVertical) {
        if (bStillDragging) {
            this.theDesignCockpit.resizeAction(this.theMetaObject, x, y, cx, cy, 1, bResizeHorizontal, bResizeVertical);
        } else {
            this.theMetaObject.bAnchoringOff = true;
            this.theDesignCockpit.resizeAction(this.theMetaObject, x, y, cx, cy, 2, bResizeHorizontal, bResizeVertical);
        }
        Point ptLocation = this.theMetaObject.getLocation();
        Dimension dimSize = this.theMetaObject.getSize();
        if (this.theMetaObject.theVisualObject != null) {
            dimSize = this.theMetaObject.theVisualObject.getSize();
            ptLocation = this.theMetaObject.theVisualObject.getLocation();
        } else if (this.theMetaObject.theVisualFrame != null) {
            dimSize = this.theMetaObject.theVisualFrame.getSize();
            ptLocation = this.theMetaObject.theVisualFrame.getLocation();
        }
        this.theMetaObject.theVisualObject.setLocation((int)ptLocation.getX(), (int)ptLocation.getY());
        this.theMetaObject.theVisualObject.setSize((int)dimSize.getWidth(), (int)dimSize.getHeight());
        if (this.theMetaObject.theLayoutManager != null) {
            DesignAnchoringLayoutManager theLayoutManager;
            if (this.theMetaObject.theLayoutManager instanceof DesignAnchoringLayoutManager) {
                theLayoutManager = (DesignAnchoringLayoutManager)this.theMetaObject.theLayoutManager;
                theLayoutManager.layoutContainer(this.theMetaObject.theVisualObject);
            } else {
                theLayoutManager = (AnchoringLayoutManager)this.theMetaObject.theLayoutManager;
                theLayoutManager.layoutContainer(this.theMetaObject.theVisualObject);
            }
            MetaObject theSelectedObject = this.theDesignCockpit.getSelectedObject();
            if (theSelectedObject != null && this.theMetaObject != theSelectedObject) {
                this.theDesignCockpit.SelectObject(null, false);
                this.theDesignCockpit.SelectObject(this.theMetaObject, false);
            }
        }
        if (this.theMetaObject.isScrollPane() || this.theMetaObject.isTabbedPane()) {
            MetaObject theChild = this.theMetaObject.theFirstChild;
            while (theChild != null) {
                theChild.theVisualObject.setLocation(0, 0);
                theChild.theVisualObject.setSize(dimSize);
                theChild.setPropertyValue("Location.Top", 0, 1, this.theMetaObject.getPropertyValue("Location.Top", 0));
                theChild.setPropertyValue("Location.Left", 0, 0, this.theMetaObject.getPropertyValue("Location.Left", 0));
                theChild.setPropertyValue("Size.Width", 0, 0, this.theMetaObject.getPropertyValue("Size.Width", 0));
                theChild.setPropertyValue("Size.Height", 0, 1, this.theMetaObject.getPropertyValue("Size.Height", 0));
                theChild = theChild.theNextObject;
            }
        }
        for (int i = 0; i <= 7; ++i) {
            if (this.theBoxes[i] == null) continue;
            this.theBoxes[i].locate();
        }
    }

    public void update(int x, int y, int cx, int cy) {
        MetaObject theParent = null;
        if (this.theMetaObject.isPanel() || this.theMetaObject.isGroup() || this.theMetaObject.isScrollPane() || this.theMetaObject.isTabbedPane() || this.theMetaObject.isScrollingPanel() || this.theMetaObject.isJToolBar() || this.theMetaObject.isJMenuBar()) {
            theParent = this.theMetaObject.getVisualContainerObject(true);
        } else if (this.theMetaObject.isAbalet() || this.theMetaObject.isFrame()) {
            this.theParentContainer = this.theDesignCockpit.theViewDisplayer;
        } else {
            theParent = this.theMetaObject.getVisualContainerObject(false);
        }
        if (this.theParentContainer == null) {
            this.theParentContainer = theParent.theVisualObject;
        }
        for (int i = 0; i <= 7; ++i) {
            if (this.theBoxes[i] == null) continue;
            this.theBoxes[i].setVisible(false);
            this.theBoxes[i].locate();
            this.theBoxes[i].setVisible(true);
            if (!(this.theParentContainer instanceof JLayeredPane)) continue;
            String sName = ((DesignAnchoringLayoutManager)theParent.theLayoutManager).getName(this.theBoxes[i]);
            ((JLayeredPane)this.theParentContainer).setLayer(this.theBoxes[i], this.theMetaObject.iDisplayLayer);
            if (sName == null) continue;
            ((DesignAnchoringLayoutManager)theParent.theLayoutManager).addLayoutComponent(sName, this.theBoxes[i]);
            ((DesignAnchoringLayoutManager)theParent.theLayoutManager).setAnchoring(this.theBoxes[i], this.theMetaObject, this.theMetaObject.bLeftAnchoring, this.theMetaObject.bRightAnchoring, this.theMetaObject.bTopAnchoring, this.theMetaObject.bBottomAnchoring);
        }
    }

    public void resizeSizeBoxes() {
        int iWidth = this.theDesignCockpit.thePreferences.iSizeBoxWidth;
        int iHeight = this.theDesignCockpit.thePreferences.iSizeBoxHeight;
        for (int iBox = 0; iBox <= 7; ++iBox) {
            if (this.theBoxes[iBox] == null) continue;
            this.theBoxes[iBox].setSize(iWidth, iHeight);
        }
    }
}

