/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageClassDialog;
import ch.abacus.lib.ui.JACheckBox;
import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.BorderFactory;

public class ManageClassPageAttributes
extends JAPanel {
    private final ManageClassDialog theDialog;
    private final MetaClass theClass;
    private JATextField classFullName;
    private JATextField classSuperclassName;
    private JATextField classSuperclassFullName;
    private DisplayClasses classDisplayClass;
    private JACheckBox classHidden;
    private JACheckBox classSkipDeclarations;
    private JACheckBox classDesignBorders;
    private JACheckBox classSkipDefaultListeners;
    private ContainerTypes classContainerType;
    private Custom classCustom;
    private ClassFactoryClasses classClassFactory;
    private DesignEditorClasses classDesignEditor;
    private JAPanel panel;
    private TreeSet theDisplayClasses = new TreeSet();
    private TreeSet theCustom = new TreeSet();
    private TreeSet theClassFactoryClasses = new TreeSet();
    private TreeSet theDesignEditorClasses = new TreeSet();

    public ManageClassPageAttributes(ManageClassDialog manageClassDialog, MetaClass theClass) {
        super((LayoutManager)new BorderLayout());
        this.theDialog = manageClassDialog;
        this.theClass = theClass;
        this.createLists();
        this.initDisplay();
        this.populateDisplay();
    }

    private void initDisplay() {
        this.panel = new JAPanel((LayoutManager)new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.classFullName = new JATextField();
        this.classSuperclassName = new JATextField();
        this.classSuperclassFullName = new JATextField();
        this.classDisplayClass = new DisplayClasses();
        this.classHidden = new JACheckBox("Hidden");
        this.classSkipDeclarations = new JACheckBox("Skip Declarations");
        this.classDesignBorders = new JACheckBox("Design Borders");
        this.classSkipDefaultListeners = new JACheckBox("Skip Default Listeners");
        this.classContainerType = new ContainerTypes();
        this.classCustom = new Custom();
        this.classClassFactory = new ClassFactoryClasses();
        this.classDesignEditor = new DesignEditorClasses();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panel.add((Component)new JALabel("Full Class Name"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)this.classFullName, (Object)c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Superclass name"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)this.classSuperclassName, (Object)c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Superclass Full Path"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)this.classSuperclassFullName, (Object)c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Display"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)((Object)this.classDisplayClass), (Object)c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)this.classHidden, (Object)c);
        c.gridy = 5;
        this.panel.add((Component)this.classSkipDeclarations, (Object)c);
        c.gridy = 6;
        this.panel.add((Component)this.classDesignBorders, (Object)c);
        c.gridy = 7;
        this.panel.add((Component)this.classSkipDefaultListeners, (Object)c);
        c.gridx = 0;
        c.gridy = 8;
        this.panel.add((Component)new JALabel("Container Type"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)((Object)this.classContainerType), (Object)c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Custom"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)((Object)this.classCustom), (Object)c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Class factory"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)((Object)this.classClassFactory), (Object)c);
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panel.add((Component)new JALabel("Design Editor"), (Object)c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panel.add((Component)((Object)this.classDesignEditor), (Object)c);
        this.add((Component)this.panel, "North");
    }

    private void populateDisplay() {
        this.classFullName.setText(this.theClass.getMetadata().sFullClassName);
        this.classSuperclassName.setText(this.theClass.getMetadata().getSuperClassName());
        this.classSuperclassFullName.setText(this.theClass.getMetadata().getFullPathOfSuperClass());
        this.classDisplayClass.selectDisplayClass(this.theClass.getMetadata().sDisplayClass);
        this.classHidden.setSelected(this.theClass.getMetadata().bHidden);
        this.classSkipDeclarations.setSelected(this.theClass.getMetadata().bSkipDecl);
        this.classDesignBorders.setSelected(this.theClass.getMetadata().bDesignBorders);
        this.classSkipDefaultListeners.setSelected(this.theClass.getMetadata().bDefaultListeners);
        this.classContainerType.selectContainerType(this.theClass.getMetadata().containerType.getContainerTypeAsString());
        this.classCustom.selectCustom(this.theClass.getMetadata().sCustomCodeGenerationMethod);
        this.classClassFactory.selectFactoryClass(this.theClass.getMetadata().theFactoryName);
        this.classDesignEditor.selectDesignEditorClass(this.theClass.getMetadata().theDesignEditor);
    }

    void commitAttributes() {
        this.theClass.getMetadata().sFullClassName = this.classFullName.getText();
        this.theClass.getMetadata().setSuperClassName(this.classSuperclassName.getText());
        this.theClass.getMetadata().setFullPathOfSuperClass(this.classSuperclassFullName.getText());
        this.theClass.getMetadata().sDisplayClass = (String)this.classDisplayClass.getSelectedItem();
        this.theClass.getMetadata().bHidden = this.classHidden.isSelected();
        this.theClass.getMetadata().bSkipDecl = this.classSkipDeclarations.isSelected();
        this.theClass.getMetadata().bDesignBorders = this.classDesignBorders.isSelected();
        this.theClass.getMetadata().bDefaultListeners = this.classSkipDefaultListeners.isSelected();
        this.theClass.getMetadata().containerType.setContainerType((String)this.classContainerType.getSelectedItem());
        this.theClass.getMetadata().sCustomCodeGenerationMethod = (String)this.classCustom.getSelectedItem();
        this.theClass.getMetadata().theFactoryName = (String)this.classClassFactory.getSelectedItem();
        this.theClass.getMetadata().theDesignEditor = (String)this.classDesignEditor.getSelectedItem();
    }

    private void createLists() {
        ArrayList classes = new ArrayList();
        MetaClass firstClass = this.theDialog.theEditor.theMetadataDispenser.getFirstClass();
        this.enumerateClasses(firstClass, classes);
        for (MetaClass metaClass : classes) {
            String sDesignEditorClasses;
            String sClassFactoryClasses;
            String sCustom;
            String sDisplayClass = metaClass.getMetadata().sDisplayClass;
            if (sDisplayClass != null && !sDisplayClass.equals("")) {
                this.theDisplayClasses.add(sDisplayClass);
            }
            if ((sCustom = metaClass.getMetadata().sCustomCodeGenerationMethod) != null && !sCustom.equals("")) {
                this.theCustom.add(sCustom);
            }
            if ((sClassFactoryClasses = metaClass.getMetadata().theFactoryName) != null && !sClassFactoryClasses.equals("")) {
                this.theClassFactoryClasses.add(sClassFactoryClasses);
            }
            if ((sDesignEditorClasses = metaClass.getMetadata().theDesignEditor) == null || sDesignEditorClasses.equals("")) continue;
            this.theDesignEditorClasses.add(sClassFactoryClasses);
        }
    }

    void enumerateClasses(MetaClass theFirstClass, ArrayList classes) {
        for (MetaClass currClass = theFirstClass; currClass != null; currClass = currClass.getNextSibling()) {
            classes.add(currClass);
            if (currClass.getFirstClass() == null) continue;
            this.enumerateClasses(currClass.getFirstClass(), classes);
        }
    }

    class DesignEditorClasses
    extends JAComboBox {
        public DesignEditorClasses() {
            super(ManageClassPageAttributes.this.theDesignEditorClasses.toArray());
            this.setEditable(true);
        }

        public void selectDesignEditorClass(String sClass) {
            this.setSelectedItem(sClass);
        }
    }

    class ClassFactoryClasses
    extends JAComboBox {
        public ClassFactoryClasses() {
            super(ManageClassPageAttributes.this.theClassFactoryClasses.toArray());
            this.setEditable(true);
        }

        public void selectFactoryClass(String sClass) {
            this.setSelectedItem(sClass);
        }
    }

    class Custom
    extends JAComboBox {
        public Custom() {
            super(ManageClassPageAttributes.this.theCustom.toArray());
            this.setEditable(true);
        }

        public void selectCustom(String sCustom) {
            this.setSelectedItem(sCustom);
        }
    }

    class DisplayClasses
    extends JAComboBox {
        public DisplayClasses() {
            super(ManageClassPageAttributes.this.theDisplayClasses.toArray());
            this.setEditable(true);
        }

        public void selectDisplayClass(String sClass) {
            this.setSelectedItem(sClass);
        }
    }

    class ContainerTypes
    extends JAComboBox {
        public ContainerTypes() {
            super((Object[])new String[]{"", "frame", "panel", "hsplit", "vsplit", "tabbedpane", "tabpage", "scrollingpanel", "group"});
        }

        public void selectContainerType(String sContainerType) {
            this.setSelectedItem(sContainerType);
        }
    }
}

