// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;

/**
 * <tt>Node</tt> is a Node in a doubly-linked list.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class Node implements Serializable, org.w3c.dom.Node
  {
  private static final NodeList EMPTY_NODE_LIST = new NodeList();

  public NodeList list; // the list that i belong to, or null if i have none
  public Node prev; // my previous sibling
  public Node next; // my next sibling

  // ********** NODE ********************************************************

  /**
   * Return myself.
   */
  public Node getNode()
    {
    return this;
    }

  /**
   * Return my previous sibling, or null if I have none.
   */
  public Node getPreviousSiblingNode()
    {
    return (prev == null ? prev : prev.getNode());
    }

  /**
   * Return my next sibling, or null if I have none.
   */
  public Node getNextSiblingNode()
    {
    return (next == null ? null : next.getNode());
    }

  // ********** SIBLINGS ****************************************************

  /**
   * Set my next sibling to be the specified node.
   * If the node is already a member of a list, remove it from that list.
   * @param node The node to add
   */
  public void setNextSiblingNode( Node node )
    {
    list.addSiblingNode( this, node );
    }

  /**
   * Set my previous sibling to be the specified node.
   * If the node is already a member of a list, remove it from that list.
   * @param node The node to add
   */
  public void setPreviousSiblingNode( Node node )
    {
    list.insertSiblingNode( this, node );
    }

  // ********** REMOVE ******************************************************

  /**
   * If I am in a list, remove myself and return true, otherwise return false.
   */
  public boolean remove()
    {
    if( list != null )
      {
      list.remove( this );
      return true;
      }
    else
      {
      return false;
      }
    }

  // ********** WRITING *****************************************************

  /**
   * @param writer
   * @throws IOException
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    }

  // ********** DOM *********************************************************

  /**
   * Returns whether this node (if it is an element) has any attributes.
   */
  public boolean hasAttributes()
    {
    return false;
    }

  /**
   * Returns the local part of the qualified name of this node.
   * For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes
   * created with a DOM Level 1 method, such as createElement from the Document
   * interface, this is always null.
   */
  public String getLocalName()
    {
    return null;
    }

  /**
   * Returns whether this node has any children.
   */
  public boolean hasChildNodes()
    {
    return false;
    }

  /**
   * Return a NodeList that contains all children of this node.
   * If there are no children, this is a NodeList containing no nodes.
   */
  public org.w3c.dom.NodeList getChildNodes()
    {
    return EMPTY_NODE_LIST;
    }

  /**
   * Return the first child of this node.
   * If there is no such node, this returns null.
   */
  public org.w3c.dom.Node getFirstChild()
    {
    return null;
    }

  /**
   * Return the last child of this node.
   * If there is no such node, this returns null.
   */
  public org.w3c.dom.Node getLastChild()
    {
    return null;
    }

  /**
   * Return the parent of this node. All nodes, except Attr, Document,
   * DocumentFragment, Entity, and Notation may have a parent. However, if
   * a node has just been created and not yet added to the tree, or if it
   * has been removed from the tree, this is null.
   */
  public org.w3c.dom.Node getParentNode()
    {
    return null;
    }

  /**
   * Return a code representing the type of the underlying object.
   */
  public short getNodeType()
    {
    return 0;
    }

  /**
   * Return the name of this node, depending on its type.
   */
  public String getNodeName()
    {
    return null;
    }

  /**
   * Return the value of this node, depending on its type.
   * When it is defined to be null, setting it has no effect.
   */
  public String getNodeValue()
    {
    return null;
    }

  /**
   * Set the value of this node, depending on its type.
   * @param nodeValue
   */
  public void setNodeValue( String nodeValue )
    {
    }

  /**
   * Return the namespace URI of this node, or null if it is unspecified.
   * This is not a computed value that is the result of a namespace lookup
   * based on an examination of the namespace declarations in scope. It is
   * merely the namespace URI given at creation time.
   * For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes
   * created with a DOM Level 1 method, such as createElement from the Document
   * interface, this is always null. Per the Namespaces in XML Specification
   * an attribute does not inherit its namespace from the element it is attached
   * to. If an attribute is not explicitly given a namespace, it simply has no namespace.
   */
  public String getNamespaceURI()
    {
    return null;
    }

  /**
   * Return the namespace prefix of this node, or null if it is unspecified.
   * Note that setting this attribute, when permitted, changes the nodeName attribute,
   * which holds the qualified name, as well as the tagName and name attributes of
   * the Element and Attr interfaces, when applicable.
   * Note also that changing the prefix of an attribute that is known to have a
   * default value, does not make a new attribute with the default value and the
   * original prefix appear, since the namespaceURI and localName do not change.
   * For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes
   * created with a DOM Level 1 method, such as createElement from the Document
   * interface, this is always null.
   */
  public String getPrefix()
    {
    return null;
    }

  /**
   * Set the namespace prefix of this node.
   * @param prefix The new namespace prefix.
   */
  public void setPrefix( String prefix )
    {
    }

  /**
   * Return the node immediately following this node.
   * If there is no such node, this returns null.
   */
  public org.w3c.dom.Node getNextSibling()
    {
    return getNextSiblingNode();
    }

  /**
   * Return the node immediately preceding this node.
   * If there is no such node, this returns null.
   */
  public org.w3c.dom.Node getPreviousSibling()
    {
    return getPreviousSiblingNode();
    }

  /**
   * Return the Document object associated with this node. This is also the
   * Document object used to create new nodes. When this node is a Document
   * or a DocumentType which is not used with any Document yet, this is null.
   */
  public org.w3c.dom.Document getOwnerDocument()
    {
    return null;
    }

  /**
   * Adds the node newChild to the end of the list of children of this node.
   * If the newChild is already in the tree, it is first removed.
   * @param newChild The node to add.If it is a DocumentFragment object, the
   * entire contents of the document fragment are moved into the child list of this node
   */
  public org.w3c.dom.Node appendChild( org.w3c.dom.Node newChild )
    {
    throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.HIERARCHY_REQUEST_ERR, "HIERARCHY_REQUEST_ERR" );
    }

  /**
   * Removes the child node indicated by oldChild from the list of children, and returns it.
   * @param oldChild The node being removed.
   */
  public org.w3c.dom.Node removeChild( org.w3c.dom.Node oldChild )
    {
    throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.HIERARCHY_REQUEST_ERR, "HIERARCHY_REQUEST_ERR" );
    }

  /**
   * Replaces the child node oldChild with newChild in the list of children,
   * and returns the oldChild node. If newChild is a DocumentFragment object,
   * oldChild is replaced by all of the DocumentFragment children, which are
   * inserted in the same order. If the newChild is already in the tree, it
   * is first removed.
   * @param newChild The new node to put in the child list.
   * @param oldChild The node being replaced in the list.
   */
  public org.w3c.dom.Node replaceChild( org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild )
    {
    throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.HIERARCHY_REQUEST_ERR, "HIERARCHY_REQUEST_ERR" );
    }

  /**
   * Inserts the node newChild before the existing child node refChild.
   * If refChild is null, insert newChild at the end of the list of children.
   * If newChild is a DocumentFragment object, all of its children are inserted,
   * in the same order, before refChild. If the newChild is already in the tree,
   * it is first removed.
   * @param newChild The node to insert.
   * @param oldChild The reference node, i.e., the node before which the new node must be inserted.
   */
  public org.w3c.dom.Node insertBefore( org.w3c.dom.Node newChild, org.w3c.dom.Node refChild )
    {
    throw new org.w3c.dom.DOMException( org.w3c.dom.DOMException.HIERARCHY_REQUEST_ERR, "HIERARCHY_REQUEST_ERR" );
    }

  /**
   * Return a duplicate of this node, i.e., serve as a generic copy constructor
   * for nodes. The duplicate node has no parent; ( parentNode is null.).
   * Cloning an Element copies all attributes and their values, including those
   * generated by the XML processor to represent defaulted attributes, but
   * this method does not copy any text it contains unless it is a deep clone,
   * since the text is contained in a child Text node. Cloning an Attribute
   * directly, as opposed to be cloned as part of an Element cloning operation,
   * returns a specified attribute (specified is true). Cloning any other type
   * of node simply returns a copy of this node. Note that cloning an immutable
   * subtree results in a mutable copy, but the children of an EntityReference
   * clone are readonly. In addition, clones of unspecified Attr nodes are
   * specified. And, cloning Document, DocumentType, Entity, and Notation nodes
   * is implementation dependent.
   * @param deep If true, recursively clone the subtree under the specified node;
   * if false, clone only the node itself (and its attributes, if it is an Element).
   */
  public org.w3c.dom.Node cloneNode( boolean deep )
    {
    return null;
    }

  /**
   * Puts all Text nodes in the full depth of the sub-tree underneath this Node,
   * including attribute nodes, into a "normal" form where only structure
   * (e.g., elements, comments, processing instructions, CDATA sections,
   * and entity references) separates Text nodes, i.e., there are neither
   * adjacent Text nodes nor empty Text nodes. This can be used to ensure that
   * the DOM view of a document is the same as if it were saved and re-loaded,
   * and is useful when operations (such as XPointer lookups) that depend on
   * a particular document tree structure are to be used. In cases where the
   * document contains CDATASections, the normalize operation alone may not
   * be sufficient, since XPointers do not differentiate between Text nodes
   * and CDATASection nodes.
   */
  public void normalize()
    {
    // do nothing, since EXML always normalizes
    }

  /**
   * Return a NamedNodeMap containing the attributes of this node
   * (if it is an Element) or null otherwise
   */
  public org.w3c.dom.NamedNodeMap getAttributes()
    {
    return null;
    }

  /**
   * Return true if this DOM implementation implements a specific feature
   * and that feature is supported by this node.
   * @param feature The name of the feature to test. This is the same name
   * which can be passed to the method hasFeature on DOMImplementation.
   * @param version The version number of the feature to test. In Level 2,
   * version 1, this is the string "2.0". If the version is not specified,
   * supporting any version of the feature will cause the method to return true.
   */
  public boolean isSupported( String feature, String version )
    {
    if( feature.equalsIgnoreCase( "core" ) )
      return true;

    return false;
    }
  }