// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;

/**
 * <tt>DefaultNodeWriter</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class NodeWriter
  {
  protected static int defaultStep = 2;
  protected static String defaultEOL = "\r\n";

  protected Writer writer;
  protected int indent;
  protected int step;
  protected boolean expandEmptyElements;
  protected String eol;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param writer
   */
  public NodeWriter( Writer writer )
    {
    this( writer, 0, false, defaultStep, defaultEOL );
    }

  /**
   * @param writer
   * @param indent
   * @param expandEmptyElements
   */
  public NodeWriter( Writer writer, int indent, boolean expandEmptyElements )
    {
    this( writer, indent, expandEmptyElements, defaultStep, defaultEOL );
    }

  /**
   * @param writer
   * @param indent
   * @param expandEmptyElements
   * @param step
   */
  public NodeWriter( Writer writer, int indent, boolean expandEmptyElements, int step, String eol )
    {
    this.writer = writer;
    this.indent = indent;
    this.expandEmptyElements = expandEmptyElements;
    this.step = step;
    this.eol = eol;
    }

  // ********** INDENTATION *************************************************

  /**
   *
   */
  public int getIndent()
    {
    return indent;
    }

  /**
   * @param indent
   */
  public void setIndent( int indent )
    {
    this.indent = indent;
    }

  /**
   *
   */
  public void increaseIndent()
    {
    this.indent += step;
    }

  /**
   *
   */
  public void decreaseIndent()
    {
    this.indent -= step;
    }

  /**
   * @param step
   */
  public static void setDefaultStep( int step )
    {
    defaultStep = step;
    }

  /**
   *
   */
  public static int getDefaultStep()
    {
    return defaultStep;
    }

  // ********** END OF LINE *************************************************

  /**
   *
   */
  public String getEOL()
    {
    return eol;
    }

  /**
   * @param eol
   */
  public void setEOL( String eol )
    {
    this.eol = eol;
    }

  /**
   * @param eol
   */
  public static void setDefaultEOL( String eol )
    {
    defaultEOL = eol;
    }

  /**
   *
   */
  public static String getDefaultEOL()
    {
    return defaultEOL;
    }

  // ********** EXPANDING EMPTY ELEMENTS ************************************

  /**
   *
   */
  public boolean getExpandEmptyElements()
    {
    return expandEmptyElements;
    }

  /**
   * @param flag
   */
  public void setExpandEmptyElements( boolean flag )
    {
    this.expandEmptyElements = flag;
    }

  // ********** WRITING *****************************************************

  /**
   * @param node
   * @throws IOException
   */
  public void write( Node node )
    throws IOException
    {
    node.write( this );
    }

  /**
   * @param string
   * @throws IOException
   */
  public void write( String string )
    throws IOException
    {
    writer.write( string );
    }

  /**
   * @param ch
   * @throws IOException
   */
  public void write( char ch )
    throws IOException
    {
    writer.write( ch );
    }

  /**
   * @param chars
   * @param offset
   * @param length
   * @throws IOException
   */
  public void write( char[] chars, int offset, int length )
    throws IOException
    {
    writer.write( chars, offset, length );
    }

  /**
   * @throws IOException
   */
  public void writeIndent()
    throws IOException
    {
    for( int i = 0; i < indent; i++ )
      writer.write( ' ' );
    }

  /**
   * @throws IOException
   */
  public void writeEOL()
    throws IOException
    {
    writer.write( eol );
    }
  }