// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.util.*;

/**
 * <tt>Nodes</tt> is an enumeration over a collection of nodes.
 * To iterate through the collection in a typesafe way, use current(), first() and next().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class Nodes implements Enumeration
  {
  protected NodeList list;
  protected Node current;

  // ********** CONSTRUCTION ************************************************

  /**
   *
   */
  public Nodes()
    {
    list = new NodeList();
    reset();
    }

  /**
   * @param list
   */
  public Nodes( NodeList list )
    {
    this.list = list;
    reset();
    }

  /**
   * @param node
   */
  public Nodes( Node node )
    {
    NodeList list = new NodeList();
    list.append( node );
    this.list = list;
    reset();
    }

  // ********** ENUMERATION METHODS *****************************************

  /**
   * Return true if there are more Nodes to read in the enumeration.
   */
  public boolean hasMoreElements()
    {
    return (current != null);
    }

  /**
   * Return the current Node and then advance to the next one if present.
   */
  public Object nextElement()
    {
    return nextNode();
    }

  // ********** ITERATION ***************************************************

  /**
   * Move to the first Node.
   */
  public void reset()
    {
    current = list.first;
    }

  /**
   * Return the current Node, or null if there is none.
   */
  public Node currentNode()
    {
    return (current == null ? null : current.getNode());
    }

  /**
   * Move to the first Node and return it, or null if there is none.
   */
  public Node firstNode()
    {
    reset();
    return currentNode();
    }

  /**
   * Return the current Node and then advance to the next one if present.
   */
  public Node nextNode()
    {
    if( current == null )
      return null;

    Node node = (Node) current.getNode();
    current = current.next;
    return node;
    }

  /**
   * Return the number of Nodes in the list.
   */
  public int size()
    {
    return list.size();
    }

  /**
   * Remove all the nodes from the current Node to the last Node.
   */
  public void remove()
    {
    while( hasMoreElements() )
      nextNode().remove();
    }

  /**
   * Return my underlying NodeList.
   */
  public NodeList getNodeList()
    {
    return list;
    }
  }