// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.apache;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>TreeMapType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class TreeMapType extends Type
  {
  public TreeMapType()
    {
    // don't generate client-side java bindings for these serializers
    setInhibit( true );
    }

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );
    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "treemap" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );
    Element element = sequence.addElement( xsdPrefix, "element" );
    element.setAttribute( "name", "item" );
    element.setAttribute( "minOccurs", "0" );
    element.setAttribute( "maxOccurs", "unbounded" );
    Element subType = element.addElement( xsdPrefix, "complexType" );
    Element subSequence = subType.addElement( xsdPrefix, "sequence" );
    Element key = subSequence.addElement( xsdPrefix, "element" );
    key.setAttribute( "name", "key" );
    key.setAttribute( "type", getName( key, Object.class ) );
    Element value = subSequence.addElement( xsdPrefix, "element" );
    value.setAttribute( "name", "value" );
    value.setAttribute( "type", getName( value, Object.class ) );
    }

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    TreeMap treemap = (TreeMap) object;
    Iterator entries = treemap.entrySet().iterator();

    while( entries.hasNext() )
      {
      Map.Entry entry = (Map.Entry) entries.next();
      IWriter itemWriter = writer.writeElement( "item" );
      itemWriter.writeObject( "key", entry.getKey() );
      itemWriter.writeObject( "value", entry.getValue() );
      }
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    IReader[] readers = reader.getReaders( "item" );
    TreeMap map = (TreeMap) value.getObject();

    if( map == null )
      {
      map = new TreeMap();
      value.setObject( map );
      }

    for( int i = 0; i < readers.length; i++ )
      {
      IReader itemReader = readers[ i ];
      Object key = itemReader.readObject( "key" );
      Object theValue = itemReader.readObject( "value" );
      map.put( key, theValue );
      }
    }
  }