// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.net;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>HashtableType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class HashtableType extends CollectionType
  {
  // ********** SCHEMA ******************************************************

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    Type type = getType( OBJECT_ARRAY_CLASS );
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );

    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "Hashtable" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );

    Element keys = sequence.addElement( xsdPrefix, "element" );
    keys.setAttribute( "name", "keys" );
    keys.setAttribute( "type", getName( type.getNamespace(), type.getName(), keys ) );

    Element values = sequence.addElement( xsdPrefix, "element" );
    values.setAttribute( "name", "values" );
    values.setAttribute( "type", getName( type.getNamespace(), type.getName(), values ) );
    }

  // ********** XML SERIALIZATION *******************************************

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    Hashtable table = (Hashtable) object;
    Object[] keys = new Object[ table.size() ];
    Object[] values = new Object[ table.size() ];
    Enumeration keyEnum = table.keys();
    Enumeration valueEnum = table.elements();

    // assumes that keys are returned in same order as values
    for( int i = 0; i < keys.length; i++ )
      {
      keys[ i ] = keyEnum.nextElement();
      values[ i ] = valueEnum.nextElement();
      }

    writeArray( writer, "keys", keys );
    writeArray( writer, "values", values );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    Hashtable hashtable = (Hashtable) value.getObject();

    if( hashtable == null )
      {
      hashtable = new Hashtable();
      value.setObject( hashtable );
      }

    Object[] keys = readArray( reader, "keys" );
    Object[] values = readArray( reader, "values" );

    for( int i = 0; i < keys.length; i++ )
      hashtable.put( keys[ i ], values[ i ] );
    }
  }