// copyright 2001-2002 by The Mind Electric

package electric.xml.tools;

import org.xml.sax.*;
import java.io.*;
import electric.util.*;
import electric.util.io.*;
import electric.xml.*;
import electric.xml.sax.*;

/**
 * <tt>Parse</tt> parses XML files and displays performance statistics.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class Parse
  {
  private static String filename = null;
  private static boolean keepWhitespace = false;
  private static boolean silent = false;
  private static int count = 1;
  private static boolean useSAX = false;

  // ********** MAIN PROGRAM ************************************************

  /**
   * @param args
   */
  public static void main( String[] args )
    {
    if( args.length == 0 )
      {
      printUsage();
      return;
      }

    try
      {
      processArgs( args );
      parse();
      }
    catch( Throwable throwable )
      {
      throwable.printStackTrace();
      printUsage();
      System.exit( -1 );
      }
    }

  // ********** USAGE *******************************************************

  /**
   *
   */
  private static void printUsage()
    {
    System.out.println( "usage: parse filename [-n count] [-s] [-w] [-x]" );
    System.out.println();
    System.out.println( "where:" );
    System.out.println( "  filename = name of XML path to parse" );
    System.out.println( "  -n count = number of times to parse, 1 by default" );
    System.out.println( "  -s       = silent, don't print document" );
    System.out.println( "  -w       = keep whitespace" );
    System.out.println( "  -x       = use SAX parser instead of DOM" );
    System.out.println();
    System.out.println( "examples:" );
    System.out.println();
    System.out.println( "parse myfile.xml" );
    System.out.println( "  parse myfile.xml once, display statistics" );
    System.out.println();
    System.out.println( "parse myfile.xml -n 10 -w" );
    System.out.println( "  parse myfile.xml 10 times, keep whitespace, display statistics" );
    }

  // ********** PROCESS ARGUMENTS *******************************************

  /**
   * @param args
   * @throws Throwable
   */
  private static void processArgs( String[] args )
    throws Throwable
    {
    for( int i = 0; i < args.length; i++ )
      {
      if( !args[ i ].startsWith( "-" ) )
        {
        filename = args[ i ];
        }
      else
        {
        if( args[ i ].length() == 1 )
          throw new IllegalArgumentException( "a plain - is not a valid argument" );

        switch( args[ i ].charAt( 1 ) )
          {
          case 'n':
            String n = Strings.getString( "n", args, ++i );
            count = Integer.parseInt( n );
            break;

          case 's':
            silent = true;
            break;

          case 'w':
            keepWhitespace = true;
            break;

          case 'x':
            useSAX = true;
            break;

          default:
            throw new IllegalArgumentException( "illegal argument " + args[ i ].charAt( 1 ) );
          }
        }
      }
    }

  // ********** PARSE *******************************************************

  /**
   * @throws IOException
   * @throws ParseException
   */
  private static void parse()
    throws IOException, ParseException, SAXException
    {
    File file = new File( filename );
    byte[] bytes = Streams.readFully( file );
    Document document = null;
    long start = System.currentTimeMillis();

    for( int i = 0; i < count; i++ )
      {
      if( useSAX )
        {
        new SAXParser().parse( bytes );
        }
      else
        {
        if( keepWhitespace )
          document = new Document( bytes, Document.KEEP_WHITESPACE );
        else
          document = new Document( bytes );
        }
      }

    long stop = System.currentTimeMillis();
    long milliseconds = stop - start;
    System.out.println( "total parsing time = " + milliseconds + "ms" );

    if( count > 1 )
      System.out.println( "individial parsing time = " + ((float) milliseconds / count) + "ms" );

    if( (!silent )&& (!useSAX) )
      {
      System.out.println();
      System.out.println( document );
      }
    }
  }