// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import java.util.*;
import electric.xml.*;

/**
 * <tt>HashtableNamespaceContext</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class HashtableNamespaceContext implements INamespaceContext
  {
  private Hashtable prefixToNamespace;

  // ********** NAMESPACES **************************************************

  /**
   * @param prefix
   * @param namespace
   */
  public synchronized void setNamespace( String prefix, String namespace )
    {
    if( prefixToNamespace == null )
      prefixToNamespace = new Hashtable();

    prefixToNamespace.put( prefix, namespace );
    }

  /**
   * @param prefix
   */
  public synchronized String getNamespace( String prefix )
    {
    if( prefixToNamespace == null )
      return null;

    return (String) prefixToNamespace.get( prefix );
    }
  }