/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.text;

import javax.swing.text.*;
import javax.swing.event.*;

/**
 * Implements a document with optimal syntax highlighting.
 */
public class CSyntaxDocument extends DefaultStyledDocument {

  public CSyntaxDocument(Content c, StyleContext styles) {
    super(c, styles);
  }

  public CSyntaxDocument(StyleContext styles) {
    super(styles);
  }

  public CSyntaxDocument() {
  }

  public void updateAttributes(int start, int end, AttributeSet s) {

    DefaultDocumentEvent changes =
      new DefaultDocumentEvent(start, end - start, DocumentEvent.EventType.CHANGE);

    // split elements that need it
    buffer.change(start, end - start, changes);

    // PENDING(prinz) - this isn't a very efficient way to iterate
    int lastEnd = Integer.MAX_VALUE;
    for (int pos = start; pos < end; pos = lastEnd) {
      Element run = getCharacterElement(pos);
      lastEnd = run.getEndOffset();
      MutableAttributeSet attr = (MutableAttributeSet) run.getAttributes();
      attr.removeAttributes(attr);
      attr.addAttributes(s);
    }

    changes.end();
    fireChangedUpdate(changes);
  }

  /**
   * Performs the syntax highlighting.
   * @param start a start position.
   * @param end an end position.
   */
  public synchronized void performHighlight(CAbstractHighlighter highlighter,
    int start, int end) {

    String commentTag = (String) highlighter.getCommentAttribute().
      getAttribute(StyleConstants.NameAttribute);
    commentTag = (commentTag == null) ? "Comment" : commentTag;

    try {
      writeLock();

      try {
        int pos = start;
        String text = getText(start, getLength() - start);
        highlighter.setBuffer(text);
        String token = highlighter.gotoNextToken();

        while (token.length() > 0) {
          updateAttributes(pos, pos + token.length(), highlighter.getAttribute());

          pos += token.length();

          if (pos > end) {
            // Tests for different style to comment
            Element element = getCharacterElement(pos + 1);
            String attrTag = (String) element.getAttributes().getAttribute(
              StyleConstants.NameAttribute);
            if (!commentTag.equals(attrTag))
              break;
            // Tests for multiline comment
            if (highlighter.isMultilineComment())
              break;
          }

          token = highlighter.gotoNextToken();
        }
      }
      catch (Exception e) {
        e.printStackTrace();
      }

    }
    finally {
      writeUnlock();
    }
  }

}