/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;

import javax.swing.table.AbstractTableModel;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:36:12 PM
 * To change this template use Options | File Templates.
 */

public class LizardClassListenerTableModel extends AbstractTableModel {

    public MetadataDispenser theMetadataDispenser;
    MetaClass theMetaClass = null;
    MetaClassDetail[] theListeners = null;
    int iListenerCount = 0;

    public int getRowCount() {
        if (theMetaClass != null)
            return iListenerCount;
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        if (column == 1) {
            Boolean boolNewValue = (Boolean) theNewValue;
            if (boolNewValue.booleanValue() == true)
                theMetaClass.addListener(theListeners[row].sClassName, theMetadataDispenser);
            else
                theMetaClass.removeListener(theListeners[row].sClassName);
        }
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            String sListenerName = theListeners[row].sClassName;
            return sListenerName;
        } else
            return (theMetaClass.getListener(theListeners[row].sClassName) != null) ? new Boolean(true) : new Boolean(false);
    }

    public Class getColumnClass(int iColumn) {
        if (iColumn == 0)
            return "Listener".getClass();
        else
            return (new Boolean(true)).getClass();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0)
            return false;
        else
            return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0)
            return "Listener";
        else
            return "True/False";
    }

    public void Load(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        theMetaClass = objMetaClass;
        MetaClass theListener = theMetadataDispenser.getFirstListener();
        int i = 0;
        theListeners = new MetaClassDetail[theMetadataDispenser.getListenerCount()];
        while (theListener != null) {
            theListeners[i++] = new MetaClassDetail(theListener.getMetadata(), theMetadataDispenser);
            theListener = theListener.getNextSibling();
        }
        iListenerCount = i;
    }

    protected void clear() {
        iListenerCount = 0;
        theListeners = null;
    }
}
