/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.lang.reflect.Method;

public class LizardTypeComboBoxListener implements ItemListener {
    Object theReceiver = null;

    public LizardTypeComboBoxListener(Object objReceiver) {
        theReceiver = objReceiver;
    }

    public void itemStateChanged(ItemEvent event) {
        Class clsReceiver = theReceiver.getClass();
        Class[] clsParams = new Class[1];
        String s = (String) event.getItem();
        clsParams[0] = s.getClass();
        Object[] objParams = new Object[1];
        objParams[0] = s;
        if (event.getStateChange() == ItemEvent.DESELECTED)
            return;
        try {
            Method m = clsReceiver.getMethod("typeChanged", clsParams);
            if (m != null) {
                try {
                    m.invoke(theReceiver, objParams);
                } catch (java.lang.reflect.InvocationTargetException e1) {
                } catch (IllegalAccessException e2) {
                }
            }
        } catch (NoSuchMethodException e3) {
        }
    }
}
