/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.designcockpit.classEditor.LizardValueChoiceComboBox;
import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.lib.ui.renderer.common.*;

import javax.swing.*;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:32:04 PM
 * To change this template use Options | File Templates.
 */

public class LizardValueChoiceComboBoxModel extends AbstractListModel implements ComboBoxModel {
    Object objSelection = null;
    MetaPropertyDescriptor theProperty;
    public LizardValueChoiceComboBox theComboBox;
    ArrayList choices = new ArrayList(0);
    MetadataDispenser theMetadataDispenser;

    public LizardValueChoiceComboBoxModel(MetadataDispenser theMetadataDispenser) {
        super();
        this.theMetadataDispenser = theMetadataDispenser;
    }

    public void setSelectedItem(Object theSelection) {
        objSelection = theSelection;
    }

    public Object getSelectedItem() {
        return objSelection;
    }


    public Object getElementAt(int iIndex) {
        if (iIndex > choices.size())
            return null;
        else
            return choices.get(iIndex);
    }

    public int getSize() {
//        int iSize = 0;
//        if (theProperty!=null)
//            iSize = theProperty.getValueChoiceCount();
        return choices.size();
    }

    protected ArrayList LoadObjectNames(MetaObject theObject, ArrayList retVal) {
        MetaObject testObject = theObject.theFirstChild;
        while (testObject != null) {
            retVal.add(testObject.getName());
            retVal = LoadObjectNames(testObject, retVal);
            testObject = testObject.theNextObject;
        }
        return retVal;
    }

    public void Load(MetaPropertyDescriptor objProperty, MetaProject theMetaProject) {
        choices = new ArrayList(0);
        theProperty = objProperty;
        int iValues = theProperty.getValueChoiceCount();
        for (int i = 0; i < iValues; i++) {
            String theChoice = theProperty.getValueChoiceAsString(i);
            choices.add(theChoice);
        }
        if ((theProperty.bObjectPromptList) && (theMetaProject != null)) {
            choices.add(theMetaProject.getFirstObject().getName());
            choices = LoadObjectNames(theMetaProject.getFirstObject(), choices);
        }
        if(theProperty.bObjectReference)
        {
            ArrayList objRefList = theProperty.getObjectReferenceList();

            if(objRefList!=null)
            {
                for (int i = 0; i < objRefList.size(); i++) {
                    MetaObject theObject = (MetaObject)objRefList.get(i);
                    choices.add(theObject.getName());
                }
            }
        }
        if (theProperty.getIncludeTypeConstants() != null) {
            String theIncludedConstantType = theProperty.getIncludeTypeConstants().trim();
            MetaConstantGroup theGroup = theMetadataDispenser.findConstantGroup(theIncludedConstantType);
            if (theGroup != null) {
                ArrayList theConstants = theGroup.getConstantList();
                for (int i = 0; i < theConstants.size(); i++) {
                    choices.add(theConstants.get(i));
                }
            } else {
                MetaConstantGroupCollection theGroupCollection = theMetadataDispenser.findConstantGroupCollection(theIncludedConstantType);
                if (theGroupCollection != null) {
                    ArrayList theConstants = theGroupCollection.getConstantList();
                    for (int i = 0; i < theConstants.size(); i++) {
                        choices.add(theConstants.get(i));
                    }
                }
            }
        }
    }


    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        if (sText.trim().length() != 0) {
            // Find if this method already exists.
            int iValueChoices = theProperty.getValueChoiceCount();
            for (int j = 0; j < iValueChoices; j++) {
                if (theProperty.getValueChoiceAsString(j).equals(sText))
                    return new Boolean(true);
            }
            // If not, add it.
            Object sConfirmationText = "Do you wish to add this new default value '" + sText + "'?";
            String sConfirmationTitle = "New Default Value";
            int optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            int iChoice = JOptionPane.showConfirmDialog(null, sConfirmationText,
                    sConfirmationTitle, optionType, messageType);
            if (iChoice == 0) { // yes. Add it then.
                theProperty.addValueChoice(sText);
                theComboBox.Reload(theProperty);
                IDEFocusRequester.requestFocus((JComponent)theComboBox.theDefaultNextFocus);
                    // otherwise nothing gets the focus.

                return new Boolean(true);
            } else
                return new Boolean(false);
        }
        return new Boolean(true);
    }
}

