/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;

import javax.swing.table.AbstractTableModel;
import javax.swing.*;
import javax.swing.BorderFactory;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEAboutBox extends JADialog {
    private final SuperDesignCockpit theDesignCockpit;

    public IDEAboutBox (SuperDesignCockpit dc) {
        super(dc, dc.theLanguageManager.getMessage("AboutDialog.label", "About Design Cockpit"), true, false);
        theDesignCockpit = dc;
        LanguageManager lm = dc.theLanguageManager;

        if (theDesignCockpit.getOpenSourceState()==true)
                    this.setTitle("Abacus GUI Builder");

        JATabbedPane theAboutBoxPane = new JATabbedPane();
        theAboutBoxPane.setBorder(BorderFactory.createRaisedBevelBorder());

        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(theDesignCockpit);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel(theDesignCockpit);

        theAboutBoxPane.addTab(lm.getMessage("AboutDialog.VersionInformation.label", "Version Information"), theProductInfoPanel);
        theAboutBoxPane.addTab(lm.getMessage("AboutDialog.SystemInformation.label", "System Information"), theSystemInfoPanel);

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(theAboutBoxPane, BorderLayout.CENTER);
        JAPanel theButtonPanel = new JAPanel();
        theButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

        getContentPane().add(theButtonPanel, BorderLayout.SOUTH);
        JAButton theButton = new JAButton(lm.getMessage("Dialogs.OK", "OK"));
        theButtonPanel.add(theButton);
        theButton.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
                IDEAboutBox.this.hide();
            }
        });
        setResizable(true);
        setSize(600, 320);
        setLocationRelativeTo(null); // center on screen
        show(null) ;
    }

    class ProductInformationPanel extends JAPanel {
        public ProductInformationPanel (SuperDesignCockpit theDesignCockpit) {
            LanguageManager lm = theDesignCockpit.theLanguageManager;

            setLayout(new BorderLayout());
            String sHead = "<HTML><Body><CENTER>";
            String sFoot = "</Body></HTML>";

            String sDefaultToolName;
            if (theDesignCockpit.getOpenSourceState()== true)
                sDefaultToolName = "Abacus GUI Builder";
            else
                sDefaultToolName = "Abacus Design Cockpit";

            String sCaption = "<B>" +lm.getMessage("AboutDialog.VersionInformation.ToolName.label", sDefaultToolName) +"</b><BR><p>";

            String sVersion = lm.expandMessage("AboutDialog.VersionInformation.ToolVersion.label", "Version: {0}", String.valueOf(theDesignCockpit.iVersionNumber)) +"<P>";
            String sRevision = lm.expandMessage("AboutDialog.VersionInformation.ToolRevision.label", "Revision: {0}", String.valueOf(theDesignCockpit.iRevisionNumber)) +"<P>";
            String sSubRevision = lm.expandMessage("AboutDialog.VersionInformation.ToolSubRevision.label", "Sub Revsion: {0}", String.valueOf(theDesignCockpit.iSubRevisionNumber)) +"<P>";
            String sBuild = lm.expandMessage("AboutDialog.VersionInformation.ToolBuild.label" , "Build: {0}", String.valueOf(theDesignCockpit.iBuildNumber)) +"<P>";

            add(new JALabel(sHead +sCaption +sVersion +sRevision +sSubRevision +sBuild +sFoot, JLabel.CENTER), BorderLayout.CENTER);

        }
    }

    class SystemPropertyModel extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public SystemPropertyModel () {
        }

        public void addPair (String sName, String sValue) {
            ColumnOneValues.add(sName);
            ColumnTwoValues.add(sValue);
        }

        public int getRowCount () {
            return ColumnOneValues.size();
        }

        public Object getValueAt (int iRow, int iCol) {
            if (iCol == 0)
                return ColumnOneValues.get(iRow);
            else
                return ColumnTwoValues.get(iRow);
        }

        public String getColumnName (int iCol) {
            LanguageManager lm = theDesignCockpit.theLanguageManager;

            if (iCol == 0)
                return lm.getMessage("AboutDialog.SystemInformation.PropertyName.label", "Property");
            else
                return lm.getMessage("AboutDialog.SystemInformation.PropertyValue.label", "Value");
        }

        public int getColumnCount () {
            return 2;
        }
    }

    class SystemInformationPanel extends JAPanel {
        public SystemInformationPanel (SuperDesignCockpit theDesignCockpit) {
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            for (Enumeration e = sysprops.propertyNames(); e.hasMoreElements();) {
                String sPropName = (String) e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable(thePropertyModel);
            setLayout(new BorderLayout());
            add(new JAScrollPane(thePropertyTable));
        }
    }


}
