/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEClipboardController {
    static final int CLIPBOARD_NONE = 0;
    static final int CLIPBOARD_TEXT = 1;
    static final int CLIPBOARD_OBJECT = 2;
    int clipboardContent = CLIPBOARD_NONE;
    public int theCloneMode = MetaCloneMode.deepCopy;
    ArrayList theMetaObjects = new ArrayList(0);
    SuperDesignCockpit theDesignCockpit;
    AbstractAction lastClipboardBufferingAction = null;

    public IDEClipboardController(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void setClipboardContent(int content) {
        clipboardContent = content;
    }

    public int getClipboardContent() {
        return clipboardContent;
    }

    public void removeAllClipboardObjects() {
        theMetaObjects.clear();
    }

    public void removeClipboardObject(MetaObject theMetaObject) {
        theMetaObjects.remove(theMetaObject);
    }

    public IDEClipboardController getClone() {
        IDEClipboardController theReturnValue = new IDEClipboardController(theDesignCockpit);
        for (int i = 0; i < getClipboardObjectCount(); i++) {
            theReturnValue.addClipboardObject(getClipboardObject(i).Clone(new MetaCloneMode(MetaCloneMode.deepCopy), null, false));
        }
        return theReturnValue;
    }

    public void addClipboardObject(MetaObject theMetaObject) {
        // Assigns this project to the property values of the object.
        theMetaObject.attachToProject(theDesignCockpit.getDesignProject().theMetaProject);
        theMetaObjects.add(theMetaObject);
    }

    public int getClipboardObjectCount() {
        return theMetaObjects.size();
    }

    public MetaObject getClipboardObject(int i) {
        return (MetaObject) theMetaObjects.get(i);
    }

    public Point getOriginTopSelection() {
        Point pt = new Point(65535, 65535);
        for (int i = 0; i < theMetaObjects.size(); i++) {
            MetaObject testObject = (MetaObject) theMetaObjects.get(i);
            if ((testObject.isAbalet() == false) && (testObject.isFrame() == false)) { // always zero.
                Point ptLocation = new Point(testObject.iXLocation, testObject.iYLocation);
                if (pt.y > ptLocation.y)
                    pt = ptLocation;
                else if ((pt.y == ptLocation.y) && (pt.x > ptLocation.x))
                    pt = ptLocation;
            }
        }
        return pt;
    }

    public Point getOriginClipboardObject(MetaObject theTargetObject, int i, Point ptActualStrike, Point ptLastPopupLocation) {
        Point pt = getOriginTopSelection();
        MetaObject testObject = (MetaObject) theMetaObjects.get(i);
        Point ptLocation = testObject.getLocation();
//        return new Point(ptStrike.x + ptLocation.x - pt.x,
//                ptStrike.y + ptLocation.y - pt.y);
//        return new Point(pt.x, pt.y);
//        return new Point(ptLastPopupLocation.x, ptLastPopupLocation.y);
        return new Point(ptLastPopupLocation.x + ptLocation.x - pt.x,
                         ptLastPopupLocation.y + ptLocation.y - pt.y);
    }

    public void setClipboardBufferingAction(AbstractAction theAction) {
        lastClipboardBufferingAction = theAction;
    }

    public AbstractAction getClipboardBufferingAction() {
        return lastClipboardBufferingAction;
    }
}
