/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: Aril 5, 2004
 * Time: 6:33:43 PM
 */
public class IDEMethodComboModel extends DefaultComboBoxModel{
    MetaObject theMetaObject = null;
    MetaMethodLinkage[] theMethods = null;

    public IDEMethodComboModel() {
    }

    public Object getElementAt(int iIndex) {
        if ((iIndex < 0) || (theMethods == null) || (iIndex > theMethods.length - 1))
            return null;
        if ((theMethods != null) && (theMethods[iIndex] != null))
            return theMethods[iIndex].theMethod.getMethodName();
        else
            return null;
    }

    public int getSize() {
        int iSize = 0;
        if (theMetaObject != null)
            iSize = theMetaObject.getMethodCount();
        return iSize;
    }

    protected void Load(MetaObject someMetaObject) {
        int i = 0;
        theMetaObject = someMetaObject;
        if (theMetaObject.getMethodCount() != 0) {
            int iMethodCount = theMetaObject.getMethodCount();
            theMethods = new MetaMethodLinkage[iMethodCount];
            MetaMethodLinkage theMethod = someMetaObject.theFirstMethod;
            while (theMethod != null) {
                theMethods[i++] = theMethod;
                theMethod = theMethod.theNextMethod;
            }
        }
    }

    int getValueIndex(String sValue) {
        if (theMethods != null) {
            for (int i = 0; i < theMethods.length; i++) {
                if (theMethods[i].theMethod.getMethodName().equals(sValue) == true)
                    return i;
            }
        }
        return -1; // means nothing is found!
    }
}
