/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Aug 16, 2003
 * Time: 9:04:20 PM
 * To change this template use Options | File Templates.
 */
public class IDEMultiSelectSizeDialog extends JADialog {
    protected ButtonGroup grpWidth = new ButtonGroup();
    protected IDEMultiSelectDialogRadioButton btnWidthNoChange = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_HORZ_NO_CHANGE);
    protected IDEMultiSelectDialogRadioButton btnWidthShrinkToSmallest = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_HORZ_SHRINK);
    protected IDEMultiSelectDialogRadioButton btnWidthGrowToLargest = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_HORZ_GROW); //SWB: bugfix. this constant was SIZE_VERT_GROW, which was wrong
    protected IDEMultiSelectDialogRadioButton btnWidthSet = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_HORZ_SET);
    protected JATextField frmWidth = new JATextField();
    protected ButtonGroup grpHeight = new ButtonGroup();
    protected IDEMultiSelectDialogRadioButton btnHeightNoChange = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_VERT_NO_CHANGE);
    protected IDEMultiSelectDialogRadioButton btnHeightShrinkToSmallest = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_VERT_SHRINK);
    protected IDEMultiSelectDialogRadioButton btnHeightGrowToLargest = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_VERT_GROW);
    protected IDEMultiSelectDialogRadioButton btnHeightSet = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.SIZE_VERT_SET);
    protected JATextField frmHeight = new JATextField();
    protected JAButton btnOk = new JAButton("OK");
    protected JAButton btnCancel = new JAButton("Cancel");
    public SuperDesignCockpit theCockpit;
    protected JPanel pnlHeight = new JPanel();
    protected JPanel pnlWidth = new JPanel();

    public IDEMultiSelectSizeDialog (SuperDesignCockpit theCockpit) {
        super(theCockpit, "Multiselect Size", true, false);
        this.theCockpit = theCockpit;
        initializeInterface();
    }

    public void initializeInterface () {

        TitledBorder pnlWidthBorder;
        TitledBorder pnlHeightBorder;

        pnlWidthBorder = new TitledBorder("Width");
        pnlHeightBorder = new TitledBorder("Height");

        //  Get the content pane of the frame.
        Container container = getContentPane();
        // Set the layout.
        AnchoringLayoutManager layoutManager = new AnchoringLayoutManager();
        AnchoringLayoutManager layoutManagerX = new AnchoringLayoutManager();
        AnchoringLayoutManager layoutManagerY = new AnchoringLayoutManager();

        pnlWidth.setLocation(new java.awt.Point(8, 8));
        pnlWidth.setSize(new java.awt.Dimension(200, 128));
        pnlWidth.setBorder(pnlWidthBorder);
        pnlHeight.setLocation(new java.awt.Point(216, 8));
        pnlHeight.setSize(new java.awt.Dimension(200, 128));
        pnlHeight.setBorder(pnlHeightBorder);

        pnlWidth.setLayout(layoutManagerX);
        pnlHeight.setLayout(layoutManagerY);

        container.setLayout(layoutManager);
        setLocation(new java.awt.Point(48, 64));
        setSize(new java.awt.Dimension(428, 210));
        container.add(pnlWidth, "pnlWidth");
        container.add(pnlHeight, "pnlHeight");
        layoutManager.setAnchoring(pnlWidth, false, false, false, false);
        layoutManager.setAnchoring(pnlHeight, false, false, false, false);

        //  Add the control grpWidth to the content pane.
        btnWidthNoChange.setLocation(new java.awt.Point(8, 16));
        btnWidthNoChange.setSize(new java.awt.Dimension(88, 24));
        btnWidthNoChange.setText("No changes");
        //  Add the control btnWidthNoChange to the Group.
        grpWidth.add(btnWidthNoChange);
        //  Add the control btnWidthNoChange to the content pane.
        pnlWidth.add(btnWidthNoChange, "btnWidthNoChange");
        layoutManagerX.setAnchoring(btnWidthNoChange, false, false, false, false);
        btnWidthShrinkToSmallest.setLocation(new java.awt.Point(8, 40));
        btnWidthShrinkToSmallest.setSize(new java.awt.Dimension(112, 24));
        btnWidthShrinkToSmallest.setText("Shrink to smallest");
        //  Add the control btnWidthShrinkToSmallest to the Group.
        grpWidth.add(btnWidthShrinkToSmallest);
        //  Add the control btnWidthShrinkToSmallest to the content pane.
        pnlWidth.add(btnWidthShrinkToSmallest, "btnWidthShrinkToSmallest");
        layoutManagerX.setAnchoring(btnWidthShrinkToSmallest, false, false, false, false);
        btnWidthGrowToLargest.setLocation(new java.awt.Point(8, 64));
        btnWidthGrowToLargest.setSize(new java.awt.Dimension(112, 24));
        btnWidthGrowToLargest.setText("Grow to largest");
        //  Add the control btnWidthGrowToLargest to the Group.
        grpWidth.add(btnWidthGrowToLargest);
        //  Add the control btnWidthGrowToLargest to the content pane.
        pnlWidth.add(btnWidthGrowToLargest, "btnWidthGrowToLargest");
        layoutManagerX.setAnchoring(btnWidthGrowToLargest, false, false, false, false);
        btnWidthSet.setLocation(new java.awt.Point(8, 88));
        btnWidthSet.setSize(new java.awt.Dimension(80, 22));
        btnWidthSet.setText("Width");
        //  Add the control btnWidthSet to the Group.
        grpWidth.add(btnWidthSet);
        //  Add the control btnWidthSet to the content pane.
        pnlWidth.add(btnWidthSet, "btnWidthSet");
        layoutManagerX.setAnchoring(btnWidthSet, false, false, false, false);
        frmWidth.setLocation(new java.awt.Point(112, 88));
        frmWidth.setSize(new java.awt.Dimension(40, 18));
        frmWidth.setEnabled(false);
        //  Add the control frmWidth to the content pane.
        pnlWidth.add(frmWidth, "frmWidth");
        layoutManagerX.setAnchoring(frmWidth, false, false, false, false);
        //  Add the control grpHeight to the content pane.
        btnHeightNoChange.setLocation(new java.awt.Point(8, 16));
        btnHeightNoChange.setSize(new java.awt.Dimension(88, 24));
        btnHeightNoChange.setText("No changes");
        //  Add the control btnHeightNoChange to the Group.
        grpHeight.add(btnHeightNoChange);
        //  Add the control btnHeightNoChange to the content pane.
        pnlHeight.add(btnHeightNoChange, "btnHeightNoChange");
        layoutManagerY.setAnchoring(btnHeightNoChange, false, false, false, false);
        btnHeightShrinkToSmallest.setLocation(new java.awt.Point(8, 40));
        btnHeightShrinkToSmallest.setSize(new java.awt.Dimension(112, 24));
        btnHeightShrinkToSmallest.setText("Shrink to smallest");
        //  Add the control btnHeightShrinkToSmallest to the Group.
        grpHeight.add(btnHeightShrinkToSmallest);
        //  Add the control btnHeightShrinkToSmallest to the content pane.
        pnlHeight.add(btnHeightShrinkToSmallest, "btnHeightShrinkToSmallest");
        layoutManagerY.setAnchoring(btnHeightShrinkToSmallest, false, false, false, false);
        btnHeightGrowToLargest.setLocation(new java.awt.Point(8, 64));
        btnHeightGrowToLargest.setSize(new java.awt.Dimension(112, 24));
        btnHeightGrowToLargest.setText("Grow to largest");
        //  Add the control btnHeightGrowToLargest to the Group.
        grpHeight.add(btnHeightGrowToLargest);
        //  Add the control btnHeightGrowToLargest to the content pane.
        pnlHeight.add(btnHeightGrowToLargest, "btnHeightGrowToLargest");
        layoutManagerY.setAnchoring(btnHeightGrowToLargest, false, false, false, false);
        btnHeightSet.setLocation(new java.awt.Point(8, 88));
        btnHeightSet.setSize(new java.awt.Dimension(80, 22));
        btnHeightSet.setText("Height");
        frmHeight.setEnabled(false);
        //  Add the control btnHeightSet to the Group.
        grpHeight.add(btnHeightSet);
        //  Add the control btnHeightSet to the content pane.
        pnlHeight.add(btnHeightSet, "btnHeightSet");
        layoutManagerY.setAnchoring(btnHeightSet, false, false, false, false);
        frmHeight.setLocation(new java.awt.Point(112, 88));
        frmHeight.setSize(new java.awt.Dimension(40, 18));
        //  Add the control frmHeight to the content pane.
        pnlHeight.add(frmHeight, "frmHeight");
        layoutManagerY.setAnchoring(frmHeight, false, false, false, false);
        btnOk.setLocation(new java.awt.Point(70, 144));
        btnOk.setSize(new java.awt.Dimension(80, 22));
        btnOk.addActionListener(new OKButtonAction(this));
        //  Add the control btnOk to the content pane.
        container.add(btnOk, "btnOk");
        layoutManager.setAnchoring(btnOk, false, false, false, false);
        btnCancel.setLocation(new java.awt.Point(276, 144));
        btnCancel.setSize(new java.awt.Dimension(80, 22));
        btnCancel.addActionListener(new CancelButtonAction(this));
        //  Add the control btmCancel to the content pane.
        container.add(btnCancel, "btmCancel");
        layoutManager.setAnchoring(btnCancel, false, false, false, false);

        //add the listeners...
        frmHeight.addKeyListener(new AcceptOnlyIntegersKeyListener());
        frmWidth.addKeyListener(new AcceptOnlyIntegersKeyListener());

        // Show the main window
        btnWidthNoChange.setSelected(true);
        btnHeightNoChange.setSelected(true);
        setLocationRelativeTo(null);

        // add listeners...
        btnHeightSet.addChangeListener(new ChangeListener() {
            public void stateChanged (ChangeEvent e) {
                frmHeight.setEnabled(btnHeightSet.isSelected());
            }
        });

        btnWidthSet.addChangeListener(new ChangeListener() {
            public void stateChanged (ChangeEvent e) {
                frmWidth.setEnabled(btnWidthSet.isSelected());
            }
        });

        show(null);
    }  // End of the initializeInterface method.

    class OKButtonAction extends AbstractAction {
        IDEMultiSelectSizeDialog theEditor = null;

        public OKButtonAction (IDEMultiSelectSizeDialog theEditor) {
            super("OK");
            this.theEditor = theEditor;
        }

        public void actionPerformed (ActionEvent evt) {
            int iWidth = 0, iHeight = 0;
            if (btnWidthSet.isSelected()) {
                String sWidth = frmWidth.getText();
                try {
                    iWidth = new Integer(sWidth.trim()).intValue();
                } catch (NumberFormatException e1) {
                }
                if (iWidth == 0) {
                    JOptionPane.showMessageDialog(theEditor, "Please enter a numeric width", "Invalid Entry", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            if (btnHeightSet.isSelected()) {
                String sHeight = frmHeight.getText();
                try {
                    iHeight = new Integer(sHeight.trim()).intValue();
                } catch (NumberFormatException e1) {
                }
                if (iHeight == 0) {
                    JOptionPane.showMessageDialog(theEditor, "Please enter a numeric height", "Invalid Entry", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
            int Command = IDEMultiSelectCommandProcessor.NOP;
            Command += btnWidthNoChange.getCommand();
            Command += btnWidthShrinkToSmallest.getCommand();
            Command += btnWidthGrowToLargest.getCommand();
            Command += btnWidthSet.getCommand();
            Command += btnHeightNoChange.getCommand();
            Command += btnHeightShrinkToSmallest.getCommand();
            Command += btnHeightGrowToLargest.getCommand();
            Command += btnHeightSet.getCommand();
            IDEMultiSelectCommandProcessor theProcessor = new IDEMultiSelectCommandProcessor(theCockpit, Command);
            theProcessor.horzSet = iWidth;
            theProcessor.vertSet = iHeight;
            theProcessor.doCommand();
        }
    }

    class CancelButtonAction extends AbstractAction {
        IDEMultiSelectSizeDialog theEditor = null;

        public CancelButtonAction (IDEMultiSelectSizeDialog theEditor) {
            super("Cancel");
            this.theEditor = theEditor;
        }

        public void actionPerformed (ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }

    public class AcceptOnlyIntegersKeyListener extends KeyAdapter {
        public void keyTyped (KeyEvent e) {
            if (e.getKeyChar() == KeyEvent.VK_ENTER) return;
            if (e.getKeyChar() == KeyEvent.VK_BACK_SPACE) return;
            if (e.getKeyChar() == KeyEvent.VK_DELETE) return;
            if (e.getKeyChar() == KeyEvent.VK_CANCEL) return;
            if (e.getKeyChar() == KeyEvent.VK_ESCAPE) return;
            if (e.getKeyChar() == KeyEvent.VK_LEFT) return;
            if (e.getKeyChar() == KeyEvent.VK_RIGHT) return;
            if ("1234567890".indexOf(e.getKeyChar()) < 0)
                e.consume();
        }
    }
}
