/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import org.comedia.text.CJavaHighlighter;

import javax.swing.*;
import javax.swing.text.Keymap;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import java.awt.*;
import java.awt.event.*;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Reader;
import java.io.IOException;
import java.util.Hashtable;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaClass;

/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: March 29, 2005
 * Time: 9:35:12 PM
 * To change this template use Options | File Templates.
 */

public class IDEObjectSourceEditor extends IIDESourceEditor {
    SuperDesignCockpit theCockpit;
    String objectSource;
    String sOldCode     = null;
    MetaObject theLastObjectLoaded =  null;

    public static final int UNDO_LIMIT = 1500;
    public void setCode(String sCode){}
    public String getCode(){return null;}
    public void setText(String sCode){};
    public String getText(){return null;};

    public void setDesignCockpit(SuperDesignCockpit objCockPit){}
    public void read(Reader reader, Object o) throws IOException{}
    public void addCaretListener(CaretListener caretListener){}
    public Container getContainer()
    {
        return null;
    }
    public JComponent getTextEdit()
    {
        return this;
    }

    public boolean hasContainer()
    {
        return false;
    }
    public IDEObjectSourceEditor(SuperDesignCockpit objCockpit) {
        theCockpit = objCockpit;
    }

    // Move the contents from the object data to the Display on the editor.
    public void Load() {
        MetaObject theSelectedObject = theCockpit.getDesignProject().getSelectedObject();
        String objCode = theSelectedObject.getObjectCode();
        if(objCode!=null)
            setCode(objCode);
        else
            setCode("");

        theLastObjectLoaded = theSelectedObject;
    }

    public void changedUpdate(DocumentEvent e)
    {
    }
}
