/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEUndoRedoController {
    IDEUndoRedoStack theUndoRedoStack = new IDEUndoRedoStack(this);
    SuperDesignCockpit theDesignCockpit;

    public IDEUndoRedoController(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void createClearEvent() {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createClearEvent();
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createImportObjectEvent(MetaObject theMetaObject, MetaObject theParentObject) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createImportObjectEvent(theMetaObject, theParentObject);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createDeleteObjectsEvent(ArrayList theParentObjects, ArrayList theMetaObjects) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createDeleteObjectsEvent(theParentObjects, theMetaObjects);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createCutEvent(ArrayList theParentObjects, ArrayList theMetaObjects) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createCutEvent(theParentObjects, theMetaObjects);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createPasteEvent(MetaObject theTarget, ArrayList theMetaObjects) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createPasteEvent(theTarget, theMetaObjects);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createChangeLocationEvent(ArrayList theMetaObjects) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createChangeLocationEvent(theMetaObjects);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createChangeSizeEvent(MetaObject theMetaObject) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createChangeSizeEvent(theMetaObject);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createChangePropertyEvent(MetaObject theMetaObject, String sPropertyName,
                                          int iItemIndex, int iOrderIndex) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createChangePropertyEvent(theMetaObject, sPropertyName,
                iItemIndex, iOrderIndex);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void createChangePropertyEvent(MetaObject theMetaObject, String sPropertyName) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createChangeAllPropertyEvent(theMetaObject, sPropertyName);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void undo() {
        IDEUndoRedoStackElement element = theUndoRedoStack.popUndo();
        element.event.undo();
        theUndoRedoStack.pushRedo(element);
    }

    public void redo() {
        IDEUndoRedoStackElement element = theUndoRedoStack.popRedo();
        element.event.redo();
        theUndoRedoStack.pushUndo(element);
    }

    public void createChangeDataLinkageEvent(MetaObject theMetaObject) {
        IDEUndoRedoEvent event = IDEUndoRedoEvent.createDataLinkageEvent(theMetaObject);
        IDEUndoRedoStackElement element = new IDEUndoRedoStackElement(event);
        theUndoRedoStack.pushUndo(element);
    }

    public void updateHint() {
        if (theUndoRedoStack.sUndoHint == null) {
            theDesignCockpit.theActionManager.updateUndoStatus("Undo", false);
        } else {
            theDesignCockpit.theActionManager.updateUndoStatus("Undo " + theUndoRedoStack.sUndoHint, true);
        }
        if (theUndoRedoStack.sRedoHint == null) {
            theDesignCockpit.theActionManager.updateRedoStatus("Redo", false);
        } else {
            theDesignCockpit.theActionManager.updateRedoStatus("Redo " + theUndoRedoStack.sRedoHint, true);
        }
    }
}
