/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: May 26, 2004
 * Time: 2:17:54 AM
 */
package ch.abacus.designcockpit.ide;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.*;

public class IDEViewDisplayerMouseListener implements MouseListener {
    IDEViewDisplayer theViewDisplayer;

    public IDEViewDisplayerMouseListener (IDEViewDisplayer objViewDisplayer) {
        theViewDisplayer = objViewDisplayer;
    }

    public void mouseClicked (MouseEvent evt) {
    }

    public void mouseEntered (MouseEvent evt) {
    }

    public void mouseExited (MouseEvent evt) {
    }

    public void mousePressed (MouseEvent evt) {
        if ((theViewDisplayer.theDesignCockpit.getMouseSelectState()) && (!evt.isShiftDown()))
            showPopup(evt);
        else {
            boolean bShiftDown = evt.isShiftDown();
            theViewDisplayer.importObject(null, evt.getPoint(), bShiftDown, null);
            theViewDisplayer.theDesignCockpit.setMouseSelectState(true);
            evt.consume();
        }
    }

    public void mouseReleased (MouseEvent evt) {
        if (theViewDisplayer.theDesignCockpit.getMouseSelectState())
            showPopup(evt);
        theViewDisplayer.setMouseCoordinates(evt.getX(), evt.getY());
        theViewDisplayer.theDesignCockpit.allowDragging(true);
    }

    private void showPopup (MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            theViewDisplayer.theDesignCockpit.theLastPopupMenu = theViewDisplayer.thePopupMenu;
            theViewDisplayer.thePopupMenu.ptLastPopupLocation = new Point(evt.getX(), evt.getY());
            theViewDisplayer.thePopupMenu.ptActualStrikePoint = new Point(evt.getX(), evt.getY());
            theViewDisplayer.thePopupMenu.show(theViewDisplayer,
                    evt.getX(), evt.getY());
        }
    }

}