/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import javax.swing.event.CaretListener;
import javax.swing.*;
import java.io.Reader;
import java.io.IOException;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: mario
 * Date: Apr 21, 2005
 * Time: 3:51:11 PM
 */
public abstract class  IIDESourceEditor extends JComponent {
    public IDEEditorPopupMenu thePopupMenu = null;

    public abstract void setCode(String sCode);
    public abstract String getCode();
    public abstract void setDesignCockpit(SuperDesignCockpit objCockPit);
    public abstract void read(Reader reader, Object o) throws IOException;
    public abstract void addCaretListener(CaretListener caretListener);

    // return false if object is not within container.
    public abstract boolean hasContainer();
    // Return null if object does not have a Container else return container
    public abstract Container getContainer();
    // Return null if object has Container else return the Object
    public abstract JComponent getTextEdit();

    public String getText(){return getCode();}
    public void setText(String sc){setCode(sc);}

    public void setPopupMenu(IDEEditorPopupMenu pm)
    {
        thePopupMenu = pm;
    }

    public IDEEditorPopupMenu getPopupMenu()
    {
        return thePopupMenu;
    }

}
