/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import javax.swing.*;
import java.io.File;

/**
 * User: Stuart Booth
 * Date: Jul 27, 2004
 * Time: 11:02:28 AM
 */
class ProjFileView extends javax.swing.filechooser.FileView {
    // Define the required icon objects.
    ImageIcon projIcon = new ImageIcon("glp_design.png");
    private SuperDesignCockpit theCockpit;

    public ProjFileView (SuperDesignCockpit cockpit) {
        this.theCockpit = cockpit;
    }

    public String getName (File f) {
        return null;
    }

    public String getDescription (File f) {
        return null;
    }

    public String getTypeDescription (File f) {
        String sExtension = getExtension(f).toLowerCase();
        String sType = null;
        if (sExtension != null) {
            if (sExtension.equals("proj"))
                sType = "Abacus Project File";
        }
        return sType;
    }

    public Icon getIcon (File f) {
        String sExtension = getExtension(f);
        Icon theIcon = null;
        if (sExtension != null) {
            if (sExtension.equals("proj"))
                theIcon = projIcon;
        }
        return theIcon;
    }

    public Boolean isTraversable (File f) {
        return null;
    }

    private String getExtension (File f) {
        String sFileName = f.getName();
        int iDotIndex = sFileName.lastIndexOf('.');
        String sExtension = null;
        if ((iDotIndex > 0) && (iDotIndex < sFileName.length() - 1))
            sExtension = sFileName.substring(iDotIndex + 1).toLowerCase();
        return sExtension;
    }
}
