/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Jul 22, 2004
 * Time: 4:15:14 PM
 * To change this template use Options | File Templates.
 */
public class SelectProjectAction extends AbstractAction {
    SuperDesignCockpit theCockpit = null;
    DesignProject theDesignProject = null;

    public SelectProjectAction (DesignProject objDesignProject, SuperDesignCockpit objDesignCockpit) {
        super(objDesignProject.theMetaProject.sName, null);
        theCockpit = objDesignCockpit;
        theDesignProject = objDesignProject;
        theDesignProject.theAssociatedAction = this;
    }

    public void actionPerformed (ActionEvent evt) {
        boolean bSaveState = theDesignProject.theMetaProject.getProjectChangedState();
        theCockpit.theProjectName = theDesignProject.theMetaProject.sName;
        theCockpit.ResetDisplay();
        theCockpit.SetDesignProject(theDesignProject);
        MetaObject theSelectedFrame = theCockpit.getDesignProject().getSelectedFrame();
        MetaObject theSelectedObject = theCockpit.getDesignProject().getSelectedObject();
        if (theSelectedFrame == null)
            theSelectedFrame = theCockpit.getDesignProject().getFirstObject();
        if (theSelectedObject == null)
            theSelectedObject = theCockpit.getDesignProject().getFirstObject();
        if (theSelectedFrame != null) {
            theCockpit.SelectObject(theCockpit.getDesignProject().getFirstObject(), true);
            theCockpit.SelectObject(theSelectedFrame, true);
        }
        theCockpit.SelectObject(theSelectedObject, true);
        // Make sure all the tab pages are right.
        MetaObject theSelectedContainer = null;
        if (theSelectedObject != null) {
            theSelectedContainer = theSelectedObject.getVisualContainerObject(false);
            theCockpit.SelectContainer(null);
            theCockpit.SelectContainer(theSelectedContainer);
        }
        boolean bOpenSrcFlag = theCockpit.getOpenSourceState();

        String sProjectDisplayName = theDesignProject.theMetaProject.getProjectDirectory() + theDesignProject.theMetaProject.sName;
        if(bOpenSrcFlag==true)
            theCockpit.setTitle("Abacus GUI Builder - " + sProjectDisplayName);
        else
            theCockpit.setTitle("Abacus Design Cockpit - " + sProjectDisplayName);
        theSelectedFrame = theCockpit.getDesignProject().getSelectedFrame();
        theCockpit.FrameSelection(theSelectedFrame, true);
        /*
        if (theCockpit.saveButton != null)
            theCockpit.saveButton.setEnabled(bSaveState);
        if (theCockpit.jmitemSave != null)
            theCockpit.jmitemSave.setEnabled(bSaveState);

        if (theCockpit.saveWithCompileButton != null)
            theCockpit.saveWithCompileButton.setEnabled(bSaveState);
        if (theCockpit.jmItemSaveWithCompile != null)
            theCockpit.jmItemSaveWithCompile.setEnabled(bSaveState);


        if (bSaveState == true) {
            if (theCockpit.saveAllButton != null)
                theCockpit.saveAllButton.setEnabled(true);
            if (theCockpit.jmItemSaveAll != null)
                theCockpit.jmItemSaveAll.setEnabled(true);
        } */
    }
}
