/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class SizeboxSet {
    ArrayList theSizeboxSet = new ArrayList(1);

    public SizeboxSet () {
    }

    public void add (MetaObject objMetaObject, int width, int height, SuperDesignCockpit theDesignCockpit) {
        Sizeboxes theSizebox = new Sizeboxes(objMetaObject, width, height, theDesignCockpit);
        theSizeboxSet.add(theSizebox);
    }

    public void kill (MetaObject objMetaObject) {
        for (int i = 0; i < theSizeboxSet.size(); i++) {
            Sizeboxes theSizeboxes = (Sizeboxes) theSizeboxSet.get(i);
            if ((theSizeboxes != null) && (objMetaObject.equals(theSizeboxes.theMetaObject))) {
                theSizeboxes.kill();
                theSizeboxSet.remove(i);
            }
        }
    }

    public void kill () {
        for (int i = 0; i < theSizeboxSet.size(); i++) {
            Sizeboxes theSizeboxes = (Sizeboxes) theSizeboxSet.get(i);
            theSizeboxes.kill();
        }
    }

    public void relocate (MetaObject objMetaObject, int x, int y, int cx, int cy, boolean bStillDragging) {
        for (int i = 0; i < theSizeboxSet.size(); i++) {
            Sizeboxes theSizeboxes = (Sizeboxes) theSizeboxSet.get(i);
            if (objMetaObject.equals(theSizeboxes.theMetaObject)) {
                theSizeboxes.relocate(x, y, cx, cy, bStillDragging, true, true);
            }
        }
    }

    public void update (MetaObject objMetaObject, int x, int y, int cx, int cy) {
        for (int i = 0; i < theSizeboxSet.size(); i++) {
            Sizeboxes theSizeboxes = (Sizeboxes) theSizeboxSet.get(i);
            if (objMetaObject.equals(theSizeboxes.theMetaObject)) {
                theSizeboxes.update(x, y, cx, cy);
            }
        }
    }

    public void resizeAllSizeBoxes () {
        for (int i = 0; i < theSizeboxSet.size(); i++) {
            Sizeboxes theSizeBoxes = (Sizeboxes) theSizeboxSet.get(i);
            theSizeBoxes.resizeSizeBoxes();
        }
    }
}
