/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide.propertyinspector;


import ch.abacus.lib.ui.propertyinspector.display.editor.EditableStringListEditor;
import ch.abacus.lib.ui.propertyinspector.core.StringEntry;
import java.util.List;

import javax.swing.*;
import java.util.ArrayList;
import java.awt.*;


/**
 * User: Mario Castillo , Castellum Technologies
 * Date: Oct 3, 2005
 * Time: 1:44:34 AM
 */

class DynamicCellRenderer extends JLabel implements ListCellRenderer
{
    List<Icon> icons = null;

     public DynamicCellRenderer()
     {
        super();
        setOpaque(true);
     }

    public DynamicCellRenderer(List<Icon> iconlist)
    {
       super();
       setOpaque(true);
       icons = iconlist;
    }

     public Component getListCellRendererComponent( JList list, Object value,
         int index,  boolean isSelected, boolean cellHasFocus)
     {
        // All icons always match the order they were read. In fact they should, since
        // the code assures but it is important to note in case this changes.

         if(icons!=null)
         {
             if(index < icons.size())
                    this.setIcon(icons.get(index));
         }

         if(value!=null)
         {
             String sName = value.toString();
             setText(sName);
             setBackground(isSelected ? Color.blue : Color.white);
             setForeground(isSelected ? Color.white : Color.black);
         }
         else // Blank out the selection in case Rog's components can't find the item set it to blank
         {
            setText("");
         }

         return this;
     }
}

public class DynamicListEditor extends EditableStringListEditor
{

    private  ArrayList RefList= new ArrayList();

    public DynamicListEditor(List<StringEntry> list) {
      super(list);
      copyListToRefList(list);
    }

    public DynamicListEditor(boolean lazyInitialization, List<StringEntry> list) {
      super(lazyInitialization, list, null);
       copyListToRefList(list);
    }

    public DynamicListEditor(boolean lazyInitialization, List<StringEntry> list, List<Icon> icons) {
      super(lazyInitialization, list, icons);
       copyListToRefList(list);
    }


    public List<StringEntry> getItemList()
    {
        return RefList;
    }

    public int indexOf(Object value)
    {
        return RefList.indexOf(value);
    }

    public ListCellRenderer getListCellRenderer()
    {
        return new DynamicCellRenderer(icons);
    }

    public void refreshList(ArrayList value)
    {
        RefList = value;
    }

    public void setValue(Object value)
    {

        if(!RefList.contains(value))
            RefList.add(value);
        comboBox.setModel(new DefaultComboBoxModel(getItemList().toArray()));
        super.setValue(value);
    }

    protected void copyListToRefList(List<StringEntry> listItems)
    {

        for(int i=0;i < listItems.size();i++)
        {
            StringEntry seTmp = listItems.get(i);
            RefList.add(seTmp.getTranslatedName());
        }

    }

}
