/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Jul 8, 2004
 * Time: 3:37:43 PM
 * A BufferedAction buffers an action that needs to accur later. For example, during a dialog that allows items to be renamed
 * or deleted, etc. It is only when the dialog's OK button is pressed that the action must be committed. At that time, the BufferedAction objects can be queried to see what needds to be committed.
 */
public class BufferedAction {
    public static final int ACTION_NONE = 0;
    public static final int ACTION_RENAME = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_ADD = 3;

    private int actionType = ACTION_NONE;
    private String oldName = null;
    private String newName = null;

    void setActionRename (String sOldName, String sNewName) {
        oldName = sOldName;
        newName = sNewName;
        actionType = ACTION_RENAME;
    }

    void setActionDelete (String sName) {
        oldName = sName;
        actionType = ACTION_DELETE;
    }

    void setActionAdd (String sName) {
        newName = sName;
        actionType = ACTION_ADD;
    }

    void setActionAdd (String sOldName, String sNewName) {
        oldName = sOldName;
        newName = sNewName;
        actionType = ACTION_ADD;
    }

    int getActionType () {
        return actionType;
    }

    String getOldName () {
        return oldName;
    }

    String getNewName () {
        return newName;
    }
}
