/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.ide.DesignCockpitPreferences;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.validation.ValidationStaticMethods;
import ch.abacus.lib.util.GlobalInterface;
import electric.xml.Document;
import electric.xml.ParseException;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.*;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Mar 25, 2004
 * Time: 11:16:25 AM
 */
public class MetadataEditor extends JAFrame {
    MetadataEditor editor = null;
    electric.xml.Document document = null;
    electric.xml.Element xmlSystemRoot = null;
    String DesignBorderDefinition = null;
    ActionManager theActionManager = new ActionManager(this);
    MenuBar mainMenu = new MenuBar(theActionManager);

    MetadataEditorUser theMetadataEditorUser = new MetadataEditorUser();

    MetadataEditorPageGeneral pageGeneral = null;
    MetadataEditorPageConstants pageConstants = null;
    MetadataEditorPageConstantCollections pageCollections = null;
    private MetadataEditorPageClasses pageClasses = null;

    public MetadataDispenser theMetadataDispenser;
    public GlobalInterface theGlobalInterface = null;

    private final int iVersionNumber = 1;
    private final int iRevisionNumber = 0;
    private final int iSubRevisionNumber = 4;
    private final int iBuildNumber = 3;


    String sImageDirectory = "";

    File metaDataFile = null;

    public DesignCockpitPreferences thePreferences = null;
    private boolean metadataModified;


    public MetadataEditor(String sConfigurationPath, String sConfigurationDoc, String sMetadataDocument) {
        super(false);
        ValidationStaticMethods.setValidationEnabled(false);
        editor = this;
        setMinimumFrameSize(JAFrame.FRAME_MINIMUM_SIZE_MEDIUM);
        setSize(900, 700);
        setTitle("Maintain Metadata");
        setLocationRelativeTo(null);
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                exitApplication();
            }
        });

        loadMetadata(sConfigurationPath, sConfigurationDoc, sMetadataDocument);

        // Add menu...
        setJMenuBar(mainMenu);

//        loadItem.addActionListener(new ActionListener() {
//            public void actionPerformed(ActionEvent ae) {
//                try {
//
//                    JFileChooser fileChooser = new JFileChooser("c:\\");
//                    int selected = fileChooser.showOpenDialog(editor);
//                    if (selected == JFileChooser.APPROVE_OPTION) {
//
//                        metaDataFile = fileChooser.getSelectedFile();
//
//                        //theMetadataDispenser = new MetadataDispenser(this, null, MetaObject.DESIGN_MODE);
//                        //theMetadataDispenser.theMetadataDocument.resetAlreadyLoadedFlag();
//                        theMetadataDispenser.theMetadataDocument.loadMeta(metaDataFile.getCanonicalPath());
//                        pageGeneral.populateInterface();
//                    }
//
//                } catch (Exception e) {
//                    e.printStackTrace();  //To change body of catch statement use Options | File Templates.
//                }
//            }
//        });



        JATabbedPane workarea = new JATabbedPane();
        workarea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        pageGeneral = new MetadataEditorPageGeneral(this);
        pageConstants = new MetadataEditorPageConstants(this);
        pageCollections = new MetadataEditorPageConstantCollections(this);
        pageClasses = new MetadataEditorPageClasses(this);

        workarea.addTab("General", pageGeneral);
        workarea.addTab("Constants", pageConstants);
        workarea.addTab("Constant Collections", pageCollections);
        workarea.addTab("Classes", pageClasses);

        pane.add(workarea, BorderLayout.CENTER);
        setContentPane(pane);
        //setVisible(true);
    }

    private void openFile(String sFile) {
        System.out.println("file=" + sFile);
        File file = new File(sFile);
        //System.out.println("Found=" + file.exists());

        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStream theMetadataStream = new BufferedInputStream(in);

        try {
            document = new Document(theMetadataStream);
            xmlSystemRoot = document.getRoot();
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }


    void saveMetadata() {
        // Save back to a file, if loaded from file; or if loaded from a JAR, then save temp file and rewrite JAR
        pageGeneral.save();

        String sMetadataFile = null;
        String sMetadataEntryName = null;
        String sMetadataJarName = null;

        boolean bMetaInJar = (theMetadataDispenser.theMetadataDocument.mode == HammerInputStream.FROM_RESOURCE);
        if (bMetaInJar) {
            sMetadataEntryName = theMetadataDispenser.theMetadataDocument.sJarEntryName;
            sMetadataJarName = theMetadataDispenser.theMetadataDocument.sJarName;
            try {
                File jarDirectory = (new File(sMetadataJarName)).getParentFile();
                sMetadataFile = File.createTempFile("metadata_", ".meta", jarDirectory).getPath();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else { // from file
            sMetadataFile = theMetadataDispenser.theMetadataDocument.sFullPathName;
        }

        MetadataDocumentGenerator theGenerator = null;
        try {
            theGenerator = new MetadataDocumentGenerator(sMetadataFile, theMetadataDispenser.getFirstClass(), theMetadataDispenser.getLastClass());
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            if (bMetaInJar) {
                File metadataFile = new File(sMetadataFile);
                File inUseFile = new File(sMetadataJarName + "_temp"); // this is where the jar file will be written if the original cannot be written to
                JarModifier jarModifier = new JarModifier(new File(sMetadataJarName), inUseFile);
                File backupFile = new File(sMetadataJarName + "_orig");
                makeFileBackup(sMetadataJarName, backupFile.getPath());
                theGenerator.GenerateFromMetadata(theMetadataDispenser); // save the metadata
                jarModifier.replaceFile(new File(sMetadataEntryName), metadataFile);
                metadataFile.delete(); // remove the temp metadata file
                JOptionPane.showConfirmDialog(this, "The metadata file has been saved in the JAR.\n\n(The original file has been renamed as \"" + backupFile.getName() + "\")", "Metadata Saved", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE);
            } else {
                //makeFileBackup(sMetadataFile, sMetadataFile +"_orig");
                File metaFile = new File(sMetadataFile);
                File backupFile = new File(sMetadataFile + "_orig");
                if (backupFile.exists())
                    backupFile.delete();
                metaFile.renameTo(new File(sMetadataFile + "_orig"));
                theGenerator.GenerateFromMetadata(theMetadataDispenser); // save the metadata
                JOptionPane.showConfirmDialog(this, "The metadata file has been saved.\n\n(The original file has been renamed as \"" + backupFile.getName() + "\")", "Metadata Saved", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        metadataModified = false;

    }

    private void makeFileBackup(String sMetadataFile, String sNewName) throws IOException {
        InputStream in = new FileInputStream(sMetadataFile);
        OutputStream out = new FileOutputStream(sNewName);

        File newFile = new File(sNewName);
        newFile.delete(); // delete the backup file, if it exists

        // Transfer bytes from in to out
        byte[] buf = new byte[1024];
        int len;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }


    public void setMetadataModified(boolean bModified) {
        this.metadataModified = bModified;
    }

    public boolean isMetadataModified() {
        return metadataModified;
    }

    public int getVersionNumber() {
        return iVersionNumber;
    }

    public int getRevisionNumber() {
        return iRevisionNumber;
    }

    public int getSubRevisionNumber() {
        return iSubRevisionNumber;
    }

    public int getBuildNumber() {
        return iBuildNumber;
    }

    private void loadMetadata(String sConfigurationPath, String sConfigurationDocument, String sMetadataDocument) {

        if (sConfigurationPath == null)
            sConfigurationPath = "ch.abacus.lib.ui.renderer.deploy.";
        if (sConfigurationDocument == null)
            sConfigurationDocument = "hammer-configuration.xml";
        if (sMetadataDocument == null)
            sMetadataDocument = "metadata.meta";

        theMetadataEditorUser.setSystemConfigurationPathName(sConfigurationPath);
        theMetadataEditorUser.setSystemConfigurationDocumentName(sConfigurationDocument);
        theMetadataEditorUser.setSystemMetadataDocumentName(sMetadataDocument);

        try {
            String systemDocumentPath = sConfigurationPath + sMetadataDocument;

            theMetadataDispenser = new MetadataDispenser(theMetadataEditorUser, null, MetaObject.DESIGN_MODE);
            theMetadataDispenser.theMetadataDocument.loadMeta(systemDocumentPath);

        } catch (HammerException e) {
            e.printStackTrace();
        }
//                    try {
//                        theMetadataDispenser = new MetadataDispenser(theMetadataEditorUser, null, MetaObject.DESIGN_MODE);
//                        String sMetaFile = args[0];
//                        FileInputStream in = null;
//                        try {
//                            in = new FileInputStream(sMetaFile);
//                        } catch (FileNotFoundException e) {
//                            e.printStackTrace();
//                        }
//                        HammerInputStream hisMetadataStream = new HammerInputStream("", sMetaFile, in);
//                        theMetadataDispenser.theMetadataDocument.loadMeta(hisMetadataStream);
//                    } catch (HammerException e) {
//                        e.printStackTrace();
//                    }

    }


    void exitApplication() {
        if (isMetadataModified() == true) {
            Object sConfirmationText = "All changes will be lost. Are you sure you want to exit the application ?";
            String sConfirmationTitle = "Unsaved Changes";
            int optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            int iChoice = JOptionPane.showConfirmDialog(this, sConfirmationText, sConfirmationTitle, optionType, messageType);
            if (iChoice == JOptionPane.YES_OPTION) {
                dispose();
            }
        } else
            dispose();
    }

    public static void main(String[] args) {

        try {
            UIManager.setLookAndFeel ( UIManager.getSystemLookAndFeelClassName () );
        } catch ( Exception e ) {
            //ignore L&F exceptions
        }


        String sMeta = null;
        if ( args.length > 0 ) sMeta = args[0];
        MetadataEditor editor = new MetadataEditor(null, null, sMeta);
        editor.show();
    }

}

