/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class MetadataEditorPageConstants extends JAPanel {
    final MetadataEditor editor;
    JAList lstGroups = new JAList();
    JATable lstConstants = new JATable();
    ListSelectionListener selectionListener = new SelectionListener();
    public TableModel tableModel = null;
    ArrayList groups = new ArrayList();
    JAButton btnModifyGroups = new JAButton("Modify Groups");


    public MetadataEditorPageConstants (MetadataEditor editor) {
        super();
        this.editor = editor;
        initInterface();
        populateDisplay();
    }

    private void populateDisplay () {
        MetaConstantGroup group;
        groups.clear();

        group = editor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            groups.add(group.sClassName);
            group = group.theNextSibling;
        }
        lstGroups.setListData(groups.toArray());

        if (groups.size() != 0)
            lstGroups.setSelectedIndex(0);
    }

    void initInterface () {
        setLayout(new BorderLayout());

        JASplitPane splitPane;
        JAPanel pnlGroups = new JAPanel(new BorderLayout());
        JAPanel pnlConstants = new JAPanel(new BorderLayout());
        pnlGroups.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlConstants.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));

        splitPane = new JASplitPane(JSplitPane.HORIZONTAL_SPLIT, pnlGroups, pnlConstants);
        splitPane.setDividerLocation(200);

        Dimension minimumSize = new Dimension(100, 50);
        pnlGroups.setMinimumSize(minimumSize);
        pnlConstants.setMinimumSize(minimumSize);


        JALabel lblGroups = new JALabel("Groups");
        pnlGroups.add(lblGroups, BorderLayout.NORTH);
        pnlGroups.add(new JScrollPane(lstGroups), BorderLayout.CENTER);
        JAPanel pnlModifyGroups = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        pnlModifyGroups.add(btnModifyGroups);
        pnlGroups.add(pnlModifyGroups, BorderLayout.SOUTH);

        JALabel lblConstants = new JALabel("Constants in Group");
        pnlConstants.add(lblConstants, BorderLayout.NORTH);
        pnlConstants.add(new JAScrollPane(lstConstants), BorderLayout.CENTER);
        JAButton btnModifyConstants = new JAButton("Modify Constants");
        JAPanel pnlModifyConstants = new JAPanel(new FlowLayout(FlowLayout.LEFT, 0, 5));
        pnlModifyConstants.add(btnModifyConstants);
        pnlConstants.add(pnlModifyConstants, BorderLayout.SOUTH);


        this.add(splitPane);

        lstConstants.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        // assign listeners...
        lstGroups.addListSelectionListener(selectionListener);
        btnModifyConstants.addActionListener(new ModifyConstantsAction(editor));
        btnModifyGroups.addActionListener(new ModifyGroupsAction(this));

    }

    void showConstantsOfTheGroup (String sGroup) {
        //System.out.println(sGroup);
        // find the real group...
        MetaConstantGroup group = this.editor.theMetadataDispenser.findConstantGroup(sGroup);
        tableModel = new TableModel(group);
        lstConstants.setModel(tableModel);

    }

    class SelectionListener implements ListSelectionListener {
        /**
         * Called whenever the value of the selection changes.
         * @param e the event that characterizes the change.
         */
        public void valueChanged (ListSelectionEvent e) {
            if (!e.getValueIsAdjusting())
                showConstantsOfTheGroup((String) lstGroups.getSelectedValue());
        }

    }

    class TableModel extends AbstractTableModel {
        private MetaConstantGroup group;
        private int rowCount;

        public TableModel (MetaConstantGroup group) {
            this.group = group;
            if (group == null) {
                rowCount = 0;
            } else {
                ArrayList constants = group.getConstantList();
                rowCount = constants.size();
            }
        }

        public String getColumnName (int column) {
            if (column == 0)
                return "Name";
            else
                return "Value";
        }


        /**
         * Returns the number of rows in the model. A
         * <code>JTable</code> uses this method to determine how many rows it
         * should display.  This method should be quick, as it
         * is called frequently during rendering.
         *
         * @return the number of rows in the model
         * @see #getColumnCount
         */
        public int getRowCount () {
            return rowCount;
        }

        /**
         * Returns the number of columns in the model. A
         * <code>JTable</code> uses this method to determine how many columns it
         * should create and display by default.
         *
         * @return the number of columns in the model
         * @see #getRowCount
         */
        public int getColumnCount () {
            return 2;
        }

        /**
         * Returns the value for the cell at <code>columnIndex</code> and
         * <code>rowIndex</code>.
         *
         * @param	rowIndex	the row whose value is to be queried
         * @param	columnIndex 	the column whose value is to be queried
         * @return	the value Object at the specified cell
         */
        public Object getValueAt (int rowIndex, int columnIndex) {
            String sConstantName = (String) group.getConstantList().get(rowIndex);
            String sConstantValue = group.get(sConstantName);
            if (columnIndex == 0)
                return sConstantName;
            else
                return sConstantValue;
        }

    }

    class ModifyConstantsAction implements ActionListener {
        private final MetadataEditor editor;

        public ModifyConstantsAction (MetadataEditor editor) {
            this.editor = editor;
        }

        public void actionPerformed (ActionEvent e) {
            MetaConstantGroup group = this.editor.theMetadataDispenser.findConstantGroup((String) lstGroups.getSelectedValue());

            ManageGroupConstantsDialog dialog = new ManageGroupConstantsDialog(editor, group);
            dialog.show();
            populateDisplay();
        }

    }

    class ModifyGroupsAction implements ActionListener {
        private final MetadataEditorPageConstants pageConstants;

        public ModifyGroupsAction (MetadataEditorPageConstants pageConstants) {
            this.pageConstants = pageConstants;
        }

        public void actionPerformed (ActionEvent e) {
            ManageConstantGroupsDialog dialog = new ManageConstantGroupsDialog(pageConstants, "Manage Constant Groups", "Groups");
            dialog.show();
            populateDisplay();
            pageConstants.editor.pageCollections.populateDisplay();
        }

    }

}
