/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.renderer.common.*;

import java.util.Properties;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 15, 2004
 * Time: 4:13:39 PM
 * To change this template use File | Settings | File Templates.
 */
public class MetadataEditorUser implements AbaMetaDataUser {
    public HammerClassLoader theClassLoader = null;
    HammerFileManager theFileManager = new HammerFileManager(this);
    public String sBaseDir = "";
    public String sUserHome = "";
    String theSeparator = "";
    public String SystemConfigurationPathName;
    public String SystemConfigurationDocumentName;
    public String SystemMetadataDocumentName;

    HammerLogFileAccess theLogFile = null;

    public Properties props = System.getProperties();

    public MetadataEditorUser() {
        theSeparator = props.getProperty("path.separator");

        setupClassLoader();

        theLogFile = new HammerLogFileAccess(this);
        theLogFile.bExtendedLogging = true;
        theLogFile.bConsoleLogging = true;

    }

    public int getMode() {
        return AbaMetaDataUser.DESIGN_MODE;
    }

    public void setMode(int iMode) {
        // do nothing.
    }

    public HammerFileManager getFileManager() {
        return this.theFileManager;
    }

    public void setFileManager(HammerFileManager theFileManager) {
        this.theFileManager = theFileManager;
    }

    public HammerConfigurationManager getConfigurationManager() {
        return null;
    }

    public void setConfigurationManager(HammerConfigurationManager theConfigurationManager) {
    }

    public HammerClassLoader getClassLoader() {
        return this.theClassLoader;
    }

    public void setClassLoader(HammerClassLoader theClassLoader) {
        this.theClassLoader = theClassLoader;
    }

    public Properties getProps() {
        return props;
    }

    public String getUserHome() {
        return this.sUserHome;
    }

    public String getBaseDir() {
        return this.sBaseDir;
    }

    public int getVersionNumber() {
        return 0;
    }

    public int getRevisionNumber() {
        return 0;
    }

    public int getSubRevisionNumber() {
        return 0;
    }

    public int getBuildNumber() {
        return 0;
    }

    public void processTabPages(MetaObject theMetaObject) {
    }

    public void processMenus(MetaObject metaObject) {
    }

    public void processMenuSeparators(MetaObject theMetaObject) {
    }

    public void processMenuItems(MetaObject metaObject) {
    }


    public void processPlacement(MetaObject theObject) {
    }

    public void processCreateLayout(MetaObject theObject) {
    }

    public void processDoFrameSizeboxes(MetaObject theObject) {
    }

    public void doNewVisualObject(MetaObject theObject) {
    }

    public void updateDisplayLayer(MetaObject theObject, int iLayer) {
    }

    public void propertyEditedRepaint(MetaObject theObject) {
    }

    public void processDeleteObject(MetaObject theObject) {
    }

    public boolean getAttachedToDesigner() {
        return true;
    }
    public void processObjectNameChanged(MetaObject theObject) {
    }

    public String getSystemMetadataDocumentName() {
        return SystemMetadataDocumentName;
    }

    public void setSystemMetadataDocumentName(String SystemMetadataDocumentName) {
        this.SystemMetadataDocumentName = SystemMetadataDocumentName;
    }

    public String getSystemConfigurationPathName() {
        return SystemConfigurationPathName;
    }

    public void setSystemConfigurationPathName(String systemConfigurationPathName) {
        SystemConfigurationPathName = systemConfigurationPathName;
    }

    public String getSystemConfigurationDocumentName() {
        return SystemConfigurationDocumentName;
    }

    public void setSystemConfigurationDocumentName(String systemConfigurationDocumentName) {
        SystemConfigurationDocumentName = systemConfigurationDocumentName;
    }

    public boolean getGuruState() {
        return true; //bGuru;
    }

    public boolean getNovaState() {
        return true; //bNova;
    }

    public void showObject(MetaObject theObject) {
    }

    public void tellProgress(String s) {
    }

    public HammerLogFileAccess getLogFile() {
        return this.theLogFile;
    }

    public MetaObject getSelectedObject() {
        return null;
    }

    public MetaObject getSelectedFrame() {
        return null;
    }

    public MetaObject getSelectedContainer() {
        return null;
    }

    public boolean getOpenSourceState() {
        return false;
    }

    public boolean getDropletsState() {
        return false;
    }

    public void processProjectChangedState(boolean bState) {
    }

    private void setupClassLoader() {
        String[] sPaths = null;
        //if (theConfigurationManager != null)
        //    sPaths = theConfigurationManager.getConfigurationVariableSet("ClassPath");

        String sClassLoaderPath = null;
        String sShortClassPath = null;
        String sAuxiliaryPath = null;
        String sBaseClassPath = System.getProperty("java.class.path");
        String sUserHome = System.getProperty("user.home");

        if (sPaths != null) {
            for (int iAuxPath = 0; iAuxPath < sPaths.length; iAuxPath++) {
                if (iAuxPath > 0)
                    sAuxiliaryPath = sAuxiliaryPath + theSeparator + sPaths[iAuxPath];
                else
                    sAuxiliaryPath = sPaths[iAuxPath];
            }
        }
        // If an aux class path is defined in the config file use it to look for classes.
        // Long class path is always used to find files.
        sClassLoaderPath = "." + theSeparator;
        if (sUserHome != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sUserHome;
        if (sAuxiliaryPath != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sAuxiliaryPath;
        sShortClassPath = sClassLoaderPath;
        if (sBaseClassPath != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sBaseClassPath;
        if (sAuxiliaryPath == null)
            sShortClassPath = sClassLoaderPath;
        // Set up the final paths of the class loader.
        if (theClassLoader != null)
            theClassLoader.setPaths(sClassLoaderPath, sShortClassPath);
        else
            theClassLoader = new HammerClassLoader(this, sClassLoaderPath, sShortClassPath);
        Thread.currentThread().setContextClassLoader(theClassLoader.getLoader());
    }


}
