/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import electric.xml.Document;
import electric.xml.ParseException;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.io.*;
import java.util.Stack;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Mar 17, 2004
 * Time: 4:35:58 PM
 * To change this template use Options | File Templates.
 */
public class Outline extends JFrame {
    electric.xml.Document document = null;
    Stack stack = new Stack();
    int iIndentLevel;
    JTree tree = null;

    public void showChildElements (electric.xml.Element element) {

        electric.xml.Elements elements = element.getElements();
        while (elements.hasMoreElements()) {

            electric.xml.Element nextElement = elements.next();

            //if (nextElement.hasElements()) {
            String sNextName = nextElement.getName();
            String sValue = nextElement.getTextString();

            String sText;
            if (sValue == null) {
                sText = "<HTML><B>" + sNextName + "</B>";
            } else {
                sText = "<HTML><B><font color = blue>" + sNextName + "</B></font>";
                sText = sText.concat("<font color=red> = " + sValue + "</font></HTML>");
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(sText);
            ((DefaultMutableTreeNode) stack.peek()).add(node);

            stack.push(node);
            showChildElements(nextElement);
            stack.pop();
            //}
        }
    }

    private void openFile (String sFile) {
        System.out.println("file=" + sFile);
        File file = new File(sFile);
        //System.out.println("Found=" + file.exists());

        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStream theMetadataStream = new BufferedInputStream(in);

        try {
            document = new Document(theMetadataStream);
        } catch (ParseException e) {
            e.printStackTrace();
        }


        electric.xml.Element xmlSystemRoot = document.getRoot();
        Integer i = new Integer(xmlSystemRoot.getName().hashCode());

        DefaultMutableTreeNode root = new DefaultMutableTreeNode(xmlSystemRoot.getName());

        stack.push(root);
        //tree.add(
        tree = new JTree(root);

        showChildElements(xmlSystemRoot);

        getContentPane().add(new JScrollPane(tree));

    }

    public Outline () {
        setSize(400, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        openFile("C:\\abajava\\v2005_cdnew\\aba\\java\\src\\ch\\abacus\\lib\\ui\\renderer\\deploy\\metadata.meta");


        setVisible(true);
    }

    public static void main (String[] args) {
        Outline outline = new Outline();

        //outline.openFile("C:\\abajava\\v2005_cdnew\\aba\\java\\src\\ch\\abacus\\lib\\ui\\renderer\\deploy\\metadata.meta");
    }
}
