/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.border.Border;

import ch.abacus.lib.ui.plaf.AbacusTheme;

public class BorderFactory {

  private BorderFactory() {}


  public static Border createRaisedBevelBorder() {
	return new FlatBevelBorder(FlatBevelBorder.RAISED);
  }

  public static Border createLoweredBevelBorder() {
	return new FlatBevelBorder(FlatBevelBorder.LOWERED);
  }

  public static Border createEtchedBorder() {
    return javax.swing.BorderFactory.createEtchedBorder();
  }
  public static Border createEmptyBorder() {
    return javax.swing.BorderFactory.createEmptyBorder();
  }
  public static Border createEmptyBorder(int top, int left, int bottom, int right) {
    return javax.swing.BorderFactory.createEmptyBorder(top, left, bottom, right);
  }

  /**
   * added for setting borders on components like JAList
   * @return
   */
  public static Border createLineBorder() {
    return javax.swing.BorderFactory.createLineBorder(AbacusTheme.btnShadow);
  }
}