/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.JLabel;
import javax.swing.Icon;

public class JALabel extends JLabel {

  public JALabel() { super(); setFocusable(false); }
  public JALabel(Icon icon) { super(icon); setFocusable(false); }
  public JALabel(Icon icon, int horizontalAlignment) { super(icon, horizontalAlignment); setFocusable(false); }
  public JALabel(String text, Icon icon, int horizontalAlignment) { super(text, icon, horizontalAlignment); setFocusable(false); }
  public JALabel(String text, int horizontalAlignment) { super(text, horizontalAlignment); setFocusable(false); }
  public JALabel(String text) { super(text); setFocusable(false); }

  /** Labels cannot be focused. I don't know why Sun thinks a label has to be focused... */
  public boolean isRequestFocusEnabled() { return false; }



  public void setFocusable(boolean value) {
     super.setFocusable(value);
  }
}
