/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.*;
import java.util.Vector;

public class JAList extends JList {

  /**
   * Constructs a <code>JList</code> that displays the elements in the
   * specified, non-<code>null</code> model.
   * All <code>JList</code> constructors delegate to this one.
   *
   * @param dataModel   the data model for this list
   * @exception IllegalArgumentException   if <code>dataModel</code>
   *						is <code>null</code>
   */
  public JAList(ListModel dataModel) {
    super(dataModel);
  }

  /**
   * Constructs a <code>JList</code> that displays the elements in
   * the specified array.  This constructor just delegates to the
   * <code>ListModel</code> constructor.
   *
   * @param  listData  the array of Objects to be loaded into the data model
   */
  public JAList(Object[] listData) {
    super(listData);
  }

  /**
   * Constructs a <code>JList</code> that displays the elements in
   * the specified <code>Vector</code>.  This constructor just
   * delegates to the <code>ListModel</code> constructor.
   *
   * @param  listData  the <code>Vector</code> to be loaded into the
   *		data model
   */
  public JAList(Vector listData) {
    super(listData);
  }

  /**
   * Constructs a <code>JList</code> with an empty model.
   */
  public JAList() {
  }

}