/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * JARenderLayeredPane.java
 *
 * Creator:
 * 17.07.2003 10:02:53 Gouker
 *
 * Maintainer:
 * 17.07.2003 10:02:53 Ivancic
 *
 * Last Modification:
 * $Id: JAScrollingPanel.java,v 1.1 2005/10/13 16:09:50 agraham Exp $
 *
 * ScrollingPane class - contains a virtual and visible working area so you can put x objects
 * with "not visible x/y positions" and the ScrollingPane will show you scrollbars !
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui;

import ch.abacus.lib.ui.JALayeredPane;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;

public class JAScrollingPanel extends JALayeredPane implements Scrollable, ComponentListener, ContainerListener {
    private boolean bExpansionState = false;
    private Dimension dimSavedSize;
    private Dimension dimSavedScrPaneSize;
    private Dimension ViewportSize;

    public JScrollPane getScrollPane() {
        return theScrollPane;
    }

    public void setScrollPane(JScrollPane theScrollPane) {
        this.theScrollPane = theScrollPane;
    }

    private JScrollPane theScrollPane;

    public JAScrollingPanel(int verticalScrollableUnitIncrement, int horizontalScrollableUnitIncrement, int verticalScrollableBlockIncrement, int horizontalScrollableBlockIncrement) {
        VerticalScrollableUnitIncrement = verticalScrollableUnitIncrement;
        HorizontalScrollableUnitIncrement = horizontalScrollableUnitIncrement;
        VerticalScrollableBlockIncrement = verticalScrollableBlockIncrement;
        HorizontalScrollableBlockIncrement = horizontalScrollableBlockIncrement;
        init();
    }

    public JAScrollingPanel() {
        init();
    }

    void init() {
        this.addComponentListener(this);
        this.addContainerListener(this);
    }
    class ComponentSpace {
        Dimension dimSize = new Dimension(0, 0);
        Point ptLocation = new Point(0, 0);
        boolean bVisible = false;
        Component comp = null;
        public ComponentSpace(Component comp) {
            this.comp = comp;
        }
        void setLocation(Point pt) {
            ptLocation = pt;
        }
        void setSize(Dimension size) {
            dimSize = size;
        }
        void setHidden() {
            bVisible = false;
        }
        void setVisible() {
            bVisible = true;
        }
    }

    class ComponentSpaceAdministrator {
        ArrayList theComponents = new ArrayList(0);
        ComponentSpace getComponentSpace(Component comp) {
            for (int i=0; i<theComponents.size(); i++) {
                ComponentSpace thisComponentSpace = (ComponentSpace) theComponents.get(i);
                if (thisComponentSpace.comp.equals(comp))
                    return thisComponentSpace;
            }
            return null;
        }
        ComponentSpace addComponentSpace(Component comp) {
            ComponentSpace newComponentSpace = new ComponentSpace(comp);
            theComponents.add(newComponentSpace);
            return newComponentSpace;
        }
        boolean removeComponentSpace(Component comp) {
            for (int i=0; i<theComponents.size(); i++) {
                ComponentSpace thisComponentSpace = (ComponentSpace) theComponents.get(i);
                if (thisComponentSpace.comp.equals(comp)) {
                    theComponents.remove(i);
                    return true;
                }
            }
            return false;
        }
        Dimension calculateNecessaryRectangle() {
            Dimension dimRetVal = new Dimension(0, 0);
            for (int i=0; i<theComponents.size(); i++) {
                ComponentSpace thisComponentSpace = (ComponentSpace) theComponents.get(i);
                if (thisComponentSpace.bVisible) {
                    int cx = thisComponentSpace.ptLocation.x + thisComponentSpace.dimSize.width;
                    int cy = thisComponentSpace.ptLocation.y + thisComponentSpace.dimSize.height;
                    if (cx > dimRetVal.width)
                        dimRetVal.width = cx;
                    if (cy > dimRetVal.height)
                        dimRetVal.height = cy;
                }
            }
            return dimRetVal;
        }
    }

    private ComponentSpaceAdministrator theSpaceAdministrator = new ComponentSpaceAdministrator();
    private int VerticalScrollableUnitIncrement = 1;
    private int HorizontalScrollableUnitIncrement = 1;
    private int VerticalScrollableBlockIncrement = 1;
    private int HorizontalScrollableBlockIncrement = 1;

    public int getVerticalScrollableUnitIncrement() {
        return VerticalScrollableUnitIncrement;
    }

    public void setVerticalScrollableUnitIncrement(int verticalScrollableUnitIncrement) {
        VerticalScrollableUnitIncrement = verticalScrollableUnitIncrement;
    }

    public int getHorizontalScrollableUnitIncrement() {
        return HorizontalScrollableUnitIncrement;
    }

    public void setHorizontalScrollableUnitIncrement(int horizontalScrollableUnitIncrement) {
        HorizontalScrollableUnitIncrement = horizontalScrollableUnitIncrement;
    }

    public int getVerticalScrollableBlockIncrement() {
        return VerticalScrollableBlockIncrement;
    }

    public void setVerticalScrollableBlockIncrement(int verticalScrollableBlockIncrement) {
        VerticalScrollableBlockIncrement = verticalScrollableBlockIncrement;
    }

    public int getHorizontalScrollableBlockIncrement() {
        return HorizontalScrollableBlockIncrement;
    }

    public void setHorizontalScrollableBlockIncrement(int horizontalScrollableBlockIncrement) {
        HorizontalScrollableBlockIncrement = horizontalScrollableBlockIncrement;
    }

    public void componentAdded(ContainerEvent event) {
        Component child = event.getChild();
        if (child != null) {
            ComponentSpace theSpace = theSpaceAdministrator.addComponentSpace(child);
            theSpace.dimSize = child.getSize();
            theSpace.ptLocation = child.getLocation();
            theSpace.bVisible = child.isVisible();
        }
    }

    public void componentRemoved(ContainerEvent event) {
        Component child = event.getChild();
        if (child != null) {
            theSpaceAdministrator.removeComponentSpace(child);
        }
    }

    public void componentResized(ComponentEvent event) {
        ComponentSpace theSpace = theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.dimSize = event.getComponent().getSize();
            theSpace.ptLocation = event.getComponent().getLocation();
        }
    }

    public void componentMoved(ComponentEvent event) {
        ComponentSpace theSpace = theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.dimSize = event.getComponent().getSize();
            theSpace.ptLocation = event.getComponent().getLocation();
        }
    }

    public void componentHidden(ComponentEvent event) {
        ComponentSpace theSpace = theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.bVisible = false;
        }
    }

    public void componentShown(ComponentEvent event) {
        ComponentSpace theSpace = theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.bVisible = true;
        }
    }


    public Dimension getPreferredSize() {
        Dimension dimPreferredSize = super.getPreferredSize();
        Dimension dimRequiredSize = theSpaceAdministrator.calculateNecessaryRectangle();
        if (dimRequiredSize.width > dimPreferredSize.width)
            dimPreferredSize.width = dimRequiredSize.width;
        if (dimRequiredSize.height > dimPreferredSize.height)
            dimPreferredSize.height = dimRequiredSize.height;
//        if (getExpansionState() == false) {
//            Dimension dimSize = getSize();
//            if (dimSize.width > dimPreferredSize.width)
//                dimPreferredSize.width = dimSize.width;
//            if (dimSize.height > dimPreferredSize.height)
//                dimPreferredSize.height = dimSize.height;
//        }
        return dimPreferredSize;
    }
    /**
     * Returns the preferred size of the viewport for a view component.
     * For example the preferredSize of a JList component is the size
     * required to accommodate all of the cells in its list however the
     * value of preferredScrollableViewportSize is the size required for
     * JList.getVisibleRowCount() rows.   A component without any properties
     * that would effect the viewport size should just return
     * getPreferredSize() here.
     *
     * @return The preferredSize of a JViewport whose view is this Scrollable.
     * @see JViewport#getPreferredSize
     */
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimRequiredSize = theSpaceAdministrator.calculateNecessaryRectangle();
//        return getSize();   // scroll over whatever size we have on the screen.
        return dimRequiredSize;
    }


    /**
     * Components that display logical rows or columns should compute
     * the scroll increment that will completely expose one new row
     * or column, depending on the value of orientation.  Ideally,
     * components should handle a partially exposed row or column by
     * returning the distance required to completely expose the item.
     * <p>
     * Scrolling containers, like JScrollPane, will use this method
     * each time the user requests a unit scroll.
     *
     * @param visibleRect The view area visible within the viewport
     * @param orientation Either SwingConstants.VERTICAL or SwingConstants.HORIZONTAL.
     * @param direction Less than zero to scroll up/left, greater than zero for down/right.
     * @return The "unit" increment for scrolling in the specified direction.
     *         This value should always be positive.
     * @see JScrollBar#setUnitIncrement
     */
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == SwingConstants.VERTICAL)
            return this.getVerticalScrollableUnitIncrement();
        else return this.getHorizontalScrollableUnitIncrement();
    }


    /**
     * Components that display logical rows or columns should compute
     * the scroll increment that will completely expose one block
     * of rows or columns, depending on the value of orientation.
     * <p>
     * Scrolling containers, like JScrollPane, will use this method
     * each time the user requests a block scroll.
     *
     * @param visibleRect The view area visible within the viewport
     * @param orientation Either SwingConstants.VERTICAL or SwingConstants.HORIZONTAL.
     * @param direction Less than zero to scroll up/left, greater than zero for down/right.
     * @return The "block" increment for scrolling in the specified direction.
     *         This value should always be positive.
     * @see JScrollBar#setBlockIncrement
     */
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == SwingConstants.VERTICAL)
            return this.getVerticalScrollableBlockIncrement();
        else return this.getHorizontalScrollableBlockIncrement();
    }


    /**
     * Return true if a viewport should always force the width of this
     * <code>Scrollable</code> to match the width of the viewport.
     * For example a normal
     * text view that supported line wrapping would return true here, since it
     * would be undesirable for wrapped lines to disappear beyond the right
     * edge of the viewport.  Note that returning true for a Scrollable
     * whose ancestor is a JScrollPane effectively disables horizontal
     * scrolling.
     * <p>
     * Scrolling containers, like JViewport, will use this method each
     * time they are validated.
     *
     * @return True if a viewport should force the Scrollables width to match its own.
     */
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    /**
     * Return true if a viewport should always force the height of this
     * Scrollable to match the height of the viewport.  For example a
     * columnar text view that flowed text in left to right columns
     * could effectively disable vertical scrolling by returning
     * true here.
     * <p>
     * Scrolling containers, like JViewport, will use this method each
     * time they are validated.
     *
     * @return True if a viewport should force the Scrollables height to match its own.
     */
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getExpansionState() {
        return bExpansionState;
    }

    public void expand() {
        Dimension dimSavedSize = this.getSize();
        if (getScrollPane() != null) {
            JViewport theViewport = getScrollPane().getViewport();
            if (theViewport != null) {
                dimSavedSize = theViewport.getSize();
                dimSavedScrPaneSize = getScrollPane().getSize();
            }
        }
        Dimension dimViewportSize = this.getViewportSize();
        if (dimViewportSize != null) {
            if (dimViewportSize.equals(new Dimension(0,0))== false) {
                if (dimViewportSize.width < dimSavedSize.width)
                    dimSavedSize.width = dimViewportSize.width;
                if (dimViewportSize.height < dimSavedSize.height)
                    dimSavedSize.height = dimViewportSize.height;
            }
        }
        this.dimSavedSize = dimSavedSize;
        Dimension dimNewSize;
        dimNewSize = getPreferredSize();
        setSize(dimNewSize);
        bExpansionState = true;
        if (getScrollPane() != null) {
            Insets theInsets = getScrollPane().getInsets();
            dimNewSize.height += (theInsets.top + theInsets.bottom);
            dimNewSize.width += (theInsets.left + theInsets.right);
            getScrollPane().setSize(dimNewSize);
            JViewport theViewport = getScrollPane().getViewport();
            theViewport.setView(this);
        }
    }

    public Dimension getViewportSize() {
        return ViewportSize;
    }

    public void setViewportSize(Dimension dim) {
        this.ViewportSize = dim;
    }

    public void reduce() {
        if (dimSavedSize != null) {
            setSize(dimSavedSize);
            if (getScrollPane() != null) {
                getScrollPane().setSize(dimSavedScrPaneSize);
                JViewport theViewport = getScrollPane().getViewport();
                theViewport.setView(this);
            }
        }
        bExpansionState = false;
    }

}
