/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Apr 14, 2004
 * Time: 3:05:17 PM
 */
package ch.abacus.lib.ui.customizer;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.util.ArrayList;

/**
 * CustomizerDataElementInterface - this class represents a data-element in the Customizer.
 */
public interface CustomizerDataElementInterface {

    /**
     * getDataElementName - returns the name of the data element which is used to
     * connect to a data source.
     *
     * @return String - the element name.
     */
    String getDataElementName();

    /**
     * getDisplayName - returns the name that displays for the element in the component list.
     *
     * @return String - the table name.
     */
    String getDisplayName();

    /**
     * getListOfDataElements - returns any children of this element.  This is for
     * nested data source elements (aka sub-elements).
     *
     * @return ArrayList (set of CustomizerDataElement)
     */
    ArrayList getListOfDataElements();

    /**
     * getDataElementCount - returns the number of child data-elements (sub-elements).  Zero if there
     * are no children.
     *
     * @return int - the number of child elements.
     */
    int getDataElementCount();

    /**
     * getAvailableImplementingClasses - returns classes that <I>can</I> be used to represent
     * the element. If non-null, they will be displayed in a list for the user to select
     * @return an array of objects to list, or null to indicate that there is no list of alternatives
     * and that the value returned from getImplementingClass() should be used for the class.
     */
    CustomizerAvailableClass[] getAvailableImplementingClasses();

    /**
     * getImplementingClass - returns the name of the metadata class to use to
     * represent this data element.  This is the class that represents the data
     * object interface.
     *
     * @return String - the class to use to represent the data object.
     */
    String getImplementingClass();

    /**
     * setImplementingClass - sets the value returned by calls to getImplementingClass.<br>
     * This is needed if getAvailableImplementingClasses() returns a list of classes, to denote which actual class
     * the user selected
     */
    void setImplementingClass(String sClassName);

    /**
     * getIcon - some data elements will show a different icon for their
     * leaf rendering in the Component Palette.
     *
     * @return Icon - the icon for leaf rendering.
     */
    Icon getIcon();

    /**
     * getDataTable - returns the associated data-table.
     * @return CustomizerDataTableInterface - the data-table associated.
     */
    CustomizerDataTableInterface getDataTable();

    /**
     * getParentDataElement - returns the parent data-element of a child data-element (only sub-elements has parent elements).
     * @return getParentDataElement - the parent data-element of the child element.
     * returns null if there is no parent.
     */
    CustomizerDataElementInterface getParentDataElement();

    /**
     * getToolTip - the tooltip to display when the mouse hovers over the Element in the Customizer's Component Tree
     * <p><B>Note:</B> You can use HTML in the string to achieve visual affects. For example:
     * <Pre>return "<HTML>&LT;HTML&GT;The &LT;B&GT;Country&LT;/B&GT that the customer resides in&LT;/HTML&GT;"</Pre>
     * <p> will output "<HTML>The <B>Country</B> that the customer resides in&quot</HTML>
     * @return  the text to display
     */
    String getToolTip();

    /**
     * newInstanceCreated - a callback that is made when the Customizer creates a component from a data-element.
     * @param metaObject - the Customizer's component in the Designer
     * @param dataElement - the DataElement that was used to create the Component
     */
    void newInstanceCreated(MetaObject metaObject, CustomizerDataElementInterface dataElement);

    /**
     * The name to use when the component is created. Ensure that the syntax is a valid object name.<P>
     * <B>NOTE:</B> The Customizer will still ensure the object name is unique in the form, by ading a number to the end
     * of the name. So, it is typically a good idea to return your name ending withan "_" to make this stand out.
     * @return object name
     */
    String getObjectName();
}
