/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  CustomizerDataSourceID.java
 *
 *  Class for encapsulating the ID of a Datasource, which has a Context and a Name
 *
 * Creator:
 * 29.12.2003 15:33:54 vegh
 *
 * Maintainer:
 * 29.12.2003 15:33:54 vegh
 *
 * Last Modification:
 * $Id: CustomizerDataSourceID.java,v 1.1 2004/11/01 15:41:04 vegh Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui.customizer;

public class CustomizerDataSourceID {

    private String m_Context;
    private String m_Name;


    public CustomizerDataSourceID ( String _context, String _name ) {
        if ( ( _context != null ) && ( !_context.equals ( "") )){
          m_Context = _context;
        }
        m_Name = _name;
    }

    public String getContext () {
        return m_Context;
    }

    public String getName () {
        return m_Name;
    }

    public boolean equals ( Object obj ) {
        if ( !( obj instanceof CustomizerDataSourceID ) ) return false;

        CustomizerDataSourceID id = ( CustomizerDataSourceID ) obj;


        if ( m_Context == null ) {
            if ( id.getContext () != null ) return false;
        } else {
            if ( id.getContext () == null ) return false;
            if ( !id.getContext ().equals ( m_Context ) ) return false;
        }

        if ( !id.getName ().equals ( m_Name ) ) return false;
        return true;
    }

    public int hashCode () {
        return toString ().hashCode ();
    }


    public String toString () {
        if ( m_Context != null ) {
            if ( !( m_Context.equals ( "" ) ) ) {
                return m_Context + "_" + m_Name;
            } else {
                return m_Name;
            }
        }
        return m_Name;
    }


}
