/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Apr 14, 2004
 * Time: 3:03:16 PM
 */
package ch.abacus.lib.ui.customizer;

import javax.swing.*;
import java.util.ArrayList;

/**
 * CustomizerDataTableInterface - this interface describes classes of data sources that contain
 * elements that can be associated with display fields.
 */
public interface CustomizerDataTableInterface {
    /**
     * getDataElementCount - the number of data-elements for this data source.
     * @return int - the number of data elements.
     */
    int getDataElementCount();
    /**
     * getDisplayName - returns the name that displays for the table in the Component Palette.
     *
     * @return String - the table name.
     */
    String getDisplayName();
    /**
     * getDataElements - returns an array list of CustomizerDataElement instances, which describe
     * sources of data that can be associated with objects in the designer.
     *
     * @return ArrayList - set of CustomizerDataElement instances.
     */
    ArrayList getDataElements();
    /**
     * getDataTableName - returns the data-table name
     * @return String - the name of the data-table.
     */
    String getDataTableName();
    /**
     * getDataConnection - returns the connection object that produced the table
     * object.
     *
     * @return CustomizerDataConnectionInterface - the data connection controlling this table object.
     */
    CustomizerDataConnectionInterface getDataConnection();

    /**
     * a callback method that requires you to create the deferred Data Elements of this table.<p>
     * Data Elements can be created initially with the Data Table, or deferred for later creation (for performance reasons).<p>
     * You will receive this if the initial call to getDataElements returned null. Bacause this method is used to create the Data Elements, you will only recieve it at the time the Data Elements are required to be used.
      * @return return true if you populated the Data Elements, or false otherwise.
     */
    boolean populateDeferredDataElements();

    /**
     * getToolTip - the tooltip to display when the mouse hovers over the Element in the Customizer's Component Tree
     * <p><B>Note:</B> You can use HTML in the string to achieve visual affects. For example:
     * <Pre>return "<HTML>&LT;HTML&GT;The &LT;B&GT;Country&LT;/B&GT that the customer resides in&LT;/HTML&GT;"</Pre>
     * <p> will output "<HTML>The <B>Country</B> that the customer resides in&quot</HTML>
     * @return  the text to display
     */
    String getToolTip();

    /**
     * getIcon - the icon to display in the Component Palette for the node representing the Data Table objects
     *
     * @return Icon - the icon for node rendering.
     */
    Icon getIcon();

    /**
     * getDataTables - returns an array list of CustomizerDataTable instances. These instances are used for grouping DataTables. Child DataTables are displayed as leaf nodes in the Customizer's Component Palette.
     * @return ArrayList - the data-tables that represent data sources to associate with
     * data fields.
     */
    ArrayList getDataTables ();

    /**
     * getDataTableCount - the number of child data-tables for this data-table.
     * @return int - the number of data-tables.
     */
    int getDataTableCount();

    /**
     * getDataTableContext - The name of the table-context
     * @return the table-context, if one exists, or null
     */
    String getDataTableContext();


}
