/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 12:27:41 Misteli
 *
 * Maintainer:
 * 19.04.2005 12:27:41 Misteli
 *
 * Last Modification:
 * $Id: PropertyEditorInterface.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.propertyinspector.core.Property;

/**
 * The PropertyEditorInterface is used to implement a property editor. As soon as a property has its own property editor,
 * the property will display a little button on the right side of the value of the property which, when pressed, will invoke
 * the property editor.
 */
public interface PropertyEditorInterface {

  /**
   * edit is called when the user presses the little button on the right side of the value of a property that is currently edited.
   * @param event The event object that contains all the data used to invoke the property editor.
   */
  public void edit(PropertyEditorEvent event);

  /**
   * is called to determine whether a property editor shall be visible at this time or not. A property editor might not be visible for
   * multiple selection, for example
   * @return
   */
  public boolean isVisible(Property property);

}
