/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 15:43:26 Misteli
 *
 * Maintainer:
 * 18.04.2005 15:43:26 Misteli
 *
 * Last Modification:
 * $Id: PropertyNameCellRenderer.java,v 1.2 2005/09/13 14:50:03 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;

import javax.swing.JLabel;
import javax.swing.JTable;
import java.awt.Component;

public class PropertyNameCellRenderer extends BaseCellRenderer {

  private JLabel label = new JLabel();

  public PropertyNameCellRenderer(JTable table) {
    super(table);
    label.setOpaque(true);
  }

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    initialize(label, table, isSelected, hasFocus, row, column);
    DisplayProperty displayProperty = (DisplayProperty) value;
    border.init(displayProperty);
    label.setBorder(border);
    label.setFont(font);
    label.setText(displayProperty.getProperty().getName());
    if (((PropertyModel) table.getModel()).getSelection().size() > 1 && displayProperty.getProperty().isSingleSelection()) {
      displayProperty.setHint(((PropertyModel) table.getModel()).getLanguageStrings().get("single selection"));
      displayProperty.setHelp(displayProperty.getHint());
    }
    else
    if (displayProperty.getProperty().isReadOnly()) {
      displayProperty.setHint(((PropertyModel) table.getModel()).getLanguageStrings().get("readonly"));
      displayProperty.setHelp(displayProperty.getHint());
    }
    else
    if (displayProperty.isEnabled()) {
      displayProperty.setHint(displayProperty.getProperty().getHint());
      displayProperty.setHelp(displayProperty.getProperty().getHelp());
    }

//    if (displayProperty.getProperty().getPropertyEditor() != null)
//      label.setIcon(displayProperty.getProperty().getPropertyEditor().getIcon());
//    else
//      label.setIcon(null);
    return label;
  }
}
