/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.HammerException;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

/**
 * <p>Title: Abacus Java AbaRenderer</p>
 * <p>Description: This library renders java interfaces from XML descriptions</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company:A Abacus Research</p>
 * @author Michael Gouker (Cagey Logic Technologies)
 * @version 1.0
 */

public class TestRenderer extends JAFrame {
// someClassThatImplementsGlobalInterface globalInterface;
    JATextField prozField = new JATextField();
    JAButton goButton = new JAButton("Go");

    public TestRenderer() {
        addWindowListener(new MainWindowListener());
        setSize(100, 100);
        setSize(100, 100);
        setLocation(100, 100);
        setTitle("Renderer Launcher");
        Container theContainer = this.getContentPane();
        theContainer.setLayout(new GridLayout(2, 1));
        theContainer.add(prozField);
        theContainer.add(goButton);
        goButton.addActionListener(new GoButtonListener());
        show();
    }

    public void render(String sDocumentName) throws HammerException {
        // Next line needs to be uncommented to work with global interface.
        //  AbaRenderer theRenderer = new AbaRenderer(sDocumentName, false, globalInterface);
        if (sDocumentName.endsWith(".jar") && !sDocumentName.startsWith("http:")) {
            File docFile = new File(sDocumentName);
            if (docFile.exists())
                sDocumentName = docFile.getAbsolutePath();
        }
        DefaultPathAbaRenderer theRenderer = new DefaultPathAbaRenderer(sDocumentName, true, null);
        // test discrete path for rog misteli.
        //theRenderer.setSystemConfigurationPathName("c:\\dev\\v2005_cdnew\\aba\\java\\src\\ch\\abacus\\lib\\ui\\renderer\\deploy\\");
        boolean bTest = theRenderer.load();

        if (bTest) {
            JAFrame theFrame = new JAFrame();
            theFrame.setTitle("Test Rendering of " + sDocumentName);
            theFrame.setLocation(100, 100);
            theFrame.setSize(500, 400);
            JAPanel thePanel = new JAPanel();
            thePanel.setLocation(0, 0);
            thePanel.setSize(500, 400);
            theFrame.getContentPane().add(thePanel);
            theFrame.show();
            theRenderer.renderInterface(thePanel);
            theFrame.setVisible(false);
            theFrame.setVisible(true);
//            theRenderer.renderInterface();
//            Dimension dimFrameSize = thRenderer.getBaseFrameSize();
//            System.out.println("Dim X: " + dimFrameSize.getWidth() + ", Dim Y: " + dimFrameSize.getHeight());
//            theRenderer.testRemove();
            theFrame.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            theRenderer.setFocus();
            theFrame.addWindowListener(new ChildWindowListener(theFrame, theRenderer));
            KeyboardFocusManager focusManager =
                    KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            System.out.println("New focus is: " + newFocus.getName());

        }

    }

    class GoButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                render(prozField.getText());
            } catch (HammerException e1) {
                e1.printStackTrace();  //To change body of catch statement use Options | File Templates.
            }
        }

    }

    class MainWindowListener extends WindowAdapter {
    }

    class ChildWindowListener extends WindowAdapter {
        private JAFrame theFrame;
        private AbaRenderer theRenderer;

        ChildWindowListener(JAFrame theFrame, AbaRenderer theRenderer) {
            this.theFrame = theFrame;
            this.theRenderer = theRenderer;
        }

        public void windowClosing(WindowEvent evt) {
            System.out.println("Window is closed.  Getting back resources.");
            theRenderer.close();
            super.windowClosing(evt);
            theRenderer = null;
            theFrame = null;
            System.gc();
        }
    }

    public static void main(String[] args) {
        new TestRenderer();
    }
}