/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.io.*;

/**
 * Title:        FileCopy
 * Description:  This is just a simple module that contains a class to copy files.
 *               See the documentation of the class below for more details.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

/**
 * FileCopy class - This is a simple class that implements a static method to
 * copy files.  This might eventually be turned into a more general class for
 * different I/O operations with files.
 */

public class FileCopy {

    public FileCopy() {
    }

    /**
     * CopyFile - This method copies one stream to another.  It is used internally
     *          to implement a high-level copy file implementation.
     *
     *  @param  streamIn - The input stream that is copied to the output stream.
     *  @param  streamOut - The output stream to write.
     *
     */

    private static void copyFile(InputStream streamIn, OutputStream streamOut) throws java.io.IOException {
        int byteIn;
        while ((byteIn = streamIn.read()) != -1)
            streamOut.write(byteIn);
        streamIn.close();
        streamOut.close();
    }

    /**
     * CopyFile - This method copies one file to another.
     *
     * @param  strFileIn - The name of the file to copy to the output file.
     * @param  strFileOut - The name of the output file.
     *
     */

    public static boolean copyFile(String strFileIn, String strFileOut) throws java.io.FileNotFoundException, java.io.IOException {
        BufferedInputStream streamIn = null;
        BufferedOutputStream streamOut = null;
        File fileTest = new File(strFileIn);
        if (fileTest.isFile() == false)
            return false;  // Can't proceed - no input file.
        fileTest = new File(strFileOut);
        if (fileTest.isFile() == false)
            fileTest.createNewFile();
        // Now we have a file to copy to.
        streamIn = new BufferedInputStream(new FileInputStream(strFileIn));
        streamOut = new BufferedOutputStream(new FileOutputStream(strFileOut));
        copyFile(streamIn, streamOut);
        return true;
    }

}