/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;

import java.io.File;
import java.util.ArrayList;

//import electric.xml.*;

public class HammerConfigurationManager {

    Document theConfigurationDocument = null;
    Element theRootElement = null;
    String sBaseDir = "";
    String sUserHome = "";
    ArrayList theNLSDocuments = new ArrayList(0);
    public boolean bConfigured = false;
    public String thePathName;
    public String theJarName;
    public int theMode = HammerInputStream.UNDEFINED_INPUT_TYPE;

    public HammerConfigurationManager(String sBaseDir, String sUserHome, HammerClassLoader theLoader, String sConfigXMLDocument) {
        try {
            this.sBaseDir = sBaseDir;
            this.sUserHome = sUserHome;
            HammerInputStream fileInput = theLoader.theLoader.getFileInPathAsStream(sConfigXMLDocument);
            if ((fileInput != null) && (fileInput.theStream != null)) {
                theConfigurationDocument = new Document(fileInput.theStream);
                if (theConfigurationDocument != null) {
                    theRootElement = theConfigurationDocument.getRoot();
                    if (theRootElement != null)
                        bConfigured = true;
                }
                thePathName = fileInput.sFullPathName;
                theJarName = fileInput.sJarName;
                theMode = fileInput.mode;
            }
        } catch (ParseException e2) {
        }
    }

    String doAllTranslations(String sValue, String sKey, String sReplace) {
//      System.err.println("Translation of "+sValue);
//     System.err.println("Key is "+sKey);
//      System.err.println("Replace is "+sReplace);
        if (sKey == null)
            return sValue;
        if (sValue == null)
            return sValue;
        while (true) {
            int iMatch = sValue.indexOf(sKey);
//          System.err.println("Match is "+iMatch);
            if (iMatch == -1) {
//              System.err.println("Returning: "+sValue);
                return sValue;
            }
            String sLeft = sValue.substring(0, iMatch);
            String sRight = sValue.substring(iMatch + sKey.length());
//          System.err.println("Left: "+sLeft);
//          System.err.println("Right: "+sRight);
            sValue = sLeft + sReplace + sRight;
        }
    }

    public String getTranslatedValue(String sValue) {
        if (sValue != null) {
            sValue = doAllTranslations(sValue, "%BaseDir%", sBaseDir);
            sValue = doAllTranslations(sValue, "%UserHome%", sUserHome);
            // allow the path separator to be specified or not.
            sValue = doAllTranslations(sValue, "\\\\", "\\");
        }
        return sValue;
    }

    public boolean checkConfigurationSetting(String sTagName) {
        if (theRootElement != null) {
            Element theConfigurationElement = theRootElement.getElement(sTagName);
            if (theConfigurationElement != null)
                return true;
            else
                return false;
        }
        return false;
    }

    public String getConfigurationVariable(String sTagName) {
        if (theRootElement != null) {
            Element theConfigurationElement = theRootElement.getElement(sTagName);
            if (theConfigurationElement != null)
                return getTranslatedValue(theConfigurationElement.getTextString());
            else
                return null;
        }
        return null;
    }

    public String getConfigurationVariable(String sTagName, String sDefaultValue) {
        if (theRootElement != null) {
            Element theConfigurationElement = theRootElement.getElement(sTagName);
            if (theConfigurationElement != null)
                return getTranslatedValue(theConfigurationElement.getTextString());
            else
                return sDefaultValue;
        }
        return sDefaultValue;
    }

    public String getConfiguredDirectory(String sDirectoryPath) {
        String sSeparator = System.getProperties().getProperty("file.separator");
        String sRootDirectory = getConfigurationVariable("RootDirectory");
        String sReturnValue = sDirectoryPath;
        if (sRootDirectory != null) {
            if (sRootDirectory.endsWith(sSeparator)) {
                if (sDirectoryPath.substring(0, 0).equals(sSeparator))
                    sReturnValue = sRootDirectory + sDirectoryPath.substring(1);
                else
                    sReturnValue = sRootDirectory + sDirectoryPath;
            } else {
                if (sDirectoryPath.substring(0, 0).equals(sSeparator))
                    sReturnValue = sRootDirectory + sDirectoryPath;
                else
                    sReturnValue = sRootDirectory + sSeparator + sDirectoryPath;
            }
        }
        File temp = new File(sReturnValue);
        if (temp.exists() == false)
            temp.mkdirs();
        return sReturnValue + sSeparator;
    }

    public String getCacheDirectory() {
        String sCacheDir = getConfigurationVariable("CacheDirectory");
        if (sCacheDir == null)
            sCacheDir = getConfiguredDirectory("cache");
        return sCacheDir;
    }

    public String getLogDirectory() {
        String sLogDir = getConfigurationVariable("LogDirectory");
        if (sLogDir == null)
            sLogDir = getConfiguredDirectory("log");
        return sLogDir;
    }

    public String getResourcesDirectory() {
        String sResourcesDir = getConfigurationVariable("ResourcesDirectory");
        if (sResourcesDir == null)
            sResourcesDir = getConfiguredDirectory("resources");
        return sResourcesDir;
    }

    public String[] getConfigurationVariableSet(String sTag) {
        if (theRootElement != null) {
            Elements theConfigurationElements = theRootElement.getElements(sTag);
            if (theConfigurationElements.size() < 1)
                return null;
            String[] theReturnValue = new String[theConfigurationElements.size()];
            Element theConfigurationElement = theConfigurationElements.next();
            for (int i = 0; i < theConfigurationElements.size(); i++) {
                theReturnValue[i] = getTranslatedValue(theConfigurationElement.getTextString());
                theConfigurationElement = theConfigurationElements.next();
            }
            return theReturnValue;
        }
        return null;
    }

    public boolean loadNLSDocuments() {
        if (theRootElement != null) {
            Elements theConfigurationElements = theRootElement.getElements("NLSDocument");
            if (theConfigurationElements.size() < 1)
                return false;
            Element theNLSPath;
            for (int i = 0; i < theConfigurationElements.size(); i++) {
                theNLSPath = theConfigurationElements.next();
                Element xmlNLSDocumentKey = theNLSPath.getElement("Key");
                Element xmlNLSDocumentPath = theNLSPath.getElement("Path");
                String sDocumentKey = xmlNLSDocumentKey.getTextString();
                String sDocumentPath = xmlNLSDocumentPath.getTextString();
                HammerNLSAccess theNLSDoc = new HammerNLSAccess(sDocumentKey, sDocumentPath);
                theNLSDocuments.add(theNLSDoc);
            }
            return true;
        }
        return false;
    }

    public int getNLSDocCount() {
        if (theNLSDocuments != null)
            return theNLSDocuments.size();
        else
            return 0;
    }

    public String getNLSDocKey(int i) {
        if (theNLSDocuments != null)
            return ((HammerNLSAccess) theNLSDocuments.get(i)).sKey;
        else
            return null;
    }

    public String getNLSDocName(int i) {
        if (theNLSDocuments != null)
            return ((HammerNLSAccess) theNLSDocuments.get(i)).sDocument;
        else
            return null;
    }
}
