/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 07.10.2003
 * Time: 19:21:44
 * To change this template use Options | File Templates.
 */
public class HammerException extends Exception {
    String sMessage;
    String sLocalizedMessage;
    int iExceptionCode;

    public static int BAD_LNF = 1;
    public static int NO_CONFIGURATION_MANAGER_AVAILABLE = 2;
    public static int NO_LOGFILE_AVAILABLE = 3;
    public static int NO_METADATA_AVAILABLE = 4;
    public static int BAD_XML_IN_PROJ = 5;
    public static int CANNOT_OPEN_PROJ = 6;
    public static int CANNOT_READ_PROJ = 7;
    public static int NO_MAIN_OBJECT_RENDERED = 8;
    public static int NOT_RENDERED_TO_DESTINATION = 9;
    public static int BAD_UTF8_CONVERSION = 9;
    public static int BAD_COMPRESSED_PROJECT_FILE_FORMAT = 10;
    public static int CANNOT_SAVE_TO_OPEN_JAR = 11;
    public static int COMPILATION_ERRORS_OCCURRED = 12;
    public static int CANNOT_CREATE_PROZ_FILE = 13;
    public static int CANNOT_SAVE_PROZ_FILE = 14;
    public static int CANNOT_CREATE_PROJ_FILE = 15;
    public static int CANNOT_CREATE_CONSTANT = 16;
    public static int CANNOT_CAST_CONSTANT = 17;
    public static int PROJECT_NOT_LOADED = 18;
    public static int CANNOT_OPEN_NLS_DOCUMENT = 19;

    public HammerException() {
    }

    public HammerException(int iExceptionCode) {
        super();
        this.iExceptionCode = iExceptionCode;
    }

    public HammerException(int iExceptionCode, String sMessage) {
        super(sMessage);
        this.iExceptionCode = iExceptionCode;
        this.sMessage = sMessage;
    }

    public HammerException(int iExceptionCode, String sMessage, String sLocalizedMessage) {
        super(sMessage);
        this.iExceptionCode = iExceptionCode;
        this.sLocalizedMessage = sLocalizedMessage;
        this.sMessage = sMessage;
    }

    public String getMessage() {
        return sMessage;
    }

    public String getLocalizedMessage() {
        return sLocalizedMessage;
    }

    public int getExceptionCode() {
        return iExceptionCode;
    }
}
