/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;


/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class MetaClassDetail {
    int iVisibility = 0;
    public static final int VISIBILITY_PUBLIC = 1;
    public static final int VISIBILITY_PRIVATE = 2;
    public static final int VISIBILITY_PROTECTED = 3;
    public String sClassName = null;
    public String sFullClassName = null;
    private String DisplayName = null;
    public boolean bUsed = false;
    public boolean bHidden = false;
    public boolean bSkipDecl = false;
    public boolean bDesignBorders = false;
    public boolean bCompositeComponent = false;
    String sSuperClassName = "";
    String sFullPathOfSuperClass = "";
    public boolean bDefaultListeners = true;
    public String sDisplayClass = "";
    public MetaClassDetail theNextClass = null;
    public MetaDataMember theFirstData = null;
    public MetaDataMember theLastData = null;
    public MetaContainerType containerType = new MetaContainerType(MetaContainerType.CONTAINER_NONE);
    public int iNumberOfMethods = 0;
    public int iNumberOfProperties = 0;
    public int iNumberOfDataElements = 0;
    public MetaMethod theFirstMethod = null;
    public MetaMethod theLastMethod = null;
    public MetaPropertyDescriptor theFirstProperty = null;
    public MetaPropertyDescriptor theLastProperty = null;
    public MetaClassDetail theFirstListener = null;
    public MetaClassDetail theLastListener = null;
    public String sAddListenerMethod = "";
    public String sRemoveListenerMethod = "";
    public String sCustomCodeGenerationMethod = "";
    public String theFactoryName = null;
    public String theDesignEditor = null;
    HashMap defaultPropertyValues = new HashMap(50);
    HashMap defaultTranslatedPropertyValues = new HashMap(50);
    public String sClassComment = null; // used to store the comments from the metadata.meta file
    public String sDisplayClassIcon ="";

// Constructors & Destructors.

    public MetaClassDetail() {
    }

    public MetaClassDetail(String sClassName, String sFullClassName) {
        this.sClassName = sClassName;
        this.sFullClassName = sFullClassName;
    }

    // for cloning and subclasses
    public MetaClassDetail(MetaClassDetail objClassMetadata, MetadataDispenser thetheMetadataDispenser) {
        iVisibility = objClassMetadata.iVisibility;
        sClassName = new String(objClassMetadata.sClassName);
        sFullClassName = new String(objClassMetadata.sFullClassName);
        setDisplayName(new String(objClassMetadata.getDisplayName()));
        sSuperClassName = new String(objClassMetadata.sSuperClassName);
        sFullPathOfSuperClass = new String(objClassMetadata.sFullPathOfSuperClass);
        if (objClassMetadata.theFactoryName != null)
            theFactoryName = new String(objClassMetadata.theFactoryName);
        if (objClassMetadata.theDesignEditor != null)
            theDesignEditor = new String(objClassMetadata.theDesignEditor);
        if (objClassMetadata.sDisplayClass != null)
            sDisplayClass = new String(objClassMetadata.sDisplayClass);
        else
            sDisplayClass = "";
        sCustomCodeGenerationMethod = objClassMetadata.sCustomCodeGenerationMethod;
        sRemoveListenerMethod = objClassMetadata.sRemoveListenerMethod;
        sAddListenerMethod = objClassMetadata.sAddListenerMethod;
        containerType = objClassMetadata.containerType;
        bDefaultListeners = objClassMetadata.bDefaultListeners;
        bHidden = objClassMetadata.bHidden;
        bSkipDecl = objClassMetadata.bSkipDecl;
        bDesignBorders = objClassMetadata.bDesignBorders;
        // Copy data below it.
        MetaDataMember theDataMetadata = objClassMetadata.theFirstData;
        while (theDataMetadata != null) {
            addData(theDataMetadata.sFieldName,
                    theDataMetadata.sTypeName,
                    theDataMetadata.sClassName,
                    theDataMetadata.sValue,
                    theDataMetadata.sDoc);
            theDataMetadata = theDataMetadata.theNextData;
        }
        // Copy properties below it.
        MetaPropertyDescriptor thePropertyListMetadata = objClassMetadata.theFirstProperty;
        while (thePropertyListMetadata != null) {
            String[] sValueChoices = new String[thePropertyListMetadata.getValueChoiceCount()];
            for (int k = 0; k < thePropertyListMetadata.getValueChoiceCount(); k++)
                sValueChoices[k] = thePropertyListMetadata.getValueChoiceAsString(k);
            addProperties(thetheMetadataDispenser,
                    thePropertyListMetadata.sName, thePropertyListMetadata.sType,
                    thePropertyListMetadata.sClass, sValueChoices,
                    thePropertyListMetadata.sDoc,
                    thePropertyListMetadata.getDefaultValue(),
                    thePropertyListMetadata.sSetName,
                    thePropertyListMetadata.sGetName,
                    thePropertyListMetadata.theHelperClass,
                    thePropertyListMetadata.getIncludeTypeConstants(),
                    thePropertyListMetadata.getOrder(),
                    thePropertyListMetadata.bVisible,
                    thePropertyListMetadata.bGenerate,
                    thePropertyListMetadata.bAllowMultipleValues,
                    thePropertyListMetadata.bAllowMultipleLanguages,
                    thePropertyListMetadata.isReadOnly());
            thePropertyListMetadata = thePropertyListMetadata.theNextProperty;
        }
        // Copy methods below it.
        MetaMethod theMethodMetadata = objClassMetadata.theFirstMethod;
        while (theMethodMetadata != null) {
            addMethod(theMethodMetadata.sMethodName, theMethodMetadata.sMethodText, theMethodMetadata.sMethodDoc);
            theMethodMetadata = theMethodMetadata.theNextMethod;
        }
    }

    String makeMethodText(Method theMethod, boolean bInherits) {
        String sText = "public " + theMethod.getReturnType().getName() + " " + theMethod.getName() + "(";
        Class theParams[] = theMethod.getParameterTypes();
        for (int iParam = 0; iParam < theParams.length; iParam++) {
            if (iParam != 0)
                sText = sText + ", ";
            sText = sText + theParams[iParam].getName() + " p" + iParam;
        }
        sText = sText + ") { \n";
        if (bInherits) {
            sText = sText + "    super." + theMethod.getName() + "(";
            for (int iParam = 0; iParam < theParams.length; iParam++) {
                if (iParam != 0)
                    sText = sText + ", ";
                sText = sText + "p" + iParam;
            }
            sText = sText + ");";
        }
        sText = sText + "\n}\n";
        return sText;
    }


    public MetaClassDetail(Class cls) {
        iVisibility = VISIBILITY_PUBLIC;    // Only works with public classes.
        sClassName = cls.getName();
        sFullClassName = cls.getName();
        sSuperClassName = new String(cls.getSuperclass().getName());
        sFullPathOfSuperClass = new String(cls.getSuperclass().getName());
        sDisplayClass = null;               // Need to set this manually for now.
        containerType = new MetaContainerType(MetaContainerType.CONTAINER_NONE);  // Need to set this manually for now.
        // Copy data below it.
//        MetaDataMember theDataMetadata = objClassMetadata.theFirstData;
//        while (theDataMetadata != null) {
//            addData(theDataMetadata.sFieldName,
//                    theDataMetadata.sTypeName,
//                    theDataMetadata.sValue,
//                    theDataMetadata.sDoc);
//            theDataMetadata = theDataMetadata.theNextData;
//        }
        // Copy properties below it.
//        MetaPropertyDescriptor thePropertyListMetadata = objClassMetadata.theFirstProperty;
//        while (thePropertyListMetadata != null) {
//            addProperties(thePropertyListMetadata.sName, thePropertyListMetadata.sType,
//                               thePropertyListMetadata.sClass, thePropertyListMetadata.sDefaultValue,
//                               thePropertyListMetadata.sDoc, thePropertyListMetadata.sSetName,
//                               thePropertyListMetadata.sGetName, thePropertyListMetadata.bVisible,
//                               thePropertyListMetadata.bGenerate);
//            thePropertyListMetadata = thePropertyListMetadata.theNextProperty;
//        }
        // Copy methods below it.
        Method[] methods = cls.getDeclaredMethods();
        boolean bInherits = true;
        if (sSuperClassName.equals("java.lang.Object"))  // Do not assume it forwards if no superclass but object.
            bInherits = false;
        // Make all methods for all the methods declared in this class.
        for (int iMethod = 0; iMethod < methods.length; iMethod++) {
            addMethod(methods[iMethod].getName(), makeMethodText(methods[iMethod], bInherits), "");
        }

    }

    public boolean DeleteClass() {
        // we can scan objects to see if any uses this class here.
        // automatically removed.
        return true;
    }


// Miscellaneous member access.

    public void setSuperClass(String sSuper, String sFullPath) {
        sSuperClassName = sSuper;
        sFullPathOfSuperClass = sFullPath;
    }

    public String getFullPathOfSuperClass() {
        return sFullPathOfSuperClass;
    }

    public void setFullPathOfSuperClass(String theFullPath) {
        sFullPathOfSuperClass = theFullPath;
    }

    public void setDisplayClass(String theDisplayClass) {
        sDisplayClass = theDisplayClass;
    }

    public void setDisplayClassIcon(String theClassIcon) {
        sDisplayClassIcon = theClassIcon;
    }

    public String getSuperClassName() {
        return sSuperClassName;
    }

    public void setSuperClassName(String theName) {
        sSuperClassName = theName;
    }

    public void setDesignBorders(boolean bDesignBorders) {
        this.bDesignBorders = bDesignBorders;
    }

    public boolean getDesignBorders() {
        return bDesignBorders;
    }

    public void setSkipDecl(boolean bSkipDecl) {
        this.bSkipDecl = bSkipDecl;
    }

    public boolean getSkipDecl() {
        return bSkipDecl;
    }

    public int getVisibility() {
        return iVisibility;
    }

    /**
     * getDisplayName - the name that should be displayed for a class in places such as the Component Palette.
     * this is usually the name of the class, but it can be different to allow for aliases (for example, the Customizer
     * will show the names of tables/columns, but still want them to be a different physical class.
     * @return the name to display. If it wasn't explicity set with setDisplayName, then the Class name will be returned.
     */
    public String getDisplayName() {
        String sDesignName = this.DisplayName;
        if (sDesignName == null) sDesignName = this.sClassName;

        return sDesignName;
    }

    /**
     * The name to display for the class in places such as the Component Palette. If this is not set, then the class name will be used.
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        DisplayName = displayName;
    }



// Data Elements

    public void addData(String sDataName, String sDataType, String sDataClass, String sDataInitValue, String sDoc) {
        MetaDataMember theData = new MetaDataMember(sDataName, sDataType, sDataClass, sDataInitValue, sDoc);
        if (theFirstData == null)
            theFirstData = theData;
        else
            theLastData.theNextData = theData;
        iNumberOfDataElements++;
        theLastData = theData;
    }

    public MetaDataMember getData(String sMemberName) {
        MetaDataMember theData = theFirstData;
        while (theData != null) {
            if (theData.getDataName().equals(sMemberName))
                return theData;
            theData = theData.getNextData();
        }
        return null;
    }

    public void setData(String sName, String sTypeName, String sClassName, String sDefaultValue, String sDoc) {
        MetaDataMember theData = getData(sName);
        if (theData == null)
            addData(sName, sTypeName, sClassName, sDefaultValue, sDoc);
        else {
            theData.sFieldName = sName;
            theData.sTypeName = sTypeName;
            theData.sClassName = sClassName;
            theData.sValue = sDefaultValue;
            theData.sDoc = sDoc;
        }
    }

    public boolean removeData(String sDataName) {
        MetaDataMember theData = theFirstData;
        MetaDataMember theLastProcessed = null;
        while (theData != null) {
            if (theData.sFieldName.equals(sDataName)) {
                if (theLastProcessed == null)
                    theFirstData = theData.theNextData;
                else
                    theLastProcessed.theNextData = theData.theNextData;
                if (theData == theLastData) {
                    theLastData = theLastProcessed;
                    if (theLastProcessed != null)
                        theLastProcessed.theNextData = null;
                }
                iNumberOfDataElements--;
                return true;
            }
            theLastProcessed = theData;
            theData = theData.theNextData;
        }
        return false;
    }

// Methods

    public MetaMethod getMethod(String sMethodName) {
        MetaMethod theMethod = theFirstMethod;
        while (theMethod != null) {
            if (theMethod.getMethodName().equals(sMethodName))
                return theMethod;
            theMethod = theMethod.getNextMethod();
        }
        return null;
    }

    public void setMethod(String sMethodName, String sMethodBody, String sDoc) {
        MetaMethod theMethod = getMethod(sMethodName);
        if (theMethod == null)
            addMethod(sMethodName, sMethodBody, sDoc);
        else {
            theMethod.sMethodDoc = sDoc;
            theMethod.sMethodName = sMethodName;
            theMethod.sMethodText = sMethodBody;
        }
    }

    public void addMethod(String sMethodName, String sMethodBody, String sDoc) {
        MetaMethod theMethod = new MetaMethod(sMethodName, sMethodBody, sDoc);
        if (theFirstMethod == null)
            theFirstMethod = theMethod;
        else
            theLastMethod.theNextMethod = theMethod;
        iNumberOfMethods++;
        theLastMethod = theMethod;
    }

    public boolean removeMethod(String sMethodName) {
        MetaMethod theMethod = theFirstMethod;
        MetaMethod theLastProcessed = null;
        while (theMethod != null) {
            if (theMethod.sMethodName.equals(sMethodName)) {
                if (theLastProcessed == null)
                    theFirstMethod = theMethod.theNextMethod;
                else
                    theLastProcessed.theNextMethod = theMethod.theNextMethod;
                if (theMethod == theLastMethod) {
                    theLastMethod = theLastProcessed;
                    if (theLastProcessed != null)
                        theLastProcessed.theNextMethod = null;
                }
                iNumberOfMethods--;
                return true;
            }
            theLastProcessed = theMethod;
            theMethod = theMethod.theNextMethod;
        }
        return false;
    }

// Properties

    public MetaPropertyDescriptor getProperty(String sPropertyName) {
        MetaPropertyDescriptor theProperty = theFirstProperty;
        while (theProperty != null) {
            String sNameFromMetadata = theProperty.getName();
            if (sNameFromMetadata.equals(sPropertyName))
                return theProperty;
            int iDotPos = sPropertyName.indexOf(".");
            if (iDotPos != -1) {
                String sFront = sPropertyName.substring(0, iDotPos);
                if (sNameFromMetadata.equals(sFront)) {
                    if (theProperty.theFirstSubproperty != null) {
                        return theProperty.getProperty(sPropertyName.substring(iDotPos + 1));
                    }
                    return null;
                }
            }
            theProperty = theProperty.getNextProperty();
        }
        return null;
    }

    public void setProperty(MetadataDispenser thetheMetadataDispenser,
                            String sName,
                            String sTypeName,
                            String sClassName,
                            String[] sValueChoices,
                            String sDoc,
                            String sDefaultValue,
                            String sSetMethodName,
                            String sGetMethodName,
                            String sPropertyParser,
                            String sIncludeTypeConstants,
                            int iOrder) {
        MetaPropertyDescriptor theProperty = getProperty(sName);
        if (theProperty == null)
            addProperties(thetheMetadataDispenser,
                    sName, sTypeName, sClassName, sValueChoices,
                    sDoc, sDefaultValue, sSetMethodName, sGetMethodName,
                    sPropertyParser,
                    sIncludeTypeConstants,
                    iOrder);
        else {
            theProperty.sName = sName;
            theProperty.sClass = sClassName;

            theProperty.theValueChoices = new ArrayList(sValueChoices.length);
            for (int i = 0; i < sValueChoices.length; i++)
                theProperty.theValueChoices.add(sValueChoices[i]);
            theProperty.sDoc = sDoc;
            theProperty.setDefaultValue(thetheMetadataDispenser, this, sDefaultValue);
            theProperty.sSetName = sSetMethodName;
            theProperty.sGetName = sGetMethodName;
        }
    }

    public void addProperties(MetaPropertyDescriptor theNewProperty) {
        if (theFirstProperty == null)
            theFirstProperty = theNewProperty;
        else
            theLastProperty.theNextProperty = theNewProperty;
        iNumberOfProperties++;
        theLastProperty = theNewProperty;
    }

    public void addProperties(MetadataDispenser thetheMetadataDispenser,
                              String sPropertyName, String sType, String sClass,
                              String[] sValueChoices, String sDoc,
                              String sDefaultValue,
                              String sSetMethodName,
                              String sGetMethodName,
                              String sPropertyHelper,
                              String sIncludeTypeConstants,
                              int iOrder) {
        MetaPropertyDescriptor theProperty = new MetaPropertyDescriptor(sPropertyName, sType,
                sClass, sValueChoices, sDoc,
                sDefaultValue,
                sSetMethodName,
                sGetMethodName,
                sPropertyHelper,
                sIncludeTypeConstants,
                iOrder,
                thetheMetadataDispenser,
                this);
        if (theFirstProperty == null)
            theFirstProperty = theProperty;
        else
            theLastProperty.theNextProperty = theProperty;
        iNumberOfProperties++;
        theLastProperty = theProperty;
    }

    public void addProperties(MetadataDispenser thetheMetadataDispenser,
                              String sPropertyName, String sType, String sClass,
                              String[] sValueChoices, String sDoc,
                              String sDefaultValue,
                              String sSetMethodName,
                              String sGetMethodName,
                              String sPropertyHelper,
                              String sIncludeTypeConstants,
                              int iOrder,
                              boolean bVisible, boolean bAutoGenerate,
                              boolean bArray,
                              boolean bLanguages,
                              boolean bReadOnly) {
        MetaPropertyDescriptor theProperty = new MetaPropertyDescriptor(sPropertyName, sType,
                sClass, sValueChoices, sDoc,
                sDefaultValue,
                sSetMethodName,
                sGetMethodName,
                sPropertyHelper,
                sIncludeTypeConstants,
                iOrder,
                thetheMetadataDispenser,
                this);
        theProperty.bGenerate = bAutoGenerate;
        theProperty.bVisible = bVisible;
        theProperty.bAllowMultipleValues = bArray;
        theProperty.bAllowMultipleLanguages = bLanguages;
        theProperty.setReadOnly(bReadOnly);
        if (theFirstProperty == null)
            theFirstProperty = theProperty;
        else
            theLastProperty.theNextProperty = theProperty;
        iNumberOfProperties++;
        theLastProperty = theProperty;
    }

    public boolean removeProperty(String sPropertyName) {
        MetaPropertyDescriptor theProperty = theFirstProperty;
        MetaPropertyDescriptor theLastProcessed = null;
        while (theProperty != null) {
            if (theProperty.sName.equals(sPropertyName)) {
                if (theLastProcessed == null)
                    theFirstProperty = theProperty.theNextProperty;
                else
                    theLastProcessed.theNextProperty = theProperty.theNextProperty;
                if (theProperty == theLastProperty) {
                    theLastProperty = theLastProcessed;
                    if (theLastProcessed.theNextProperty != null)
                        theLastProcessed.theNextProperty = null;
                }
                iNumberOfProperties--;
                return true;
            }
            theLastProcessed = theProperty;
            theProperty = theProperty.theNextProperty;
        }
        return false;
    }

//  Listeners.

    public MetaClassDetail getListener(String sListenerName) {
        MetaClassDetail theListener = theFirstListener;
        while (theListener != null) {
            if (theListener.sClassName.equals(sListenerName))
                return theListener;
            theListener = theListener.theNextClass;
        }
        return null;
    }

    // Design project keeps track of all listeners.

    public void addDefaultListeners(MetadataDispenser theProject) {
        if (theProject.getMetadataUser().getMode() == MetaObject.DESIGN_MODE) {
            int iDefaultListeners = theProject.getDefaultListenerCount();
            for (int iListener = 0; iListener < iDefaultListeners; iListener++) {
                MetaClassDetail theListener = theProject.getNewDefaultListener(iListener);
                if (theFirstListener == null)
                    theFirstListener = theListener;
                else
                    theLastListener.theNextClass = theListener;
                theLastListener = theListener;
            }
        }
    }

    public void addListener(String sListenerName, MetadataDispenser theProject) {
        if (theProject.getMetadataUser().getMode() == MetaObject.DESIGN_MODE) {
            MetaClassDetail theListener = theProject.getNewListener(sListenerName);
            if (theFirstListener == null)
                theFirstListener = theListener;
            else
                theLastListener.theNextClass = theListener;
            theLastListener = theListener;
        }
    }

    public boolean removeListener(String sListenerName) {
        MetaClassDetail theListener = theFirstListener;
        MetaClassDetail theLastProcessed = null;
        while (theListener != null) {
            if (theListener.sClassName.equals(sListenerName)) {
                if (theLastProcessed == null)
                    theFirstListener = theListener.theNextClass;
                else
                    theLastProcessed.theNextClass = theListener.theNextClass;
                if (theListener == theLastListener) {
                    theLastListener = theLastProcessed;
                    if (theLastProcessed != null)
                        theLastProcessed.theNextClass = null;
                }
                return true;
            }
            theLastProcessed = theListener;
            theListener = theListener.theNextClass;
        }
        return false;
    }

    public void setPropertyDefaultValue(String sName, String sDefaultValue, String sTranslatedDefaultValue) {
        defaultPropertyValues.put(sName, sDefaultValue);
        defaultTranslatedPropertyValues.put(sName, sTranslatedDefaultValue);
    }

    public String getPropertyDefaultValue(String sName) {
        return (String) defaultPropertyValues.get(sName);
    }

    public String getPropertyTranslatedDefaultValue(String sName) {
        return (String) defaultTranslatedPropertyValues.get(sName);
    }

}

