/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *
 *      <Object>
 <Name>text value that denotes name of object - object names are
 unique at the same level</Name>
 {Type declaration}   <--- One type declaration.
 {Property Declarations}  *  <--- Zero or more property
 declarations (see note for special property Size & Location)
 </Object>

 *
 */

public class MetaObject {
    public MetaObject theNextObject = null;           // for the obj tree
    public MetaObject thePreviousObject = null;       // for the obj tree
    public MetaObject theNextInstance = null;         // for the class links
    public MetaObject thePreviousInstance = null;     // for the class links
    public MetaObject theFirstChild = null;           // for the obj tree
    public MetaObject theLastChild = null;            // for the obj tree
    public MetaObject theParentObject = null;         // for the obj tree
    public MetaClass theClass = null;
    public int iDisplayLayer = JLayeredPane.DEFAULT_LAYER.intValue();
    public boolean bIsDeleted = false;
    private String theName = "";
    public MetaType theType = null;
    public MetaProperty theFirstProperty = null;
    public MetaProperty theLastProperty = null;
    public boolean bAnchoringOff = false;
    public boolean bLeftAnchoring = false, bRightAnchoring = false, bTopAnchoring = false, bBottomAnchoring = false;
    public JComponent theVisualObject = null;
    public JFrame theVisualFrame = null;
    public Object theFabricatedObject = null;
    public boolean bMember = false;
    public boolean bPopup = false;
    public String sCode = "";
    protected Color theForegroundColor = null;
    protected Font theFont = null;
    protected Color theBackgroundColor = null;
    public int iXLocation = 0;
    public int iYLocation = 0;
    public Point ptDrag = null;
    public String psText = "";
    public MetaProject theDesignProject = null;
    public Object theLayoutManager = null;
    MetaConstructor theConstructor = null;

    static public final int RESIZE_CONTEXT_UNKNOWN = 0;
    static public final int RESIZE_CONTEXT_SIZEBOX_RESIZING = 1;
    static public final int RESIZE_CONTEXT_SIZEBOX_RESIZED = 2;
    static public final int RESIZE_CONTEXT_IMPORT_OBJECT = 3;
    static public final int RESIZE_CONTEXT_FROM_LAYOUT = 4;
    static public final int RESIZE_CONTEXT_FROM_PASTE = 5;
    static public final String UDF_OBJECT_CODE = "Object Code";

    // Allow methods to be defined for objects - autogen class
    public MetaMethodLinkage theFirstMethod = null;
    public MetaMethodLinkage theLastMethod = null;
    int iMethodCount = 0;
    public boolean bAutoEmbed = false;
    public JAScrollPane theScrollPane;  // change JScrollPane to JAScrollPane (lauchenauer)
    public Dimension dimViewportSize = null;

    public int iMode = 0;
    public static final int NO_MODE = 0;
    public static final int DESIGN_MODE = 1;
    public static final int EXECUTION_MODE = 2;

    protected ObjectTreeViewNode theTreeNode = null;  // only used in the Designer.
    public Object theMouseListener = null;
    public Object theMouseMotionListener = null;
    public Dimension dimSize = new Dimension(0, 0);
    public boolean bDragged = false;
    public boolean bResizing = false;


    private String theConstructorParameters;
    private String thePreConstructionCode;
    private String thePostConstructionCode;
    public ButtonGroup theButtonGroup;
    private MetaClass theInstanceTracker;

    private Object theAdditionalData;
    // MHC Added for user defined Object source - Open Source
    private String theObjectSource      = null;
    private String theObjectSourceDoc   = null;
    private String sPatchedClassName     = null;
    private boolean bObjectPatched      = false;
    private boolean propsLoaded         = false;

    // This is for cloning.  Use the clone method instead.
    public MetaObject(MetaObject theTemplateObject, MetaObject theParentObject, MetaProject theProject, int iMode) {
        this.iMode = iMode;
        this.theParentObject = theParentObject;
        this.theType = new MetaType(theTemplateObject.theClass.theMetadata.sClassName,
                theTemplateObject.theClass.theMetadata.sFullClassName,
                theTemplateObject.theClass.theMetadata.theFactoryName,
                theProject);
        this.theDesignProject = theProject;

        if (theDesignProject != null) {  // Project is loaded?
            theClass = theDesignProject.findClass(theTemplateObject.theClass.theMetadata.sClassName);
            if (theClass != null)
                addAllMethods();
            // Add to instance tracker.
            theInstanceTracker = theDesignProject.findInstanceTracker(theTemplateObject.theClass.theMetadata.sClassName);
            theInstanceTracker.addObject(this);
            // Add all properties from template object.
            MetaProperty theProperty = theTemplateObject.theFirstProperty;
            while (theProperty != null) {
                MetaProperty theNewProperty = theProperty.Clone(this);
                this.addProperty(theNewProperty);
                theProperty = theProperty.theNextProperty;
            }
        }

        this.theDesignProject = theProject;
    }

    public String getName() {
        MetaPropertyValueEx pvName = getPropertyValue("Name", 0);
        if (pvName == null)
            return theName;
        else
            return getPropertyValue("Name", 0).getStringValue();
    }

    public void setName(String sName) {
        this.theName = sName;
        setPropertyValue("Name", 0, 0, sName, true);
    }

    // Temporary objects are in the clipboard.
    public MetaObject(String sObjectName, String sClassName, String sFullClassName,
                      MetaObject theParentObject, MetaProject objDesignProject,
                      int iMode, boolean bCreateMethods) {

        this.iMode = iMode;
        this.theDesignProject = objDesignProject;
        this.theParentObject = theParentObject;

        if (theDesignProject != null) {  // Project is loaded?
            theClass = theDesignProject.findClass(sClassName);
            boolean metadataLoaded = theDesignProject.getMetadataDispenser().theMetadataDocument.isCustomMetadataComplete();
            if (theClass != null && metadataLoaded==true) {
                setName(sObjectName);
                String theFactoryName = null;
                if (theClass.theMetadata != null)
                    theFactoryName = theClass.theMetadata.theFactoryName;
                this.theType = new MetaType(sClassName, sFullClassName, theFactoryName, theDesignProject);
                if (bCreateMethods)
                    addAllMethods();
                // Add to instance tracker.
                theInstanceTracker = theDesignProject.findInstanceTracker(sClassName);
                theInstanceTracker.addObject(this);
            }
        }

    }


    public MetaObject() {
    }

    public int getChildIndex(MetaObject someChild) {
        int i = 0;
        MetaObject testChild = this.theFirstChild;
        while (testChild != null) {
            if (someChild.equals(testChild))
                return i;
            i++;
            testChild = testChild.theNextObject;
        }
        return -1;
    }

    public void addProperty(MetaProperty theProperty) {
        if (theFirstProperty == null)
            theFirstProperty = theProperty;
        else {
            theProperty.thePreviousProperty = theLastProperty;
            theLastProperty.theNextProperty = theProperty;
        }
        theLastProperty = theProperty;
    }

    public void addObject(MetaObject theMetaObject) {
        if (theFirstChild == null)
            theFirstChild = theMetaObject;
        else {
            theMetaObject.thePreviousObject = theLastChild;
            theLastChild.theNextObject = theMetaObject;
        }
        theMetaObject.theParentObject = this;
        theLastChild = theMetaObject;
    }

    public boolean save(electric.xml.Element theParent) {
        // create the property elements
        electric.xml.Element xmlObject = new electric.xml.Element("Object");
        electric.xml.Element xmlName = new electric.xml.Element("Name");
        xmlName.setText(theName);
        xmlObject.addElement(xmlName);
        theParent.addElement(xmlObject);
        theType.save(xmlObject);
        // add all properties.
        MetaProperty theProperty = theFirstProperty;
        while (theProperty != null) {
            theProperty.save(theDesignProject, xmlObject);
            theProperty = theProperty.theNextProperty;
        }
        // add methods.
        generateObjectEventClasses(xmlObject);

        //add object user defined code   MHC Open Source.
        generateObjectSourceCode(xmlObject);

        // add all objects.
        MetaObject theObject = theFirstChild;

        ArrayList DataSourcetheObjects = new ArrayList();

        while (theObject != null) {
            theObject.save(xmlObject);
            theObject = theObject.theNextObject;
        }


        return true;
    }

    public boolean load(electric.xml.Element theElement) {
        electric.xml.Element xmlName = theElement.getElement("Name");
        theName = xmlName.getTextString();
        electric.xml.Element xmlType = theElement.getElement("Type");
        theType = new MetaType(theDesignProject);
        theType.load(xmlType);

        theClass = theDesignProject.findClass(theType.theName);
        if (theClass == null)
            return false;
        theInstanceTracker = theDesignProject.findInstanceTracker(theType.theName);
        theInstanceTracker.addObject(this);
        electric.xml.Elements theProperties = theElement.getElements("Property");
        electric.xml.Element theProperty = theProperties.next();
        while (theProperty != null) {
            MetaProperty theMetaProperty = new MetaProperty(this);
            theMetaProperty.load(theProperty, theDesignProject, theClass);
            addProperty(theMetaProperty);
            theProperty = theProperties.next();
        }
        addAllMethods();
        electric.xml.Element theMethods = theElement.getElement("Methods");
        if (theMethods != null) {
            electric.xml.Elements theListeners = theMethods.getElements();
            for (int i = 0; i < theListeners.size(); i++) {
                electric.xml.Element theListener = theListeners.next();
                String sListenerName = theListener.getName();
                electric.xml.Elements theMethodList = theListener.getElements("Method");
                for (int j = 0; j < theMethodList.size(); j++) {
                    electric.xml.Element theMethod = theMethodList.next();
                    electric.xml.Element theName = theMethod.getElement("Name");
                    electric.xml.Element theCode = theMethod.getElement("Code");
                    electric.xml.Children theChildren = theCode.getChildren();
                    electric.xml.CData theCdata = (electric.xml.CData) theChildren.first();
                    String sMethodName = theName.getTextString();
                    String sCode = theCdata.getData();
                    MetaMethodLinkage theMethodLink = getMethod(sMethodName);
                    theMethodLink.theMethod.setCode(sCode);
                }
            }
        }
        electric.xml.Elements theObjects = theElement.getElements("Object");
        electric.xml.Element theObject = theObjects.next();
        while (theObject != null) {
            MetaObject theMetaObject = new MetaObject();
            theMetaObject.theDesignProject = theDesignProject;
            theMetaObject.load(theObject);
            addObject(theMetaObject);
            theObject = theObjects.next();
        }

        electric.xml.Element theUserDefinedCode = theElement.getElement("UserDefinedSourceCode");
        if(theUserDefinedCode!=null)
        {
            electric.xml.Children theChildren = theUserDefinedCode.getChildren();
            electric.xml.CData theCdata = (electric.xml.CData) theChildren.first();
            String sCode = theCdata.getData();
            this.setObjectCode(sCode);
        }
        return true;
    }

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; i++) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theDiscriminators.get(i);
            if (theDiscriminator.theClass.equals(theClass))
                return theDiscriminator;
        }
        return null;
    }

    public void generateObjectSourceCode(electric.xml.Element xmlObject) {
        String sObjectCode = this.getObjectCode();
        if (sObjectCode!=null)
        {
            electric.xml.Element xmlUserDefinedCode = new electric.xml.Element("UserDefinedSourceCode");
            xmlUserDefinedCode.setText(new electric.xml.CData(new electric.xml.CData(this.getObjectCode())));
            xmlObject.addElement(xmlUserDefinedCode);
        }
    }

    public void generateObjectEventClasses(electric.xml.Element xmlObject) {
        // Make a class for each listener for the object.
        // The class name is identifier of object plus name of listener concatenated
        // Implements is the name of the listener
        // One method for each event
        // Class is written to buffer that will be added before epilog code.
        MetaMethodLinkage theMethod = theFirstMethod;
        ArrayList theListeners = new ArrayList(0);
        ArrayList theDiscriminators = new ArrayList(0);
        ArrayList theSpecialDiscriminators = new ArrayList(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (theListeners.contains(theClass) == false) {
                theListeners.add(theMethod.theListener);
                ListenerDiscriminator theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                ListenerDiscriminator theDiscriminator = findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        // remove listeners that have no special implementation.
        for (int i = 0; i < theDiscriminators.size(); i++) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theDiscriminators.get(i);
            if (theDiscriminator.isSpecial() == true)
                theSpecialDiscriminators.add(theDiscriminator);
        }
        electric.xml.Element xmlMethods = new electric.xml.Element("Methods");
        boolean bAppendedToObject = false;
        // generate classes for the others.
        for (int i = 0; i < theSpecialDiscriminators.size(); i++) {
            boolean bListenerAppended = false;
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theSpecialDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator.theClass;
            String sListenerName = theListener.sClassName;
            electric.xml.Element xmlListener = new electric.xml.Element(sListenerName);
            // Now write the methods.
            for (int j = 0; j < theDiscriminator.theMethods.size(); j++) {
                MetaMethodLinkage theListenerLink = (MetaMethodLinkage) theDiscriminator.theMethods.get(j);
                MetaMethod theListenerMethod = theListenerLink.theMethod;
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() != 0) {
                    if (!bListenerAppended) {
                        xmlMethods.addElement(xmlListener);
                        bListenerAppended = true;
                        if (!bAppendedToObject) {
                            xmlObject.addElement(xmlMethods);
                            bAppendedToObject = true;
                        }
                    }
                    electric.xml.Element xmlMethod = new electric.xml.Element("Method");
                    electric.xml.Element xmlName = new electric.xml.Element("Name");
                    electric.xml.Element xmlCode = new electric.xml.Element("Code");
                    xmlListener.addElement(xmlMethod);
                    xmlMethod.addElement(xmlName);
                    xmlMethod.addElement(xmlCode);
                    xmlName.setText(theListenerMethod.sMethodName);
                    xmlCode.addChild(new electric.xml.CData(theListenerMethod.sMethodText));
                }
            }
        }

    }


    /**
     * searchProperty - this looks through an indexed property tree of parameters
     * searching for a match of a specific component.  For example you can find
     * the parameter "a.b.c"  in the property chain "a".  A concrete example,
     * given the property "Size", you can find both "Size.Width" and "Size.Height".
     *
     * @param sLongPropertyName - a name like "Size.Width"
     * @param iIndex - the array element.  Properties have array support at the
     * top level only.  You can't have "a.b.c[]" for now. No way to specify it
     * though you could build it into the data easily.
     *
     * @return matching metaparameter.
     */
    public MetaParameter searchProperty(String sLongPropertyName, int iIndex) {
        // Takes string that denotes property - like Size.Length or Location.Top and finds the components.
        MetaParameter theParameter = null;
        int iDotPos = sLongPropertyName.indexOf(".");
        String sRedundantKey = null;
        if (iDotPos == -1) { // no subbing this property
            String sKey = sLongPropertyName;
            MetaProperty theProperty = theFirstProperty;
            while (theProperty != null) {
                if (sKey.equals(theProperty.theName)) {
                    if (iIndex >= theProperty.getValueCount())
                        return null;
                    else
                        return (MetaParameter) theProperty.theIndexedValue.get(iIndex);
                }
                theProperty = theProperty.theNextProperty;
            }
            return null;
        }
        String sKey = null;
        if (iDotPos != -1)
            sKey = sLongPropertyName.substring(0, iDotPos);
        else
            sKey = sLongPropertyName;
        MetaProperty theProperty = theFirstProperty;
        while (theProperty != null) {
            if (sKey.equals(theProperty.theName))
                break;
            theProperty = theProperty.theNextProperty;
        }
        sRedundantKey = sKey;
        if (theProperty != null) {
            theParameter = (MetaParameter) theProperty.theIndexedValue.get(iIndex);
            while (iDotPos != -1) {
                sLongPropertyName = sLongPropertyName.substring(iDotPos + 1);
                iDotPos = sLongPropertyName.indexOf(".");
                if (iDotPos != -1)
                    sKey = sLongPropertyName.substring(0, iDotPos);
                else
                    sKey = sLongPropertyName;
                if (sKey.equals(sRedundantKey) == false) {  // built in to allow redundancy.
                    if (theParameter != null)
                        theParameter = theParameter.searchParameterTree(sLongPropertyName);
                    else
                        return null; // no sub parameter matches this sub property.
                }
            }
            return theParameter;
        }
        return null;
    }

    public MetaPropertyValueEx getPropertyValue(String sLongPropertyName, int iIndex) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        if (theMatch != null)
            return theMatch.theValue;
        else
            return null;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, MetaPropertyValueEx pvValue) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        if (theMatch != null) {
            theMatch.theValue = pvValue;
            if (sLongPropertyName.equals("Mnemonic"))
                pvValue.setMnemonic();
            return true;
        } else
            return false;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, Object objValue, boolean bGlobal) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = "java.lang.String";
        boolean bResolveAsObject = false;
        if (objValue != null)
            sSimpleType = objValue.getClass().getName();
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1)
                sPiece = sPiece.substring(0, iDotPos);
            MetaPropertyDescriptor theMetadata = theClass.getProperty(sPiece, true);
            if (theMetadata != null) {
                sSimpleType = theMetadata.sClass;
                bResolveAsObject = theMetadata.bObjectReference;
            }
            theMatch = makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata); //MHC the ObjRef is never passed
        }
        if (theMatch == null)
            return false;
        theMatch.theOrder = iOrder;
        if (objValue == null)
            setPropertyValueImpl(theMatch, sSimpleType, null, bGlobal);
        else
            setPropertyValueImpl(theMatch, sSimpleType, objValue.toString(), bGlobal);

        // theMatch.bObjectReference = bResolveAsObject;  //  Moved where match is created! MHC
        if (sLongPropertyName.equals("Mnemonic"))
            theMatch.setMnemonic();
        return true;
    }

    public void setPropertyValueImpl(MetaParameter theMatch, String sSimpleType, String strValue, boolean bGlobal) {
        if ((theMatch.bAllowMultipleLanguages) && (bGlobal)) {
            int iCurrentLanguage = theDesignProject.getCurrentLanguage().theLanguage;
            for (int iLang = HammerLanguagePresentation.DEFAULT; iLang <= HammerLanguagePresentation.LAST_LANGUAGE; iLang++) {
                theDesignProject.setCurrentLanguage(iLang);
                theMatch.set(sSimpleType, strValue, theDesignProject);
            }
            theDesignProject.setCurrentLanguage(iCurrentLanguage);
        } else {
            theMatch.set(sSimpleType, strValue, theDesignProject);
        }
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, int iValue, boolean bGlobal) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(MetaPropertyValueEx.TYPE_INT);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1)
                sPiece = sPiece.substring(0, iDotPos);
            MetaPropertyDescriptor theMetadata = theClass.getProperty(sPiece, true);
            theMatch = makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null)
            return false;
        theMatch.theOrder = iOrder;
        setPropertyValueImpl(theMatch, sSimpleType, new Integer(iValue).toString(), bGlobal);

        if (sLongPropertyName.equals("Mnemonic"))
            theMatch.setMnemonic();
        return true;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, char cValue, boolean bGlobal) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(MetaPropertyValueEx.TYPE_CHAR);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1)
                sPiece = sPiece.substring(0, iDotPos);
            MetaPropertyDescriptor theMetadata = theClass.getProperty(sPiece, true);
            theMatch = makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null)
            return false;
        theMatch.theOrder = iOrder;
        setPropertyValueImpl(theMatch, sSimpleType, new Character(cValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic"))
            theMatch.setMnemonic();
        return true;
    }


    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, float fValue, boolean bGlobal) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(MetaPropertyValueEx.TYPE_FLOAT);
        if (theMatch == null) {
            MetaPropertyDescriptor theMetadata = theClass.getProperty(sLongPropertyName, true);
            theMatch = makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null)
            return false;
        theMatch.theOrder = iOrder;
        setPropertyValueImpl(theMatch, sSimpleType, new Float(fValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic"))
            theMatch.setMnemonic();
        return true;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, double dValue, boolean bGlobal) {
        MetaParameter theMatch = searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(MetaPropertyValueEx.TYPE_DOUBLE);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1)
                sPiece = sPiece.substring(0, iDotPos);
            MetaPropertyDescriptor theMetadata = theClass.getProperty(sPiece, true);
            theMatch = makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType,
                    theMetadata);
        }
        if (theMatch == null)
            return false;
        theMatch.theOrder = iOrder;
        setPropertyValueImpl(theMatch, sSimpleType, new Double(dValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic"))
            theMatch.setMnemonic();
        return true;
    }

    // Make Property.
    //
    // Searches for lowest match
    // If lowest match is already a simple type return an error.
    // Otherwise create complex types until bottom level  (parameter, complex type)
    // At bottom create a simple type.
    //

    public MetaParameter makeProperty(String sLongPropertyName, int iIndex, int iOrder,
                                      String sSimpleType, MetaPropertyDescriptor thePropertyInfo) {
        boolean bAllowMultipleLanguages = false;
        boolean bObjectReference = false;
        boolean bArrayBased = false;
        if (thePropertyInfo != null) {
            bAllowMultipleLanguages = thePropertyInfo.bAllowMultipleLanguages;
            bObjectReference = thePropertyInfo.bObjectReference;
            bArrayBased = thePropertyInfo.bAllowMultipleValues;
        }
        int iDotPos = sLongPropertyName.lastIndexOf(".");
        String sSpecialization = sLongPropertyName;
        MetaParameter theMatch = null;
        MetaParameter anyMatch = searchProperty(sLongPropertyName, 0);
        while (iDotPos != -1) {
            sLongPropertyName = sLongPropertyName.substring(0, iDotPos);
            theMatch = searchProperty(sLongPropertyName, iIndex);
            if (theMatch != null)
                break;
            iDotPos = sLongPropertyName.lastIndexOf(".");
        }
        // Could have to add a parameter here.
        if ((anyMatch != null) && (theMatch == null)) {
            String sShortName = sLongPropertyName;
            int iDotPos2 = sLongPropertyName.indexOf(".");
            if (iDotPos2 != -1)
                sShortName = sShortName.substring(0, iDotPos2);
            MetaProperty theProp = getPropertyMetadata(sShortName);
            theProp.theIndexedValue.add(iIndex,
                    new MetaParameter(iOrder, sSimpleType, sLongPropertyName, theDesignProject,
                            bAllowMultipleLanguages, bObjectReference));
            return (MetaParameter) theProp.theIndexedValue.get(iIndex);
        }
        // First make sure that the bottom level found isn't a simple type.
        // If it is we have an error.
        if (theMatch != null) {
            if (theMatch.theComplexType == null)
                return null;  // an error!
            // sSpecialization is what's left over.
            sSpecialization = sSpecialization.substring(iDotPos + 1);
            // Make the nodes and subnodes.
            iDotPos = sSpecialization.indexOf(".");
            String sPiece = "";
            while (iDotPos != -1) {
                sPiece = sSpecialization.substring(0, iDotPos);
                sSpecialization = sSpecialization.substring(iDotPos + 1);
                MetaType theNewMetatype = new MetaType(theDesignProject);
                MetaParameter theNewParameter =
                        new MetaParameter(iOrder, theNewMetatype, sPiece, theDesignProject,
                                bAllowMultipleLanguages, bObjectReference);
                theMatch.theComplexType.addParameter(theNewParameter);
                theMatch = theNewParameter;
                iDotPos = sSpecialization.indexOf(".");
            }
            // Bottom level is simple type.
            MetaParameter theNewParameter = new MetaParameter();
            theNewParameter.theOrder = iOrder;
            theNewParameter.theComplexType = null;
            theNewParameter.theSimpleType = sSimpleType;
            theNewParameter.theName = sSpecialization;  // leftover.
            theNewParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
            theMatch.theComplexType.addParameter(theNewParameter);
            return theNewParameter;
        } else {  // We found nothing.  We may need to create property too.
            // sSpecialization is what's left over.
            sSpecialization = sSpecialization.substring(iDotPos + 1);
            // Make the nodes and subnodes.
            iDotPos = sSpecialization.indexOf(".");
            String sPiece = sSpecialization;
            if (iDotPos != -1)
                sPiece = sPiece.substring(0, iDotPos);
            // Create property.
            MetaPropertyDescriptor theBasePropertyInfo = this.theClass.getProperty(sPiece, true);
            MetaProperty theNewProperty = new MetaProperty(theBasePropertyInfo, this);
            theNewProperty.bAllowMultipleValues = bArrayBased;
            theNewProperty.theName = sPiece;
            sPiece = "";  // no name for property simple type in parameter.
            while (iDotPos != -1) {
                // Now do parameters.
                sSpecialization = sSpecialization.substring(iDotPos + 1);
                iDotPos = sSpecialization.indexOf(".");
                if (iDotPos != -1)
                    sPiece = sSpecialization.substring(0, iDotPos);
                else
                    sPiece = sSpecialization;
                MetaType theNewMetatype = new MetaType(theDesignProject);
                if ((thePropertyInfo.sClass != null)
                        && (thePropertyInfo.sClass.length() > 0)) {
                    int iType = MetaPropertyValueEx.translateType(thePropertyInfo.sClass);
                    if (iType == MetaPropertyValueEx.TYPE_UNDEFINED)
                        theNewMetatype.theFullName = thePropertyInfo.sClass;
                }
                MetaParameter theNewParameter =
                        new MetaParameter(iOrder, theNewMetatype, sPiece, theDesignProject,
                                bAllowMultipleLanguages, bObjectReference);
                if (theMatch != null) {
                    theMatch.theComplexType.addParameter(theNewParameter);
                } else {
                    MetaType thePlaceHolderType = new MetaType(theDesignProject);
                    thePlaceHolderType.theName = theBasePropertyInfo.sClass;
                    thePlaceHolderType.theFullName = theBasePropertyInfo.sClass;
                    MetaParameter thePlaceHolderParameter = new MetaParameter();
                    thePlaceHolderParameter.theName = theNewProperty.theName;
                    thePlaceHolderParameter.theComplexType = thePlaceHolderType;
                    thePlaceHolderParameter.theComplexType.addParameter(theNewParameter);
                    thePlaceHolderParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
                    thePlaceHolderParameter.theDesignProject = theDesignProject;
                    theNewProperty.theIndexedValue.add(iIndex, thePlaceHolderParameter);
                }
                theMatch = theNewParameter;
            }
            // Bottom level is simple type.
            if (theMatch == null) {  // No subs - type is direct child of property
                MetaParameter theNewParameter = new MetaParameter();
                theNewParameter.theSimpleType = sSimpleType;
                theNewParameter.theComplexType = null;
                theNewParameter.theName = "";
                theNewParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
                theNewParameter.theDesignProject = theDesignProject;
                theNewProperty.theIndexedValue.add(0, theNewParameter);
                theMatch = theNewParameter;
            } else {
                theMatch.theComplexType = null;
                theMatch.theSimpleType = sSimpleType;
                theMatch.theName = sPiece;
            }
            addProperty(theNewProperty);
            theMatch.bObjectReference = bObjectReference;     // MHC is not set at the proper location
            return theMatch;
        }
    }

    public MetaProperty getPropertyMetadata(String sPropertyName) {
        MetaProperty theProp = theFirstProperty;
        while (theProp != null) {
            if (theProp.theName.trim().equals(sPropertyName)) {
                return theProp;
            }
            theProp = theProp.theNextProperty;
        }
        return null;
    }

    public int getContainerType() {
        MetaPropertyValueEx theProperty = getPropertyValue("ContainerType", 0);
        if (theProperty != null) {
            String sContainerType = theProperty.getStringValue();
            MetaContainerType theContainerType = new MetaContainerType(sContainerType);
            return theContainerType.getContainerType();
        } else
            return MetaContainerType.CONTAINER_NONE;
    }


    public void removeListeners(Component comp) {
        FocusListener[] theFocusListeners = comp.getFocusListeners();
        MouseListener[] theListeners = comp.getMouseListeners();
        MouseMotionListener[] theMotionListeners = comp.getMouseMotionListeners();
        for (int iListener = 0; iListener < theListeners.length; iListener++) {
            comp.removeMouseListener(theListeners[iListener]);
        }
        for (int iMotionListener = 0; iMotionListener < theMotionListeners.length; iMotionListener++) {
            comp.removeMouseMotionListener(theMotionListeners[iMotionListener]);
        }
        for (int iFocusListener = 0; iFocusListener < theFocusListeners.length; iFocusListener++) {
            comp.removeFocusListener(theFocusListeners[iFocusListener]);
        }
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent) comp;
            Component[] childVisualObjects = jcomp.getComponents();
            for (int i = 0; i < childVisualObjects.length; i++)
            {
                removeListeners(childVisualObjects[i]);

                if ( isCompositeComponent() && !childVisualObjects[i].equals(theVisualObject) )
                {
                    // 2005/05/27, acg: Force composite component to respond as a single component.
                    // Mainly for selecting and dragging via the mouse. Clicking anywhere in a composite component
                    // should select the entire component, and allow you to drag it.
                    childVisualObjects[i].setEnabled(false);
                    if (theMouseListener != null)
                        childVisualObjects[i].addMouseListener((MouseListener)theMouseListener);
                    if (theMouseMotionListener != null)
                        childVisualObjects[i].addMouseMotionListener((MouseMotionListener)theMouseMotionListener);
                }
            }
        }
    }

    public void refreshListeners(){
        if ( theVisualObject == null ) return;
        removeListeners (theVisualObject);
        if (theMouseListener != null)
            theVisualObject.addMouseListener((MouseListener)theMouseListener);
        if (theMouseMotionListener != null)
            theVisualObject.addMouseMotionListener((MouseMotionListener)theMouseMotionListener);
    }

    public void removeListeners() {
        removeListeners(theVisualObject);
    }

    public boolean getAnchorLeft() {
        return bLeftAnchoring;
    }

    public boolean getAnchorRight() {
        return bRightAnchoring;
    }

    public boolean getAnchorTop() {
        return bTopAnchoring;
    }

    public boolean getAnchorBottom() {
        return bBottomAnchoring;
    }

    public void setForegroundColor(Color objColor) {
        theForegroundColor = objColor;
        if (theVisualObject != null) {
            theVisualObject.setForeground(objColor);
        }
        if (theVisualFrame != null)
            theVisualFrame.getContentPane().setForeground(objColor);
        setPropertyValue("Foreground", 0, 0, objColor.toString(), true);
    }

    public void setBackgroundColor(Color objColor) {
        theBackgroundColor = objColor;
        if (theVisualObject != null) {
            theVisualObject.setBackground(objColor);
        }
        if (theVisualFrame != null)
            theVisualFrame.getContentPane().setBackground(objColor);
        setPropertyValue("Background", 0, 0, objColor.toString(), true);
    }

    public void setColor(Color objColor, boolean bForeground) {
        if (bForeground)
            setForegroundColor(objColor);
        else
            setBackgroundColor(objColor);
    }

    public void setFont(Font objFont) {
        if ((theVisualObject != null) && (objFont != null))
            theVisualObject.setFont(objFont);
        theFont = objFont;
        if (theFont == null)
            setPropertyValue("Font", 0, 0, null);
        else
            setPropertyValue("Font", 0, 0, theFont.toString(), true);
    }

    public int getDisplayLayer() {
        return iDisplayLayer;
    }

    public void bringForward() {
        // trace levels back to frame (frame is default layer)
        MetaObject theObjectBelow = theParentObject;
        if (theObjectBelow == null)
            return;
        ArrayList theLayers = new ArrayList(1);
        theLayers.add(this);
        MetaObject theLastObject = this;
        // reset all the children of all the parents except this branches.
        while (theObjectBelow != null) { // ((theObjectBelow.isAbalet()==false) && (theObjectBelow.isFrame()==false)) {
            theLayers.add(theObjectBelow);
            theObjectBelow.resetDisplayLayer(theLastObject);
            theLastObject = theObjectBelow;
            theObjectBelow = theObjectBelow.theParentObject;
        }
        int iLayers = theLayers.size();
        // starting at bottom - set layer of each object.
        // each object in select path gets incremented one.
        if (iLayers > 0) {
            int theLayer = JLayeredPane.DEFAULT_LAYER.intValue() + 1;
            // The frame is left at default_layer
            for (int iLayer = iLayers - 1; iLayer >= 0; iLayer--) {
                theObjectBelow = (MetaObject) theLayers.get(iLayer);
                theObjectBelow.setDisplayLayer(theLayer);
                theLayer++;
            }
        }
    }

    public void setDisplayLayer(int iLayer) {
        int theTestLayer = getDisplayLayer();
//      this.theDesignProject.theDesignCockpit.theLogFile.doLogEntry("SetDisplayLayer: ",
//          "Setting layer of object " + this.theName + " to layer: " + iLayer);
        if (theTestLayer != iLayer) {
            iDisplayLayer = iLayer;
            if (theParentObject == null)
                return;
            // set children of this layer to higher layer.
            if (theParentObject.theVisualObject instanceof JLayeredPane) {
                theDesignProject.getMetaDataUser().updateDisplayLayer(this, iLayer);
            }
        }
    }

    public void resetDisplayLayer(MetaObject childToSkip) {
        if (iDisplayLayer == JLayeredPane.DEFAULT_LAYER.intValue())
            return;
        iDisplayLayer = JLayeredPane.DEFAULT_LAYER.intValue();
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            MetaObject theParentBelow = theChild.theParentObject;
            if (theChild.equals(childToSkip) == false) {
                if (theParentBelow.theVisualObject instanceof JLayeredPane) {
                    theChild.setDisplayLayer(iDisplayLayer);
                }
                // reset all children.
                theChild.resetDisplayLayer(null);
            }
            theChild = theChild.theNextObject;
        }
    }

    /**
     *
     *
     * User Preference
     Java Property Name
     Type

     Active Title Bar size  "win.frame.captionHeight"  java.lang.Integer
     Active Window Border size  "win.frame.sizingBorderWidth"  java.lang.Integer
     Caption Buttons size  "win.frame.captionButtonHeight"
     "win.frame.captionButtonWidth"
     win.frame.captionHeight"  java.lang.Integer
     Icon size  "win.icon.hspacing"
     "win.icon.vspacing"???  java.lang.Integer
     Icon horizontal spacing  "win.icon.hspacing"  java.lang.Integer
     Icon vertical spacing  "win.icon.vspacing"  java.lang.Integer
     Inactive Title Bar size  "win.frame.captionButtonHeight"
     "win.frame.captionButtonWidth"
     "win.frame.captionHeight"  java.lang.Integer
     Inactive Window Border size  "win.frame.sizingBorderWidth"  java.lang.Integer
     Menu font size  "win.menu.font"
     "win.menu.height"  java.lang.Integer
     Menu Size  "win.menu.height"
     "win.menu.buttonWidth"  java.awt.Integer
     Palette Title size  "win.frame.smallCaptionHeight"
     "win.frame.smallCaptionButtonHeight"
     "win.frame.smallCaptionButtonWidth"  java.lang.Integer
     Scrollbar width  "win.scrollbar.width"  java.lang.Integer
     Scrollbar height  "win.scrollbar.height"  java.lang.Integer
     Selected Items size  "win.menu.height"
     "win.menu.buttonWidth"  java.lang.Integer

     *
     *
     *
     */


    public boolean renderObject() {
        create();
        if (theFabricatedObject instanceof JFrame) {
            JFrame theFrame = (JFrame) theFabricatedObject;
            Dimension dimSize = theFrame.getSize();
            // This is how you have to fix the non-client area sizing.
            // It has to be _exactly_ like this.
            theFrame.setVisible(false);
            theFrame.show();
            Insets theInsets = theFrame.getInsets();
            theFrame.setSize((int) dimSize.getWidth() + theInsets.left + theInsets.right,
                    (int) dimSize.getHeight() + theInsets.top + theInsets.bottom);
        }
        // If nobody sets the maximum size assume the size is max size when we render.
        if (theVisualObject != null) {
            Dimension dimSize = theVisualObject.getSize();
            Dimension dimMaxSize = theVisualObject.getMaximumSize();
            if ((dimMaxSize.width == 0) && (dimMaxSize.height == 0)) {
                if (dimSize != null) {
                    theVisualObject.setMaximumSize(dimSize);
                }
            }
            Dimension dimMinSize = theVisualObject.getMinimumSize();
            if ((dimMinSize.width == 0) && (dimMinSize.height == 0)) {
                if (dimSize != null) {
                    theVisualObject.setMinimumSize(dimSize);
                }
            }
//            Insets theInsets = theVisualObject.getInsets();
//            Dimension dimPreferredSize = theVisualObject.getPreferredSize();
//            if ((dimPreferredSize.width == 0) && (dimPreferredSize.height == 0)) {
//                if (dimSize != null) {
//                    int iWidth = (int) dimSize.getWidth();
//                    int iHeight = (int) dimSize.getHeight();
//                    if (theInsets != null) {
//                        iWidth -= (theInsets.left + theInsets.right);
//                        iHeight -= (theInsets.top + theInsets.bottom);
//                    }
//                    theVisualObject.setPreferredSize(new Dimension(iWidth, iHeight));
//                }
//            }
        }
        // Process the children.
        MetaObject theObject = theFirstChild;
        while (theObject != null) {
            theObject.renderObject();
            theObject = theObject.theNextObject;
        }
        if (theFabricatedObject instanceof JFrame) {
            JFrame theFrame = (JFrame) theFabricatedObject;
            theFrame.setVisible(true);
        }
        // Display the JMenus in the correct x location
        // Dislay Menu Items
        // MHC

        int locationX = 0;
        if (theFabricatedObject instanceof JMenuBar) {
            JMenuBar theMenuBar = (JMenuBar) theFabricatedObject;

            if (theParentObject.theFabricatedObject instanceof JFrame)
            {
                JFrame jfm = (JFrame) theParentObject.theFabricatedObject;
                jfm.setJMenuBar(theMenuBar);
            }

            MenuElement[] me = theMenuBar.getSubElements();
            for(int i=0;i < me.length;i++)
            {
                 JMenu jm = (JMenu)me[i];
            }
        }
        else if (theFabricatedObject instanceof JMenu) {
           JMenu theMenu = (JMenu) theFabricatedObject;
           MenuElement[] se = theMenu.getSubElements();
        }

        return true;
    }

    public boolean renderObject(JFrame theFrame) {
        if (theFrame == null)
            return false;
        this.theFabricatedObject = theFrame;
        this.theVisualFrame = theFrame;
        this.theVisualObject = null;
        Dimension dimSize = theFrame.getSize();
        Point ptLocation = theFrame.getLocation();
        setSize((int) dimSize.getWidth(), (int) dimSize.getHeight());
        setLocation((int) ptLocation.getX(), (int) ptLocation.getY());
        AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
        theLayoutManager = theAnchoringLayoutManager;
        theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
        MetaObject theObject = theFirstChild;
        while (theObject != null) {
            theObject.renderObject();
            theObject = theObject.theNextObject;
        }
        return true;
    }

    public boolean renderObject(JComponent theComponent) {
        if (theComponent == null)
            return false;
        this.theFabricatedObject = theComponent;
        this.theVisualFrame = null;
        this.theVisualObject = theComponent;
        Dimension dimSize = theComponent.getSize();
        Point ptLocation = theComponent.getLocation();
        setSize((int) dimSize.getWidth(), (int) dimSize.getHeight());
        setLocation((int) ptLocation.getX(), (int) ptLocation.getY());
        AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
        theLayoutManager = theAnchoringLayoutManager;
        if (theVisualObject instanceof Container) {
            theVisualObject.setLayout(theAnchoringLayoutManager);
            MetaObject theObject = theFirstChild;
            while (theObject != null) {
                theObject.renderObject();
                theObject = theObject.theNextObject;
            }
        }
        return true;
    }

    public boolean addDefaultProperty(String sPrefix, MetaPropertyDescriptor prop) {
        boolean bRetVal = false;
        MetaPropertyDescriptor theSubprop = prop.theFirstSubproperty;
        int iDotPos = prop.sName.indexOf(".");
        if ((iDotPos == -1) && (sPrefix != null) && (sPrefix.trim().length() > 0))
            sPrefix = sPrefix + ".";
        else
            sPrefix = "";
        if (theSubprop != null) {  // only add values for bottom level properties
            while (theSubprop != null) {
                addDefaultProperty(sPrefix + prop.sName, theSubprop);
                theSubprop = theSubprop.theNextProperty;
            }
        } else {
            if ((prop.getDefaultValue() != null) &&
                    (prop.getDefaultValue().trim().length() > 0)) {
                MetaPropertyValueEx pv = getPropertyValue(sPrefix + prop.sName, 0);
                if (pv == null) {
                    MetaParameter newProp = makeProperty(sPrefix + prop.sName, 0, prop.getOrder(), prop.sClass, prop);
                    String sDefaultValue = prop.getDefaultValue();
                    if ((sDefaultValue != null) && (prop.getIncludeTypeConstants() != null)) {
                        MetaConstantGroup theConstantTable = theDesignProject.findConstantGroup(prop.getIncludeTypeConstants());
                        if (theConstantTable != null) {
                            if (sDefaultValue instanceof String) {
                                sDefaultValue = theConstantTable.get(sDefaultValue);
                            }
                        } else {
                            MetaConstantGroupCollection theConstantTableGroup = theDesignProject.findConstantGroupCollection(prop.getIncludeTypeConstants());
                            if (theConstantTableGroup != null) {
                                if (sDefaultValue instanceof String) {
                                    sDefaultValue = theConstantTableGroup.get(sDefaultValue);
                                }
                            }
                        }
                    }
                    if (sDefaultValue != null)
                        newProp.set(prop.sClass, sDefaultValue, true, theDesignProject);
                }
            }
        }
        return bRetVal;
    }

    public boolean addDefaultProperties() {
        boolean bRetVal = false;
        MetaClass theWorkingClass = theClass;
        while (theWorkingClass != null) {
            MetaPropertyDescriptor propChain = theWorkingClass.theMetadata.theFirstProperty;
            while (propChain != null) {
                addDefaultProperty(null, propChain);
                propChain = propChain.theNextProperty;
            }
            theWorkingClass = theWorkingClass.theParentClass;
        }
        return bRetVal;
    }

    public boolean doProperties() {
        boolean bRetVal = true;
        String sPropertySetter = "";
        Class[] classes;
        Object[] objects;

       if(propsLoaded==false)
       {
        try {
             MetaProperty theProperty = theFirstProperty;
            // Get the class of the object.  In design mode use the display class.
            Class cls;
            if (iMode == MetaObject.DESIGN_MODE)
            {
                cls = Class.forName(theClass.theMetadata.sDisplayClass);
            }
            else
                cls = Class.forName(theType.theFullName);
            while (theProperty != null) {
                Object[] thePropertyValue = theProperty.Create();
                // special logic to allow translation of mnemonics.
                boolean bMnemonic = false;
                if (theProperty.theName.equals("Mnemonic"))
                    bMnemonic = true;
                // Ok, find the method to use.
                sPropertySetter = "set" + theProperty.theName;
                Method m = null;
                if (theProperty.bAllowMultipleValues) { // This is for arrays of values.
                    classes = new Class[1];
                    if (thePropertyValue[0] instanceof MetaPropertyValueEx) {
                        MetaPropertyValueEx theValue = (MetaPropertyValueEx) thePropertyValue[0];
                        Class clsSimpleClass = MetaPropertyValueEx.getTypeAsClass(theValue.getType());
                        String sSimpleType = clsSimpleClass.getName();
                        // pass the values as an array of whatever type is defined in the property.
                        classes[0] = Class.forName("[L" + sSimpleType + ";");
                        try {
                            m = cls.getMethod(sPropertySetter, classes);
                        } catch (NoSuchMethodException e69) {
                        }
                        if (m != null) {
                            // set the array values.
                            int iNoItems = thePropertyValue.length;
                            Object theParameter = Array.newInstance(clsSimpleClass, iNoItems);
                            for (int i = 0; i < iNoItems; i++) {
                                MetaPropertyValueEx someValue = (MetaPropertyValueEx) thePropertyValue[i];
                                ClassLoader theLoader = null;
                                theLoader = ((HammerClassLoader) theDesignProject.theClassLoader).getLoader();
                                Object theNativeValue = someValue.getNativeValue();
                                Object theResolvedValue = MetaConstantGroup.resolve(theNativeValue,
                                        theClass.theMetadataDispenser, theLoader);
                                if (theResolvedValue instanceof String) {
                                    // before setting prop in design cockpit do translation
                                    if (theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE) {
                                        theResolvedValue =
                                                theDesignProject.getNLS().getTranslatedValue
                                                ((String) theResolvedValue,
                                                        theDesignProject.theCurrentLanguage.theLanguage, bMnemonic);
                                    }
                                    if (clsSimpleClass == char.class) {
                                        theResolvedValue = new Character(((String) theResolvedValue).charAt(0));
                                    }
                                }
                                Array.set(theParameter, i, theResolvedValue);
                            }
                            // invoke the method.
                            objects = new Object[1];
                            objects[0] = theParameter;
                            m.invoke(theFabricatedObject, objects);
                        }
                    }
                } else {  // multiple arguments
                    if (thePropertyValue[0] instanceof MetaArgumentList) {
                        MetaArgumentList theArgs = (MetaArgumentList) thePropertyValue[0];
                        int iArgCount = theArgs.iArgCount;
                        classes = new Class[iArgCount];
                        objects = new Object[iArgCount];
                        for (int i = 0; i < iArgCount; i++) {
                            objects[i] = theArgs.getArgument(i);
                            if (objects[i] instanceof MetaPropertyValueEx) {
                                MetaPropertyValueEx theValue = (MetaPropertyValueEx) objects[i];
                                classes[i] = MetaPropertyValueEx.getTypeAsClass(theValue.getType());
                                ClassLoader theLoader = null;
                                theLoader = ((HammerClassLoader) theDesignProject.theClassLoader).getLoader();
                                Object theNativeValue = theValue.getNativeValue();
                                Object theResolvedValue = MetaConstantGroup.resolve(theNativeValue, theClass.theMetadataDispenser, theLoader);
                                //if (theResolvedValue != null)
                                //    classes[i] = theResolvedValue.getClass();
                                if ((classes[i] == null) || (classes[i].equals(String.class)))
                                    classes[i] = theProperty.getParameterClass();
                                if (theResolvedValue instanceof String) {
                                    // before setting prop in design cockpit do translation
                                    AbaNLS theNlsSupport = theDesignProject.getNLS();
                                    theResolvedValue =
                                            theNlsSupport.getTranslatedValue((String) theResolvedValue,
                                                    theDesignProject.theCurrentLanguage.theLanguage,
                                                    bMnemonic);
                                    if (classes[i] == char.class) {
                                        theResolvedValue = new Character(((String) theResolvedValue).charAt(0));
                                    }

                                }
                                objects[i] = theResolvedValue;
                            } else {
                                if (objects[i] != null)
                                    classes[i] = objects[i].getClass();
                                else
                                    classes[i] = Class.forName("java.lang.String");
                            }
                        }

                    } else {  // only one argument.
                        classes = new Class[1];
                        objects = new Object[1];
                        objects[0] = thePropertyValue[0];
                        if (objects[0] instanceof MetaPropertyValueEx) {
                            MetaPropertyValueEx theValue = (MetaPropertyValueEx) objects[0];
                            if (theValue.bResolveAsObject) {
                                //classes[0] = Class.forName("java.lang.Object");
                                //String theReference = (String) theValue.getNativeValue();
                                //objects[0] = theDesignProject.findObject(theReference).getSwingObject();
                                classes[0] = theValue.objectClass;
                                objects[0] = theValue.getNativeValue();  // MHC
                            } else {
                                classes[0] = MetaPropertyValueEx.getTypeAsClass(theValue.getType());
                                if (classes[0] == null)    // MHC
                                    classes[0] = theValue.objectClass;
                                ClassLoader theLoader = null;
                                theLoader = ((HammerClassLoader) theDesignProject.theClassLoader).getLoader();
                                Object theNativeValue = theValue.getNativeValue();
                                if (theNativeValue == null) {
                                    // Ok, this is a bit of a hack, but it gets around the fact that the value
                                    // doesn't actually store the encoded type.
                                    theNativeValue = theValue.getLocalString();
                                }
                                if ((classes[0] == null) || (classes[0].equals(String.class)))
                                    classes[0] = theProperty.getParameterClass();
                                Object theResolvedValue = MetaConstantGroup.resolve(theNativeValue, theClass.theMetadataDispenser, theLoader);
                                //if (theResolvedValue != null)
                                //    classes[0] = theResolvedValue.getClass();

                                if (theResolvedValue instanceof String) {
                                    // before setting prop in design cockpit do translation
                                    if (theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE) {
                                        theResolvedValue =
                                                theDesignProject.getNLS().getTranslatedValue
                                                ((String) theResolvedValue,
                                                        theDesignProject.theCurrentLanguage.theLanguage, bMnemonic);
                                    }
                                    if (classes[0] == char.class) {
                                        if (((String) theResolvedValue).length() > 0)
                                            theResolvedValue = new Character(((String) theResolvedValue).charAt(0));
                                        else {
                                            theResolvedValue = new Character((char) 0);
                                            sPropertySetter = "AbaDCSkipInvocation";  // will not be found.
                                        }
                                    }
                                }
                                objects[0] = theResolvedValue;
                            }
                        } else
                            classes[0] = objects[0].getClass();
                    }
                    try {
                        m = cls.getMethod(sPropertySetter, classes);
                    } catch (java.lang.NoSuchMethodException e1) {
                    }
                    try {
                        if (m != null) {
                            m.invoke(theFabricatedObject, objects);
                        }
                    } catch (InvocationTargetException e99) {
                        String sErrMsg = "Illegal Argument For Method " + m.getName() +
                                " of class " + theFabricatedObject.getClass().getName();
                        if (theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE) {
                            if (theDesignProject.getMetaDataUser().getLogFile() != null)
                                theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Hammer Object Construction Error", sErrMsg);
                        } else {
                            if (theDesignProject.getMetaDataUser().getLogFile() != null)
                                theDesignProject.getMetaDataUser().getLogFile().doLogEntry("AbaRenderer Object Construction", sErrMsg);
                        }
                    }
                }
                theProperty = theProperty.theNextProperty;
            }
        } catch (Exception e1) {
            String sMessage1 = "Error invoking " + sPropertySetter + " for object " + getName();
            String sMessage2 = " Message is " + e1.getMessage();
            if (theDesignProject.getMetaDataUser().getLogFile() != null)
                theDesignProject.getMetaDataUser().getLogFile().doLogEntry(sMessage1, sMessage2);
            return false;
        }

        //  Name change.
        if (iMode == MetaObject.DESIGN_MODE) {
            theDesignProject.getMetaDataUser().processObjectNameChanged(this);
        }

        // Change container type to be from class.
        int iContainerType = theClass.theMetadata.containerType.getContainerType();
        this.setPropertyValue("ContainerType", 0, 0, MetaContainerType.getContainerTypeAsString(iContainerType), true);

        // Maybe we need to wrap it in a scrollpane?
        MetaPropertyValueEx pvAutoEmbed = getPropertyValue("AutoEmbed", 0);
        if (pvAutoEmbed != null) {
            bAutoEmbed = true;
        }

        //  Default Size.
        if ((isVertSplit() == false) && (isHorzSplit() == false)) {
            int iXSize = 0;
            int iYSize = 0;
            String sXSize = null;
            String sYSize = null;
            MetaPropertyValueEx pvXSize = getPropertyValue("Size.Width", 0);
            if (pvXSize != null)
                sXSize = pvXSize.getStringValue();
            MetaPropertyValueEx pvYSize = getPropertyValue("Size.Height", 0);
            if (pvYSize != null)
                sYSize = pvYSize.getStringValue();

            if ((sXSize != null) && (sYSize != null)) {
                try {
                    iXSize = Integer.parseInt(sXSize);
                    iYSize = Integer.parseInt(sYSize);
                } catch (Exception e0) {
                    iXSize = 0;
                    iYSize = 0;
                }
            }

            if ((sXSize == null) || (iXSize == 0)) {
                MetaPropertyDescriptor theProperty = theClass.getProperty("Size.Width", true);
                if (theProperty != null) {
                    String sDefaultValue = theProperty.getDefaultValue();
                    if (sDefaultValue != null)
                        sXSize = sDefaultValue;
                    else
                        sXSize = "";
                }
            }

            if ((sYSize == null) || (iYSize == 0)) {
                MetaPropertyDescriptor theProperty = theClass.getProperty("Size.Height", true);
                if (theProperty != null) {
                    String sDefaultValue = theProperty.getDefaultValue();
                    if (sDefaultValue != null)
                        sYSize = sDefaultValue;
                    else
                        sYSize = "";
                }
            }


            try {
                iXSize = Integer.parseInt(sXSize);
                iYSize = Integer.parseInt(sYSize);
            } catch (Exception e0) {
                iXSize = 0;
                iYSize = 0;
            }

            setSize(iXSize, iYSize);
        }
        //  Special stuff for Location.
        String sXLoc = null;
        MetaPropertyValueEx pvXLoc = getPropertyValue("Location.Left", 0);
        String sYLoc = null;
        MetaPropertyValueEx pvYLoc = getPropertyValue("Location.Top", 0);
        if (pvXLoc != null)
            sXLoc = pvXLoc.getStringValue();
        if (pvYLoc != null)
            sYLoc = pvYLoc.getStringValue();

        if (iMode == MetaObject.DESIGN_MODE) {
            if ((isFrame()) || (isAbalet())) {
                sXLoc = "0";
                sYLoc = "0";
            }
        }


        try {
            iXLocation = Integer.parseInt(sXLoc);
            iYLocation = Integer.parseInt(sYLoc);
        } catch (Exception e0) {
            iXLocation = 0;
            iYLocation = 0;
        }
        if (isFrame() || isAbalet()) {
            if (iMode == MetaObject.DESIGN_MODE) {
                iXLocation = 0;
                iYLocation = 0;
            }
        }
        if(theVisualObject != null && (isJMenu() || isJMenuItem() || isJToolBarButton()))
        {
        }
        else if (theVisualObject != null)
            theVisualObject.setLocation(iXLocation, iYLocation);
        if (theVisualFrame != null)
            theVisualFrame.setLocation(iXLocation, iYLocation);
        //  Special stuff for Color.
        //  Special stuff for Font.
//        String sColorName = null;
//        MetaPropertyValueEx pvColorBackground = getPropertyValue("Background", 0);
//        if (pvColorBackground != null) {
//            sColorName = pvColorBackground.getStringValue();
//            theBackgroundColor = MetaConstantGroup.getColorFromString(sColorName);
//            if (theBackgroundColor != null)
//                setBackgroundColor(theBackgroundColor);
//        }
//        sColorName = null;
//        MetaPropertyValueEx pvColorForeground = getPropertyValue("Foreground", 0);
//        if (pvColorForeground != null) {
//            sColorName = pvColorForeground.getStringValue();
//            theForegroundColor = MetaConstantGroup.getColorFromString(sColorName);
//            if (theForegroundColor != null)
//                setForegroundColor(theForegroundColor);
//        }
//        MetaPropertyValueEx pvFontName = getPropertyValue("Font", 0);
//        if (pvFontName != null) {
//            Font theFont = null;
//            try {
//                theFont = MetaConstantGroup.getFontFromString(pvFontName.getStringValue());
//            } catch (HammerException e) {
//                if (theDesignProject.getMetaDataUser().getLogFile() != null)
//                    theDesignProject.getMetaDataUser().getLogFile().doLogEntry("AbaRenderer Object Construction", e.getMessage());
//            }
//
//            if (theFont != null)
//                setFont(theFont);
//        }


        MetaPropertyValueEx pvBitmapName = getPropertyValue("BitmapName", 0);
        if (pvBitmapName != null) {
            String sIconName = pvBitmapName.getStringValue();
            if ((sIconName != null) && (theVisualObject instanceof JButton)) {
                Icon theIcon = new ImageIcon(sIconName);
                if (theIcon != null) {
                    JButton theButton = (JButton) theVisualObject;
                    theButton.setIcon(theIcon);
                }
            }
        }
// MHC Added so we can have bitmap pressed on tool bars from UI builder
        MetaPropertyValueEx pvBitmapNamePressed = getPropertyValue("BitmapNamePressed", 0);
        if (pvBitmapNamePressed != null) {
            String sIconName = pvBitmapNamePressed.getStringValue();
            if ((sIconName != null) && (theVisualObject instanceof JButton)) {
                Icon theIcon = new ImageIcon(sIconName);
                if (theIcon != null) {
                    JButton theButton = (JButton) theVisualObject;
                    theButton.setPressedIcon(theIcon);
                }
            }
        }

        if ((iMode == MetaObject.DESIGN_MODE) && (!isFrame()) && (!isAbalet())) {
            if (theClass.theMetadata.getDesignBorders() == true) {
                // if there are no borders add design borders.
                Border theBorder = theVisualObject.getBorder();
                if ((theBorder == null) || (theBorder instanceof javax.swing.border.EmptyBorder)) {
                    theVisualObject.setBorder(theDesignProject.getDesignBorder());
                }
            }
        }
       }
        //  Other Special Stuff.
        //  Handle Layout Manager.
        if (isFrame() || isTabPage() || isPanel() || isAbalet() || isGroup()) {
            if (iMode != DESIGN_MODE) {
                AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
                theAnchoringLayoutManager = new AnchoringLayoutManager();
                theLayoutManager = theAnchoringLayoutManager;
                if (isFrame())
                    theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
                else
                    theVisualObject.setLayout(theAnchoringLayoutManager);
            } else {  //  In design mode the design cockpit is in the design project.
                theDesignProject.getMetaDataUser().processCreateLayout(this);
            }
        }
        //  Set anchoring.
        if (!isFrame() && !isAbalet() && !isTabPage() && !isHorzSplit() && !isVertSplit() && !isJToolBarButton()) {
            // Anchoring properties are not implemented in the class - they are in the metaobject
            MetaPropertyValueEx pvValue = getPropertyValue("AnchorLeft", 0);
            if (pvValue != null) {
                Object oValue = pvValue.getNativeValue();
                if (oValue instanceof Boolean) {
                    bLeftAnchoring = ((Boolean) oValue).booleanValue();
                }
            }
            pvValue = getPropertyValue("AnchorRight", 0);
            if (pvValue != null) {
                Object oValue = pvValue.getNativeValue();
                if (oValue instanceof Boolean) {
                    bRightAnchoring = ((Boolean) oValue).booleanValue();
                }
            }
            pvValue = getPropertyValue("AnchorTop", 0);
            if (pvValue != null) {
                Object oValue = pvValue.getNativeValue();
                if (oValue instanceof Boolean) {
                    bTopAnchoring = ((Boolean) oValue).booleanValue();
                }
            }
            pvValue = getPropertyValue("AnchorBottom", 0);
            if (pvValue != null) {
                Object oValue = pvValue.getNativeValue();
                if (oValue instanceof Boolean) {
                    bBottomAnchoring = ((Boolean) oValue).booleanValue();
                }
            }
        }

        if (!isFrame() && !isAbalet())
        {
            if (isTabPage() == true)
            {
                if ((theParentObject != null) && (theParentObject.isTabbedPane() == true))
                {
                    theDesignProject.getMetaDataUser().processTabPages(this);
                }
            }
            else if (isJMenu() == true)
            {
                if ((theParentObject != null) && (theParentObject.isJMenuBar() == true))
                {
                    theDesignProject.getMetaDataUser().processMenus(this);
                }
            }
            else if (isJMenuItem() == true)
            {
                if ((theParentObject != null) && (theParentObject.isJMenu() == true))
                {
                    theDesignProject.getMetaDataUser().processMenuItems(this);
                }
            }
            else if (isJMenuSeparator() == true)
            {
                if ((theParentObject != null) && (theParentObject.isJMenu() == true))
                {
                    theDesignProject.getMetaDataUser().processMenuSeparators(this);
                }
            }
            else if (theParentObject != null)
            {
                    theDesignProject.getMetaDataUser().processPlacement(this);
            }
         }
         else
         {
            if (iMode == MetaObject.DESIGN_MODE) {
                this.theDesignProject.getMetaDataUser().processDoFrameSizeboxes(this);
            }
         }

        propsLoaded = true;
        return bRetVal;
    }

    public java.util.Hashtable getPropertyHashTable(Hashtable hashtable, MetaPropertyDescriptor theProp) {
        MetaPropertyDescriptor theProperty = theProp.theFirstSubproperty;
        while (theProperty != null) {
            MetaPropertyValueEx pv = getPropertyValue(theProperty.sName, 0);
            if (pv != null)
                hashtable.put(theProperty.sName, pv.getStringValue());
            if (theProperty.theFirstSubproperty != null)
                hashtable = getPropertyHashTable(hashtable, theProperty);
            theProperty = theProperty.theNextProperty;
        }
        return hashtable;
    }

    public java.util.Hashtable getPropertyHashTable() {
        Hashtable hashtable = new java.util.Hashtable(0);
        MetaClass theWorkingClass = theClass;
        while (theWorkingClass != null) {
            MetaPropertyDescriptor theProperty = theWorkingClass.theMetadata.theFirstProperty;
            while (theProperty != null) {
                MetaPropertyValueEx pv = getPropertyValue(theProperty.sName, 0);
                if (pv != null) {
                    String sValue = pv.getStringValue();
                    if (sValue != null)
                        hashtable.put(theProperty.sName, sValue);
                }
                if (theProperty.theFirstSubproperty != null)
                    hashtable = getPropertyHashTable(hashtable, theProperty);
                theProperty = theProperty.theNextProperty;
            }
            theWorkingClass = theWorkingClass.theParentClass;
        }
        return hashtable;
    }

    public Object getSwingObject() {
        return theFabricatedObject;
    }

    public boolean create() {
        // theType should have a factory name if it is defined in the class.

        MetaClass theMetaClass = theDesignProject.findClass(theType.theName);

        theType.theFactoryName = theMetaClass.theMetadata.theFactoryName;
        theType.theDesignProject = theDesignProject;
        theFabricatedObject = theType.Create(getName(), this);

        if(theFabricatedObject==null)
        {
            theDesignProject.getMetaDataUser().tellProgress("Error: " + theType.theName + "(" + theType.theFullName + ")" +"Class not found");
            return false;
        }
        // MHC   Added interface so components can have access to MetaObject
        // This used later on to determine whether we are in design mode for example.
        // This should not affect existing components.
        try {
            Class c = theFabricatedObject.getClass();
            Method m = null;
            Class[] interfaces = c.getInterfaces();

            for (int i = 0; i < interfaces.length; i++) {
                String interfaceName = interfaces[i].getName();
                interfaceName = interfaceName.substring(interfaceName.lastIndexOf('.') + 1);

                if (interfaceName.equalsIgnoreCase("MetaObjectAccess")) {
                    try {
                        Method[] methods = interfaces[i].getMethods();

                        for (int mc = 0; mc < methods.length; mc++) {
                            Object[] args_value = {this};

                            if (methods[mc].getName().equals("setMetaObject")) {
                                Class[] params = methods[mc].getParameterTypes();
                                // For now, it only supports one single call
                                // to the interface.
                                methods[mc].invoke(theFabricatedObject, args_value);
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // MHC

        theVisualObject = null;
        theVisualFrame = null;
        theDesignProject.getMetaDataUser().doNewVisualObject(this);
        if ((theVisualObject != null) || (theVisualFrame != null)) {
            addDefaultProperties();
            doProperties();

            int iContainerType = getContainerType();
            if (this.isGroup()) {
                theButtonGroup = new ButtonGroup();
            }
            if (theFabricatedObject instanceof JFrame) {
                if (iMode != MetaObject.DESIGN_MODE) {
                    AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
                    theLayoutManager = theAnchoringLayoutManager;
                    theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
                }
            } else {

                if (theVisualObject instanceof Container) {
//                    Container theContainer = theVisualObject;

                    if (iContainerType == MetaContainerType.CONTAINER_SCROLLPANE)
                        theVisualObject.setLayout(null);
                    else if ((iContainerType != MetaContainerType.CONTAINER_NONE) &&
                            (iContainerType != MetaContainerType.CONTAINER_TABBEDPANE) &&
                            (iContainerType != MetaContainerType.CONTAINER_VSPLIT) &&
                            (iContainerType != MetaContainerType.CONTAINER_HSPLIT) &&
                            (iContainerType != MetaContainerType.CONTAINER_JTOOLBAR) &&
                            (iContainerType != MetaContainerType.CONTAINER_JMENU) &&
                            (iContainerType != MetaContainerType.CONTAINER_JMENUBAR) &&
                            (iContainerType != MetaContainerType.CONTAINER_BUTTONGROUP)) {
                        if (iMode != MetaObject.DESIGN_MODE) {
                            AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
                            theLayoutManager = theAnchoringLayoutManager;
                            theVisualObject.setLayout(theAnchoringLayoutManager);
                        }
                    }
                }
            }
        }
        return true;
    }


    public boolean findChildObjectByNameX(String sObjectName) {
        MetaObject theChild = theFirstChild;
        while (theChild != null) {
            if (theChild.theName.equals(sObjectName))
                return true;
            theChild = theChild.theNextObject;
        }
        return false;
    }

    public boolean isPanel() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_PANEL)
            return true;
        else
            return false;
    }

    public boolean isTabbedPane() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_TABBEDPANE)
            return true;
        else
            return false;
    }

    public boolean isJMenuBar() {
            int iContainerType = getContainerType();
            if (iContainerType == MetaContainerType.CONTAINER_JMENUBAR)
                return true;
            else
                return false;
        }

    public boolean isJMenu() {
            int iContainerType = getContainerType();
            if (iContainerType == MetaContainerType.CONTAINER_JMENU)
                return true;
            else
                return false;
     }

    public boolean isJMenuItem() {
            int iContainerType = getContainerType();
            if (iContainerType == MetaContainerType.CONTAINER_JMENUITEM)
                return true;
            else
                return false;
     }

    public boolean isJMenuSeparator() {
            if (this.theClass.getMetadata().getDisplayName().equalsIgnoreCase("JSeparator"))
                return true;
            else
                return false;
    }

    public boolean isJToolBarButton() {
            if (this.theClass.getMetadata().getDisplayName().equalsIgnoreCase("JToolBarButton"))
                return true;
            else
                return false;
    }

    public boolean isJToolBar() {
            int iContainerType = getContainerType();
            if (iContainerType == MetaContainerType.CONTAINER_JTOOLBAR)
                return true;
            else
                return false;
    }

    public boolean isHorzSplit() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_HSPLIT)
            return true;
        else
            return false;
    }

    public boolean isVertSplit() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_VSPLIT)
            return true;
        else
            return false;
    }

    public boolean isTabPage() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_TABPAGE)
            return true;
        else
            return false;
    }

    public boolean isScrollingPanel() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_SCROLLING_PANEL)
            return true;
        else
            return false;
    }

    public boolean isScrollPane() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_SCROLLPANE)
            return true;
        else
            return false;
    }

    public boolean isGroup() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_BUTTONGROUP)
            return true;
        else
            return false;
    }

    public boolean isFrame() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_FRAME)
            return true;
        else
            return false;
    }

    public boolean isAbalet() {
        int iContainerType = getContainerType();
        if (iContainerType == MetaContainerType.CONTAINER_ABALET)
            return true;
        else
            return false;
    }

    public MetaObject getFirstChild() {
        return theFirstChild;
    }

    public MetaObject getLastChild() {
        return theLastChild;
    }

    public MetaObject getPreviousObject() {
        return thePreviousObject;
    }

    public MetaObject getNextObject() {
        return theNextObject;
    }

    public void DeleteObject(MetaProject theDesignProject, AbaMetaDataUser theUser) {
        if (theDesignProject != null) {  // clipboard object has design project of null
            if (theParentObject == null) {
                // for clipboard object design project _is_ null.
                if (theDesignProject.getFirstObject().equals(this))
                    theDesignProject.setFirstObject(theNextObject);
                if (thePreviousObject != null)
                    thePreviousObject.theNextObject = theNextObject;
                if (theNextObject != null)
                    theNextObject.thePreviousObject = thePreviousObject;
            } else {
                if (theParentObject.theFirstChild.equals(this))
                    theParentObject.theFirstChild = theNextObject;
                else {
                    thePreviousObject.theNextObject = theNextObject;
                }
                if (theParentObject.theLastChild.equals(this))
                    theParentObject.theLastChild = thePreviousObject;
                else
                    theNextObject.thePreviousObject = thePreviousObject;
            }
            thePreviousObject = theNextObject = null;
            theUser.processDeleteObject(this);
        }
        // Remove children.
        MetaObject theChild = theFirstChild;
        while (theChild != null) {
            theChild.DeleteObject(theDesignProject, theUser);
            theChild = theChild.theNextObject;
        }
        // Set to deleted.
        this.bIsDeleted = true;
        // Remove from the instance tracker.
        theInstanceTracker.removeObject(this);
    }

    public MetaObject Clone(MetaCloneMode theMode, MetaObject theParent, boolean bPreserveNames) {

        MetaObject theReturnValue = null;
        // CopyWithoutCodeOpenSource copies the events but it blanks the source code in the method.
        if(theMode.theMode == MetaCloneMode.shallowCopyWithoutCodeOpenSource)
        {
            theReturnValue = new MetaObject(theName, theClass.theMetadata.sClassName,
                            theClass.theMetadata.sFullClassName,
                            null, theDesignProject, DESIGN_MODE,
                            true);
        }
        else
        {

            theReturnValue = new MetaObject(theName, theClass.theMetadata.sClassName,
                        theClass.theMetadata.sFullClassName,
                        null, theDesignProject, DESIGN_MODE,
                        false);
        }

        theReturnValue.bMember = bMember;
        theReturnValue.bPopup = bPopup;
        theReturnValue.sCode = sCode;
        theReturnValue.iXLocation = iXLocation;
        theReturnValue.iYLocation = iYLocation;
        if (bPreserveNames)
            theReturnValue.setName(getName());

        // must be a container to have children.
        while ((theParent != null) && (theParent.getContainerType() == MetaContainerType.CONTAINER_NONE))
            theParent = theParent.theParentObject;

        if (theParent != null)
            theParent.addObject(theReturnValue);

        // add properties
        if (theFirstProperty != null) {
            MetaProperty testProperty = theFirstProperty;
            while (testProperty != null) {
                String sPropName = testProperty.theName;
                MetaProperty objPropertyStored = theReturnValue.getPropertyMetadata(sPropName);
                // only add to clone if it's not already there.
                if (objPropertyStored == null) {
                    MetaProperty theNewProperty = testProperty.Clone(this);
                    theReturnValue.addProperty(theNewProperty);
                }
                testProperty = testProperty.theNextProperty;
            }
        }
        // Copy methods from the object to the new object.
        if ((theFirstMethod != null) && (theMode.theMode != MetaCloneMode.shallowCopyWithoutCode)) {
            MetaMethodLinkage testMethod = theFirstMethod;
            theReturnValue.iMethodCount = 0;
            while (testMethod != null) {
                MetaMethodLinkage theNewMethod = testMethod.Clone();
                theReturnValue.addMethodLinkage(theNewMethod);
                testMethod = testMethod.theNextMethod;
                theReturnValue.iMethodCount++;
            }
        }
        // add subobjects.

        if ((theFirstChild != null) && (theMode.theMode == MetaCloneMode.deepCopy)) {
            MetaObject testChild = theFirstChild;
            while (testChild != null) {
                testChild.Clone(theMode, theReturnValue, bPreserveNames);
                testChild = testChild.theNextObject;
            }
        }
        return theReturnValue;
    }

    // Takes a child from the parent list, but does not delete it.
    public void removeChild(MetaObject theChild) {
        if (theChild.equals(theFirstChild)) {
            theFirstChild = theChild.theNextObject;
        }
        if (theChild.equals(theLastChild))
            theLastChild = theChild.thePreviousObject;
        if (theChild.theNextObject != null)
            theChild.theNextObject.thePreviousObject = theChild.thePreviousObject;
        if (theChild.thePreviousObject != null)
            theChild.thePreviousObject.theNextObject = theChild.theNextObject;
    }

    /**
     * Exchange position of objChild1 and objChild2 child objects of this object.
     * @param objChild1
     * @param objChild2
     */

    public void exchangeChildren(MetaObject objChild1, MetaObject objChild2) {
        theDesignProject.setProjectChangedState(true);
        MetaObject objChild1Prev = objChild1.thePreviousObject;
        MetaObject objChild1Next = objChild1.theNextObject;
        MetaObject objChild2Prev = objChild2.thePreviousObject;
        MetaObject objChild2Next = objChild2.theNextObject;
        MetaObject objFirst = theFirstChild;
        MetaObject objLast = theLastChild;

        if (objChild1.equals(objChild2Prev) == false) {
            objChild1.thePreviousObject = objChild2Prev;
            if (objChild2Prev != null)
                objChild2Prev.theNextObject = objChild1;
        } else
            objChild1.thePreviousObject = objChild2;

        if (objChild1.equals(objChild2Next) == false) {
            objChild1.theNextObject = objChild2Next;
            if (objChild2Next != null)
                objChild2Next.thePreviousObject = objChild1;
        } else
            objChild1.theNextObject = objChild2;

        if (objChild2.equals(objChild1Prev) == false) {
            objChild2.thePreviousObject = objChild1Prev;
            if (objChild1Prev != null)
                objChild1Prev.theNextObject = objChild2;
        } else
            objChild2.thePreviousObject = objChild1;

        if (objChild2.equals(objChild1Next) == false) {
            objChild2.theNextObject = objChild1Next;
            if (objChild1Next != null)
                objChild1Next.thePreviousObject = objChild2;
        } else
            objChild2.theNextObject = objChild1;

        if (objChild1.equals(objFirst)) {
            theFirstChild = objChild2;
        }

        if (objChild1.equals(objLast)) {
            theLastChild = objChild2;
        }

        if (objChild2.equals(objFirst)) {
            theFirstChild = objChild1;
        }

        if (objChild2.equals(objLast)) {
            theLastChild = objChild1;
        }


    }


    public void setParent(MetaObject theParentMetadata) {
        if (theParentObject != null)
            theParentObject.removeChild(this);
        theParentObject = theParentMetadata;
        // Hook up the parent metadata to point to this metadata.
        // Fix the pointers in the children.
        if (theParentMetadata.theFirstChild == null)
            theParentMetadata.theFirstChild = this;
        else
            theParentMetadata.theLastChild.theNextObject = this;
        thePreviousObject = theParentMetadata.theLastChild;
        theParentMetadata.theLastChild = this;
    }

    public void addMethodLinkage(MetaMethodLinkage theNewMethod) {
        if (theFirstMethod == null)
            theFirstMethod = theNewMethod;
        else
            theLastMethod.theNextMethod = theNewMethod;
        theLastMethod = theNewMethod;
    }

    //  Sets property values to the given project
    //  Does not attach to project object list.
    public void attachToProject(MetaProject theProject) {
        MetaProperty theProp = theFirstProperty;
        while (theProp != null) {
            theProp.attachToProject(theProject);
            theProp = theProp.theNextProperty;
        }
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.attachToProject(theProject);
            theChild = theChild.theNextObject;
        }
    }

    public void recursiveModeSet(int iNewMode) {
        this.iMode = iNewMode;
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.recursiveModeSet(iNewMode);
            theChild = theChild.theNextObject;
        }
    }


    public void addAllMethods(MetaClass objMetaClass) {
        MetaMethod objMethod = null;
        MetaClassDetail objClass = objMetaClass.getMetadata().theFirstListener;
        // Find where the method is defined in the heirarchy.
        while (objClass != null) {
            // Look to see if the class has already been processed.
            boolean bFound = false;
            MetaMethodLinkage objTestMethod = theFirstMethod;
            while (objTestMethod != null) {
                if (objTestMethod.theListener.sClassName.equals(objClass.sClassName)) {
                    bFound = true;
                    break;
                }
                objTestMethod = objTestMethod.theNextMethod;
            }
            if (bFound == false) {
                // if not, process it.
                objMethod = objClass.theFirstMethod;
                while (objMethod != null) {
                    MetaMethod theClonedMethod = new MetaMethod(objMethod);
                    MetaMethodLinkage theNewMethod = new MetaMethodLinkage(theClonedMethod, objClass);
                    iMethodCount++;
                    if (theFirstMethod == null)
                    {
                        MetaMethodLinkage tmpNewMethod = theNewMethod;
                        theClonedMethod = new MetaMethod(this.UDF_OBJECT_CODE,"","");
                        theNewMethod = new MetaMethodLinkage(theClonedMethod, objClass);
                        theFirstMethod = theNewMethod;
                        iMethodCount++;
                        theFirstMethod.theNextMethod = tmpNewMethod;
                        theNewMethod = tmpNewMethod;
                    }
                    else
                        theLastMethod.theNextMethod = theNewMethod;
                    theLastMethod = theNewMethod;
                    objMethod = objMethod.getNextMethod();
                }
            }
            objClass = objClass.theNextClass;
        }
    }

    public MetaMethodLinkage getMethod(String sMethodName) {
        // Find the method in the list.
        MetaMethodLinkage theMethod = theFirstMethod;
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodName))
                return theMethod;
            theMethod = theMethod.theNextMethod;
        }
        return null;
    }

    public void setMethodCode(String sMethodName, String sCode) {
        MetaMethodLinkage theMethod = getMethod(sMethodName);
        if (theMethod != null)
            theMethod.theMethod.setCode(sCode);
    }

    public void setMethodDoc(String sMethodName, String sDoc) {
        MetaMethodLinkage theMethod = getMethod(sMethodName);
        if (theMethod != null)
            theMethod.theMethod.setDoc(sDoc);
    }

    public void setObjectCode(String sCode) {
        theObjectSource = sCode;
    }

    public void setObjectdDoc(String sDoc) {
            theObjectSourceDoc = sDoc;
    }

    public String getObjectCode() {
        return theObjectSource;
    }

    public String getObjectdDoc() {
            return theObjectSourceDoc;
    }

    public int getMethodCount() {
        return iMethodCount;
    }


    public void addAllMethods() {
        MetaClass objClass = theClass;
        while (objClass != null) {
            addAllMethods(objClass);
            objClass = objClass.theParentClass;
        }
    }

    public MetaObject getVisualContainerObject(boolean bSearchFromParent) {
        MetaObject objTest = this;
        if (bSearchFromParent)
            objTest = theParentObject;
        while ((objTest != null) &&
                (objTest.isFrame() == false) &&
                (objTest.isAbalet() == false) &&
                (objTest.isPanel() == false) &&
                (objTest.isTabPage() == false) &&
                (objTest.isGroup() == false) &&
                (objTest.isHorzSplit() == false) &&
                (objTest.isVertSplit() == false) &&
                (objTest.isScrollingPanel() == false) &&
                (objTest.isJMenu() == false) &&
                (objTest.isJMenuBar() == false) &&
                (objTest.isJMenuItem() == false) &&
                (objTest.isJToolBar() == false) &&
                (objTest.isTabbedPane() == false))
            objTest = objTest.theParentObject;
        return objTest;
    }

    public MetaObject getViewDisplayerContainer(boolean bSearchFromParent) {
        MetaObject objTest = this;
        if (bSearchFromParent)
            objTest = theParentObject;
        while ((objTest != null) &&
                (objTest.isFrame() == false) &&
                (objTest.isAbalet() == false))
            objTest = objTest.theParentObject;
        return objTest;
    }

    public LayoutManager getLayoutManager() {
        try {
            return (LayoutManager) theLayoutManager;
        } catch (java.lang.ClassCastException e1) {
        }
        return null;
    }


    public void setLocation(int x, int y) {
        if ((x == iXLocation) && (y == iYLocation))
            return;
        iXLocation = x;
        iYLocation = y;
        if (iMode == MetaObject.DESIGN_MODE)
            theDesignProject.setProjectChangedState(true);
        setPropertyValue("Location.Left", 0, 0, iXLocation, true);
        setPropertyValue("Location.Top", 0, 1, iYLocation, true);
        if (isFrame() || isAbalet()) {
            if (iMode == MetaObject.DESIGN_MODE) {
                x = iXLocation = 0;
                y = iYLocation = 0;
            }
        }
        if (theVisualObject != null) {  //  Don't relocate frame in execution mode.
            theVisualObject.setLocation(x, y);
        }
        if (theVisualFrame != null)
            theVisualFrame.setLocation(x, y);
    }

    public void setSize(int x, int y) {
        if ((x < 0) || (y < 0))
            return;
        // splitters don't set size.
        if (isHorzSplit() || isVertSplit())
            return;
        if (isTabPage() && (theParentObject != null)) {  // tab page gets size from component
            if ((theVisualObject != null) && (iMode == MetaObject.DESIGN_MODE)) {
                dimSize = theVisualObject.getSize();  // what we need to do really is get the size without the tab runs.
            } else {
                dimSize = this.theParentObject.getSize();
            }
            x = (int) dimSize.getWidth();
            y = (int) dimSize.getHeight();
        }
        if (iMode == MetaObject.DESIGN_MODE) {
            if ((x != dimSize.getWidth()) || (y != dimSize.getHeight()))
                theDesignProject.setProjectChangedState(true);
        }
        setPropertyValue("Size.Width", 0, 0, x, true);
        setPropertyValue("Size.Height", 0, 1, y, true);
        dimSize = new Dimension(x, y);
        if (theVisualObject != null)
            theVisualObject.setSize(dimSize);
        if (theVisualFrame != null)
            theVisualFrame.setSize(dimSize);
        if (theScrollPane != null)
            theScrollPane.setSize(dimSize);
    }


    public void refresh() {
        setPropLoaded(false);
        doProperties();
        MetaObject theChild = theFirstChild;
        while (theChild != null) {
            theChild.refresh();
            theChild = theChild.theNextObject;
        }
    }

    public Point getLocation() {
        if (isFrame() || isAbalet()) {
            if (iMode == MetaObject.DESIGN_MODE) {
                iXLocation = 0;
                iYLocation = 0;
                return new Point(0, 0);
            }
        }
        MetaPropertyValueEx pvXLocation = getPropertyValue("Location.Left", 0);
        MetaPropertyValueEx pvYLocation = getPropertyValue("Location.Top", 0);
        int iXLocation = 0;
        int iYLocation = 0;
        if (pvXLocation != null) {
            Object oXLocation = pvXLocation.getNativeValue();
            if (oXLocation instanceof Integer)
                iXLocation = ((Integer) oXLocation).intValue();
        }
        if (pvYLocation != null) {
            Object oYLocation = pvYLocation.getNativeValue();
            if (oYLocation instanceof Integer)
                iYLocation = ((Integer) oYLocation).intValue();
        }
        Point theReturnValue = new Point(iXLocation, iYLocation);
        return theReturnValue;
    }

    public Dimension getSize() {
        if (isTabPage()) {  // tab page get size from parent.
            dimSize = theParentObject.getSize();
        }
        return dimSize;
    }

    public MetaObject getChildObjectByName(String sName) {
        MetaObject theObject = this.theFirstChild;
        // Search this level first.
        while (theObject != null) {
            if (theObject.theName.equals(theName))
                return theObject;
            theObject = theObject.theNextObject;
        }
        theObject = this.theFirstChild;
        while (theObject != null) {
            MetaObject theMatch = theObject.getChildObjectByName(sName);
            if (theMatch != null)
                return theMatch;
            theObject = theObject.theNextObject;
        }
        return null;
    }

    // code generation methods
    public void writeDeclarations(ProjectDocument theDocumentManager) {
        // Prepend a user-defined prefix to the name of the object variables...
        String sInstancePrefix = this.theDesignProject.getDeclVariablePrefix();
        if (sInstancePrefix == null)
            sInstancePrefix = "";
        if (!isFrame() && !isAbalet()) {
            if (theClass.theMetadata.getSkipDecl() == false) {
                String sClassName = theClass.theMetadata.sFullClassName;
                int iLastDot = sClassName.lastIndexOf(".");
                sClassName = sClassName.substring(iLastDot + 1); // Change by SWB because the sClassName is not always the same as the last part of sFullClassName (as in the case of JATabPage)

                String sDeclaration = "private " + sClassName + " " + sInstancePrefix +getName() + ";";
                String sAssignmentBuffer = theDocumentManager.getCodeGenerator().getAssignmentBuffer();
                String sDeclBuffer = theDocumentManager.getCodeGenerator().getDeclarationBuffer();
                sDeclBuffer += sDeclaration;
                sDeclBuffer += "\r\n";


                sDeclaration = sInstancePrefix + getName() + " = (" + sClassName + ") m_AbaRenderer.getObject(\"" + getName() + "\");";
                sAssignmentBuffer += sDeclaration;
                sAssignmentBuffer += "\r\n";
                theDocumentManager.getCodeGenerator().setAssignmentBuffer(sAssignmentBuffer);
                theDocumentManager.getCodeGenerator().setDeclarationBuffer(sDeclBuffer);
            }
        }
        MetaObject objTest = this.theFirstChild;
        while (objTest != null) {
            objTest.writeDeclarations(theDocumentManager);
            objTest = objTest.theNextObject;
        }
    }

    public String getPostConstructionCode() {
        return thePostConstructionCode;
    }

    public void setPostConstructionCode(String thePostConstructionCode) {
        this.thePostConstructionCode = thePostConstructionCode;
    }

    public void setConstructorParameters(String theConstructorParameters) {
        this.theConstructorParameters = theConstructorParameters;
    }

    public String getPreConstructionCode() {
        return thePreConstructionCode;
    }

    public void setPreConstructionCode(String thePreConstructionCode) {
        this.thePreConstructionCode = thePreConstructionCode;
    }

    public String getConstructorParameters() {
        return theConstructorParameters;
    }

    public Color getBackgroundColor() {
        return this.theBackgroundColor;
    }

    public ObjectTreeViewNode getTreeNode() {
        return this.theTreeNode;
    }

    public void setTreeNode(ObjectTreeViewNode theNewNode) {
        theTreeNode = theNewNode;
    }

    public Font getFont() {
        return this.theFont;
    }

    public ButtonGroup getButtonGroup() {
        return this.theButtonGroup;
    }

    public boolean isWithinTabPane() {
        boolean bRetVal = false;
        if (isTabbedPane() || this.isTabPage())
            return true;
        if (isFrame() || isAbalet())
            return false;
        if (theParentObject == null)
            return false;
        return theParentObject.isWithinTabPane();
    }

    public void doEndDrag() {
    }




    public MetaObject createSplitter(int iMouse, boolean bVertical) {
        MetaClass theSplitterClass;
        String sSuffix1;
        String sSuffix2;
        int iMouseY = 0;
        int iMouseX = 0;
        if (bVertical) {
            iMouseY = iMouse;
            sSuffix1 = "_top";
            sSuffix2 = "_bottom";
            theSplitterClass = theClass.theMetadataDispenser.getVerticalSplitterClass();
        } else {
            sSuffix1 = "_left";
            sSuffix2 = "_right";
            iMouseX = iMouse;
            theSplitterClass = theClass.theMetadataDispenser.getHorizontalSplitterClass();
        }
        // create splitter object as child of this object
        // create two panels as children of splitter
        MetaClass theDefaultPanelClass = theClass.theMetadataDispenser.getDefaultPanelClass();
        if ((theSplitterClass == null) || (theDefaultPanelClass == null))
            return null;
        MetaObject theSplitter = new MetaObject(getName() + "_split",
                theSplitterClass.getMetadata().sClassName,
                theSplitterClass.getMetadata().sFullClassName,
                this,
                theDesignProject,
                theDesignProject.iMode,
                true);
        addObject(theSplitter);

        MetaObject theFirstPanel = new MetaObject(getName() + sSuffix1,
                theDefaultPanelClass.getMetadata().sClassName,
                theDefaultPanelClass.getMetadata().sFullClassName,
                theSplitter,
                theDesignProject,
                theDesignProject.iMode,
                true);
        theSplitter.addObject(theFirstPanel);
        MetaObject theSecondPanel = new MetaObject(getName() + sSuffix2,
                theDefaultPanelClass.getMetadata().sClassName,
                theDefaultPanelClass.getMetadata().sFullClassName,
                theSplitter,
                theDesignProject,
                theDesignProject.iMode,
                true);
        theSplitter.addObject(theSecondPanel);
        theSplitter.initializeSplitPaneComponents(iMouseX, iMouseY, dimSize);
        theFirstPanel.initializeSplitPaneComponents(iMouseX, iMouseY, dimSize);
        theSecondPanel.initializeSplitPaneComponents(iMouseX, iMouseY, dimSize);
        theDesignProject.getMetaDataUser().showObject(theSplitter);
        theDesignProject.getMetaDataUser().showObject(theFirstPanel);
        theDesignProject.getMetaDataUser().showObject(theSecondPanel);
        return theSplitter;
    }

    public MetaObject createHorizontalSplitter(int iMouseX) {
        return createSplitter(iMouseX, false);
    }

    public MetaObject createVerticalSplitter(int iMouseY) {
        return createSplitter(iMouseY, true);
    }

    void initializeSplitPaneComponents(int iMouseX, int iMouseY, Dimension dimSize) {
        if (theClass.getMetadata().containerType.getContainerType() != MetaContainerType.CONTAINER_NONE)
            setPropertyValue("ContainerType", 0, 0,
                    new String(theClass.getMetadata().containerType.getContainerTypeAsString()), false);
        setPropertyValue("Text", 0, 0, getName(), true);
        // Set initial location.
        if (isPanel()) {
            setPropertyValue("Location.Left", 0, 0, 0, true);///new Integer(0).toString() );
            setPropertyValue("Location.Top", 0, 1, 0, true);///new Integer(0).toString() );
        } else {
            setPropertyValue("Location.Left", 0, 0, 0, false);///new Integer(iMouseX).toString() );
            setPropertyValue("Location.Top", 0, 1, 0, false);///new Integer(iMouseY).toString());
            if (isHorzSplit())
                setPropertyValue("DividerLocation", 0, 0, iMouseX, true);
            if (isVertSplit())
                setPropertyValue("DividerLocation", 0, 0, iMouseY, true);
        }
        if (isPanel()) {
            setPropertyValue("Size.Width", 0, 0, dimSize.width, true);///new Integer(0).toString() );
            setPropertyValue("Size.Height", 0, 1, dimSize.height, true);///new Integer(0).toString() );
        }
        psText = getName();
        iMode = MetaObject.DESIGN_MODE;
    }

    public Object getAdditionalData () {
        return theAdditionalData;
    }

    public void setAdditionalData ( Object _theAdditionalData ) {
        theAdditionalData = _theAdditionalData;
    }

    public String getPatchedClassName() {
            return theName;
    }

    public void setPatchedClassName(String theName) {
        this.theName = theName;
    }

    public boolean isPatched() {
            return bObjectPatched;
    }

    public void setPatchedStatus(boolean bFlag) {
            bObjectPatched=bFlag;
    }

    public boolean isCompositeComponent() {
            return theClass.getMetadata().bCompositeComponent;
    }

    /**
     * Returns the String that you can use with metaObject.setPropertyValue, if you want to pass the name of a constant
     * @param sPropertyName the name of the property, such as "Background"
     * @param sConstantSymbol the name of the constant, such as "clBtnFace"
     * @return the converted value that you can use (for example, "invoke:java.awt.Color,ch.abacus.lib.ui.plaf.AbacusLookAndFeel,getBtnFace[]")
     */
    public String getConstantValueFromSymbol(String sPropertyName, String sConstantSymbol) {
        String sConstantValue = null;
        final MetaClass metaClass = theClass;
        MetaPropertyDescriptor theProperty = metaClass.getProperty(sPropertyName, true);

        MetaConstantGroup theConstantTable = theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        MetaConstantGroupCollection theConstantTableGroup = null;
        if (theConstantTable != null) {
            String sMatch = theConstantTable.get(sConstantSymbol);
            if (sMatch != null)
                sConstantValue = sMatch;

        } else {
            theConstantTableGroup = theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableGroup != null) {
                    String sMatch = theConstantTableGroup.get(sConstantSymbol);
                    if (sMatch != null)
                        sConstantValue = sMatch;
            }
        }
        return sConstantValue;
    }

    public boolean isPropLoaded()
    {
      return propsLoaded;
    }

    public void setPropLoaded(boolean bFlag)
    {
        propsLoaded = bFlag;
    }


}
