/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer;
import ch.abacus.lib.ui.renderer.common.generator.ProjectCodeGenerator;
import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;
import ch.abacus.lib.util.GlobalInterface;

import javax.swing.border.Border;
import java.awt.*;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *
 *          <Name>text value that names project</Name>      <--- note that
 this should not have paths just the name
 <Author>text value that names the author</Author>
 <Version>version number of the project</Version>  <-- auto
 increments.
 <Hammer>version number of the hammer used to build it</Hammer>
 <- written by hammer.
 <AbaRenderer>minimum version of renderer required</AbaRenderer>  <--
 written by hammer - checked by renderer

 <Language>
 <Object Declarations>  Numerous

 *
 */

public class MetaProject {
    public String sName = "";
    public String sAuthor = "";
    public String sDocumentVersion = "";
    public String sHammerVersion = "0";
    public String sRendererVersion = "";
    public GlobalInterface theGlobalInterface = null;
    public AbaNLS theNLSSupport = new AbaNLS(this);
    public ArrayList theLocalNLSDocuments = new ArrayList(0);
    public String sHammerRevision = "0";
    public String sHammerSubRevision = "0";
    public String sHammerBuild = "0";
    public String sGenLookFeelName = "Default";
    private boolean isNLSTranslation    = true; // MHC
    private boolean bGenerateAccessor   = true; // MHC
    private String  AdditionalImports   = "";
    private String  sRepositPath         = "";

    public long lHammerVersionFactor = 0;
    public Class renderingClass = null;
    private static final long FIX_ORDER_IN_PARAMETERS = MetaProject.calculateProjectFactor("0", "4", "1");

    public static final int DEFAULT_LOOK = 0;   //
    public static final int PLASTICXP_LOOK = 1;   //
    public static final int PLASTIC3D_LOOK = 2;  //
    public static final int PLASTIC_LOOK = 3;   //


    MetadataDispenser theMetadataDispenser;
    private ArrayList objList = new ArrayList();    // MHC

    private String sDirectoryName = "";
    private ProjectCodeGenerator codeGenerator;;

    private String declVariablePrefix; // the user-defined prefix for object variables in the DECL file

    public MetadataDispenser getMetadataDispenser() {
        return theMetadataDispenser;
    }

    public void setFirstClass(MetaClass theFirstClass) {
        theMetadataDispenser.setFirstClass(theFirstClass);
    }

    public MetaClass getLastClass() {
        return theMetadataDispenser.getLastClass();
    }

    public MetaClass getFirstClass() {
        return theMetadataDispenser.getFirstClass();
    }

    public void setLastClass(MetaClass theLastClass) {
        theMetadataDispenser.setLastClass(theLastClass);
    }

    public MetaClass getFirstListener() {
        return theMetadataDispenser.getFirstListener();
    }

    public void setFirstListener(MetaClass theFirstListener) {
        theMetadataDispenser.setFirstListener(theFirstListener);
    }

    public MetaClass getLastListener() {
        return theMetadataDispenser.getLastListener();
    }

    public void setLastListener(MetaClass theLastListener) {
        theMetadataDispenser.setLastListener(theLastListener);
    }

    public int getiListenerCount() {
        return theMetadataDispenser.getListenerCount();
    }

    public void setiListenerCount(int iListenerCount) {
        theMetadataDispenser.setListenerCount(iListenerCount);
    }

    public MetaConstantGroup getFirstMetaConstantGroup() {
        return theFirstMetaConstantGroup;
    }

    public void setFirstMetaConstantGroup(MetaConstantGroup theFirstMetaConstantGroup) {
        this.theFirstMetaConstantGroup = theFirstMetaConstantGroup;
    }

    public MetaConstantGroup getLastMetaConstantGroup() {
        return theLastMetaConstantGroup;
    }

    public void setLastMetaConstantGroup(MetaConstantGroup theLastMetaConstantGroup) {
        this.theLastMetaConstantGroup = theLastMetaConstantGroup;
    }

    public MetaConstantGroupCollection getFirstMetaConstantGroupCollection() {
        return theFirstMetaConstantGroupCollection;
    }

    public void setFirstMetaConstantGroupCollection(MetaConstantGroupCollection theFirstMetaConstantGroupCollection) {
        this.theFirstMetaConstantGroupCollection = theFirstMetaConstantGroupCollection;
    }

    public MetaConstantGroupCollection getLastMetaConstantGroupCollection() {
        return theLastMetaConstantGroupCollection;
    }

    public void setLastMetaConstantGroupCollection(MetaConstantGroupCollection theLastMetaConstantGroupCollection) {
        this.theLastMetaConstantGroupCollection = theLastMetaConstantGroupCollection;
    }


    MetaClass theFirstClass = null;
    MetaClass theLastClass = null;
    MetaClass theFirstListener = null;
    MetaClass theLastListener = null;
    int iListenerCount = 0;
    electric.xml.Document xmlSystemDocument = null;
    MetaConstantGroup theFirstMetaConstantGroup = null;
    MetaConstantGroup theLastMetaConstantGroup = null;
    MetaConstantGroupCollection theFirstMetaConstantGroupCollection = null;
    MetaConstantGroupCollection theLastMetaConstantGroupCollection = null;
    protected MetadataAdministrator theMetaDataAdministrator; // Changes to metadata
//    public HammerMetadataDocument theMetadataDocument = new HammerMetadataDocument(this);
    public int iMetadataVersion = 0;
    public int iMetadataRevision = 0;
    public int iMetadataSubrevision = 0;
    public int iMetadataBuild = 0;

    public MetaProjectHeader theProgramData = null;
    MetaProject thePrevDesignProject = null;
    MetaProject theNextDesignProject = null;
    electric.xml.Document xmlProjectDocument = null;
    public int iInputType = 0;
    public static final int UNDEFINED_INPUT_TYPE = 0;
    public static final int FROM_XML_DOCUMENT = 1;
    public static final int FROM_RESOURCE = 2;
    public static final int FROM_STRING = 3;
    public static final int FROM_CLASS = 4;
    public int iMode = 0;
    private AbaMetaDataUser theMetaDataUser = null;
    public Object theClassLoader = null;
    HammerLanguagePresentation theCurrentLanguage = null;
    HammerLanguagePresentation theFirstLanguage = null;
    HammerLanguagePresentation theLastLanguage = null;
    boolean bChanged = false;
    HammerJarAccess theJarAccess = null;
    MetaObject theFirstObject = null;
    MetaObject theLastObject = null;


    public MetaProject(int iMode, GlobalInterface theGlobalInterface, Object theClassLoader, MetadataDispenser theMetadataDispenser) throws HammerException {
        this.iMode = iMode;
        this.theMetadataDispenser = theMetadataDispenser;
        this.theGlobalInterface = theGlobalInterface;
        this.theClassLoader = theClassLoader;
        // create default language.
        this.setCurrentLanguage(HammerLanguagePresentation.DEFAULT);
    }

    public MetaProject(int iMode, GlobalInterface theGlobalInterface, Object theClassLoader, MetadataDispenser theMetadataDispenser, MetaProject templateProject) throws HammerException {
        this.iMode = iMode;
        this.theMetadataDispenser = theMetadataDispenser;
        this.theGlobalInterface = theGlobalInterface;
        this.theClassLoader = theClassLoader;
        // create default language.
        this.setCurrentLanguage(HammerLanguagePresentation.DEFAULT);
        this.sAuthor = templateProject.sAuthor;
        this.sDocumentVersion = templateProject.sDocumentVersion;
        this.sHammerVersion = templateProject.sHammerVersion;
        this.sName = templateProject.sName;
        this.sRendererVersion = templateProject.sRendererVersion;
        this.theGlobalInterface = templateProject.theGlobalInterface;
        theMetaDataUser = templateProject.theMetaDataUser;
        String SystemDocumentPath = theMetaDataUser.getSystemConfigurationPathName() + theMetaDataUser.getSystemMetadataDocumentName();
        if (SystemDocumentPath == null)
            SystemDocumentPath = "metadata.meta";
        boolean bTest = loadMeta(SystemDocumentPath);
        // Repository Code -- Loadable definitions
        String repositoryPath = theMetaDataUser.getConfigurationManager().getConfigurationVariable("RepositoryPath");
        if(repositoryPath!=null)
            loadCustomMeta(SystemDocumentPath,repositoryPath);
        if (bTest == true) {
            getNLS().Load(templateProject);
            MetaObject theObject = templateProject.theFirstObject;
            while (theObject != null) {
                MetaObject theNewObject = theObject.Clone(new MetaCloneMode(MetaCloneMode.deepCopy), null, true);
                theNewObject.attachToProject(this);
                theNewObject.recursiveModeSet(AbaMetaDataUser.EXECUTION_MODE);
                this.addObject(theNewObject);
                theObject = theObject.theNextObject;
            }
        }
    }

    private void loadMeta(MetaClass theParent, MetaClass srcClass) {
        while (srcClass != null) {
            MetaClass newClass = theParent.addInstanceTracker(srcClass);
            newClass.theParentClass = theParent;
            if (srcClass.theFirstClass != null) {
                loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
    }

    public boolean loadMeta(DropletSimpleLog theLog, String systemDocumentPath) {
        boolean bRetValue = theMetadataDispenser.theMetadataDocument.loadMeta(theLog, systemDocumentPath);
        // make meta classes for project from metadata dispenser.
        // these just keep track of object instances.
        MetaClass srcClass = theMetadataDispenser.theFirstClass;
        while (srcClass != null) {
            MetaClass newClass = this.addInstanceTracker(srcClass);
            if (srcClass.theFirstClass != null) {
                loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
        return bRetValue;
    }

    public boolean loadMeta(String systemDocumentPath) {
        return loadMeta(null, systemDocumentPath);
    }

    public void resetMetadata()
    {

        try
        {
            theMetadataDispenser = new MetadataDispenser(theMetadataDispenser.theUser,theMetadataDispenser.getGlobalInterface(),MetaObject.DESIGN_MODE);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }

    }

    public boolean loadCustomMeta(String systemDocumentPath,String repositoryPath) {
        // Repository Section
        sRepositPath = repositoryPath;
        boolean bRetValue = theMetadataDispenser.theMetadataDocument.loadCustomMeta(systemDocumentPath,repositoryPath);;
        MetaClass srcClass = theMetadataDispenser.theFirstClass;
        while (srcClass != null) {
            MetaClass newClass = this.addInstanceTracker(srcClass);
            if (srcClass.theFirstClass != null) {
                loadMeta(newClass, srcClass.theFirstClass);
            }
            srcClass = srcClass.theNextSibling;
        }
        theMetadataDispenser.theMetadataDocument.setCustomMetadataComplete(true);
         return bRetValue;
   }

    public int getInputType() {
        return iInputType;
    }

    public void setInputType(int iInputType) {
        this.iInputType = iInputType;
    }

    public MetaObject getFirstObject() {
        return theFirstObject;
    }

    public MetaObject getLastObject() {
        return theLastObject;
    }

    public void setFirstObject(MetaObject someObject) {
        theFirstObject = someObject;
    }

    public void setLastObject(MetaObject someObject) {
        theLastObject = someObject;
    }

    public String getName() {
        return this.sName;
    }

    public AbaNLS getNLS() {
        return this.theNLSSupport;
    }

    public void setNLS(AbaNLS theNLS) {
        this.theNLSSupport = theNLS;
    }


    public void setCurrentLanguage(int theLanguage) {
        HammerLanguagePresentation testLanguage = this.theFirstLanguage;
        while (testLanguage != null) {
            if (testLanguage.theLanguage == theLanguage) {
                theCurrentLanguage = testLanguage;
                break;
            }
            testLanguage = testLanguage.theNextLanguage;
        }
        if (testLanguage == null) {
            HammerLanguagePresentation theNewLanguage = new HammerLanguagePresentation(theLanguage, this);
            addLanguage(theNewLanguage);
            theCurrentLanguage = theNewLanguage;
        }
    }

    public HammerLanguagePresentation getLanguage(int iLang) {
        HammerLanguagePresentation theLang = theFirstLanguage;
        while (theLang != null) {
            if (theLang.theLanguage == iLang)
                return theLang;
            theLang = theLang.theNextLanguage;
        }
        return null;
    }

    public void addLanguage(HammerLanguagePresentation theLanguagePresentation) {
        if (theFirstLanguage == null)
            theFirstLanguage = theLanguagePresentation;
        else {
            theLastLanguage.theNextLanguage = theLanguagePresentation;
            theLanguagePresentation.thePreviousLanguage = theLastLanguage;
        }
        theLastLanguage = theLanguagePresentation;
    }


    private MetaObject findObject(MetaObject theObject, String sObjectName) {
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName))
                return theObject;
            MetaObject theChildMatch = findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null)
                return theChildMatch;
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public MetaObject findObject(String sObjectName) {
        MetaObject theObject = theFirstObject;
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName))
                return theObject;
            MetaObject theChildMatch = findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null)
                return theChildMatch;
            theObject = theObject.theNextObject;
        }
        return null;
    }

    /**
     * Enumerates through the MetaObjects within the MetaProject and sends a callback to a requesting object once per MetaObject.
     * This is a generic mechanism that can be used by anyone needing to enumerate the objects (to test for objects containing certain property values, for example)
     * @param callbackObject - an object implementing the EnumerateProjectMetaObjectInterface interface that will receive the callback once per object.
     * @param startingObject - the MetaObject instance to start the enumeration from.
     */
    public void enumerateObjects(EnumerateProjectMetaObjectInterface callbackObject, MetaObject startingObject) {
        if (startingObject == null) return; //might be null for empty projects...
        do {
            callbackObject.callbackProjectMetaObject(startingObject);

            if (startingObject.theFirstChild != null)
                enumerateObjects(callbackObject, startingObject.theFirstChild);
            startingObject = startingObject.theNextObject;
        } while (startingObject != null);
    }

    // ***************    MHC  *************************
    private MetaObject findObjectByClass(MetaObject theObject, String sClasstName) {
        while (theObject != null) {
            String sFullName = theObject.theType.theFullName;
            if (sFullName.equals(sClasstName))
                objList.add(theObject);
            MetaObject theChildMatch = findObjectByClass(theObject.theFirstChild, sClasstName);
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public ArrayList findObjectsByClass(String sObjectClass) {
        MetaObject theObject = theFirstObject;
        objList.clear();

        while (theObject != null) {
            String sFullName = theObject.theType.theFullName;
            if (sFullName.equals(sObjectClass)) {
                objList.add(theObject);
            }
            if (theObject.theFirstChild != null)
                findObjectByClass(theObject, sObjectClass);

            theObject = theObject.theNextObject;
        }
        return objList;
    }
    // ***************    MHC  *************************

    public String getNewObjectName(String sClassName) {
        // Look in parent for child object of sClassName + suffix
        // When one isn't found we can use this name.
        int i = 1;
        while (true) {
            Integer iValue = new Integer(i);
            String sObjectName = sClassName + iValue.toString();
            if (findObject(sObjectName) == null)
                return sObjectName;
            i++;
        }
    }

    public MetaClass addInstanceTracker(MetaClass srcClass) {
        MetaClass newClass = srcClass.emptyClone();
        newClass.theParentClass = null;
        if (theLastClass == null)
            theFirstClass = newClass;
        else {
            newClass.thePrevSibling = theLastClass;
            theLastClass.theNextSibling = newClass;
        }
        theLastClass = newClass;
        return newClass;
    }

    public MetaClass findInstanceTracker(MetaClass theClass, String sClassName) {
        // Navigate through children.
        while (theClass != null) {
            if (theClass.theMetadata.sClassName.equals(sClassName))
                return theClass;
            if (theClass.theFirstClass != null) {
                MetaClass testClass = findClass(theClass.theFirstClass, sClassName);
                if (testClass != null)
                    return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass findInstanceTracker(String sClassName) {
        MetaClass theClass = theFirstClass;
        while (theClass != null) {
            if (theClass.theMetadata.sClassName.equals(sClassName))
                return theClass;
            if (theClass.theFirstClass != null) {
                MetaClass testClass = findClass(theClass.theFirstClass, sClassName);
                if (testClass != null)
                    return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass addClass(electric.xml.Element theClassDescriptor) {
        MetaClass newChild = theMetadataDispenser.addClass(theClassDescriptor);
        addInstanceTracker(newChild);
        return newChild;
    }

    public void addClass(MetaClass newChild) {
        theMetadataDispenser.addClass(newChild);
        addInstanceTracker(newChild);
    }


    public MetaClass findClass(MetaClass theClass, String sClassName) {
        return theMetadataDispenser.findClass(theClass, sClassName);
    }

    public MetaClass findClass(String sClassName) {
        return theMetadataDispenser.findClass(sClassName);
    }

    public MetaClass findClassLogged(DropletSimpleLog theLog, String sClassName) {
        return theMetadataDispenser.findClass(theLog, sClassName);
    }

    public MetaClass findListener(MetaClass theListener, String sListenerName) {
        return theMetadataDispenser.findListener(theListener, sListenerName);
    }

    public MetaClass findListener(String sListenerName) {
        return theMetadataDispenser.findListener(sListenerName);
    }

    public MetaClassDetail getNewListener(String sListenerName) {
        return theMetadataDispenser.getNewListener(sListenerName);
    }

    public MetaClassDetail getNewDefaultListener(int iIndex) {
        return theMetadataDispenser.getNewDefaultListener(iIndex);
    }

    public int getListenerCount() {
        return theMetadataDispenser.getListenerCount();
    }

    public MetaConstantGroup findConstantGroup(String sGroupName) {
        return theMetadataDispenser.findConstantGroup(sGroupName);
    }

    public MetaConstantGroupCollection findConstantGroupCollection(String sGroupName) {
        return theMetadataDispenser.findConstantGroupCollection(sGroupName);
    }

    public Border getDesignBorder() {
        Object obj = null;
        try {
            obj = MetaConstantGroup.resolve(theMetadataDispenser.sDesignBorderDefinition, theMetadataDispenser, theMetaDataUser.getClassLoader().getLoader());
        } catch (HammerException e) {
            return new javax.swing.border.LineBorder(Color.BLUE);
        }
        if (obj instanceof Border)
            return (Border) obj;
        else
            return new javax.swing.border.LineBorder(Color.BLUE);
    }

    public int getDefaultListenerCount() {
        return theMetadataDispenser.getDefaultListenerCount();
    }

    public int getContainerListener() {
        return theMetadataDispenser.theListenerCollection.getContainerListener();
    }

    public boolean findChildObjectByName(String sObjectName) {
        MetaObject theChild = theFirstObject;
        while (theChild != null) {
            if (theChild.getName().equals(sObjectName))
                return true;
            theChild = theChild.theNextObject;
        }
        return false;
    }


    public boolean save(MetaProjectHeader progInfo, electric.xml.Element theParent) {
        if (this.iMode == AbaMetaDataUser.DESIGN_MODE) {
            setProjectChangedState(false);
            electric.xml.Element xmlProject = new electric.xml.Element("Project");
            theParent.addElement(xmlProject);
            electric.xml.Element xmlName = new electric.xml.Element("Name");
            xmlName.setText(getName());
            xmlProject.addElement(xmlName);
            electric.xml.Element xmlAuthor = new electric.xml.Element("Author");
            xmlAuthor.setText(progInfo.sAuthor);
            xmlProject.addElement(xmlAuthor);

            electric.xml.Element xmlDeclVariablePrefix = new electric.xml.Element("DeclVariablePrefix");
            xmlDeclVariablePrefix.setText(getDeclVariablePrefix());
            xmlProject.addElement(xmlDeclVariablePrefix);

            if(this.getMetaDataUser().getOpenSourceState())
            {
                electric.xml.Element xmlGenCodeLookFeel = new electric.xml.Element("GeneratedCodeLookAndFeel");
                xmlGenCodeLookFeel.setText(progInfo.sGenLookFeelName==null?sGenLookFeelName:progInfo.sGenLookFeelName);
                xmlProject.addElement(xmlGenCodeLookFeel);

                electric.xml.Element xmlAdditionalImports= new electric.xml.Element("AdditionalImports");
                xmlAdditionalImports.setText(AdditionalImports);
                xmlProject.addElement(xmlAdditionalImports);
            }

            if(isNLSTranslation==false)
            {
                electric.xml.Element xmlNLSTranslationOff = new electric.xml.Element("NLSTranslationOff");
                xmlNLSTranslationOff.setText(xmlNLSTranslationOff.getTextString());
                xmlProject.addElement(xmlNLSTranslationOff);
            }

            if(bGenerateAccessor==false)
            {
                electric.xml.Element xmlGenerateAccessor = new electric.xml.Element("GenerateAccessorOff");
                xmlGenerateAccessor.setText(xmlGenerateAccessor.getTextString());
                xmlProject.addElement(xmlGenerateAccessor);
            }

            // Document version autoincrements version of document.
            electric.xml.Element xmlDocumentVersion = new electric.xml.Element("DocumentVersion");
            if ((sDocumentVersion == null) || (sDocumentVersion.trim().length() == 0))
                sDocumentVersion = "1";
            else
                sDocumentVersion = new Integer(new Integer(sDocumentVersion).intValue() + 1).toString();
            xmlDocumentVersion.setText(sDocumentVersion);
            xmlProject.addElement(xmlDocumentVersion);

            electric.xml.Element xmlHammerVersion = new electric.xml.Element("HammerVersion");
            xmlHammerVersion.setText(new Integer(theMetaDataUser.getVersionNumber()).toString());
            xmlProject.addElement(xmlHammerVersion);
            electric.xml.Element xmlHammerRevision = new electric.xml.Element("HammerRevision");
            xmlHammerRevision.setText(new Integer(theMetaDataUser.getRevisionNumber()).toString());
            xmlProject.addElement(xmlHammerRevision);
            electric.xml.Element xmlHammerSubRevision = new electric.xml.Element("HammerSubRevision");
            xmlHammerSubRevision.setText(new Integer(theMetaDataUser.getSubRevisionNumber()).toString());
            xmlProject.addElement(xmlHammerSubRevision);
            electric.xml.Element xmlHammerBuild = new electric.xml.Element("HammerBuild");
            xmlHammerBuild.setText(new Integer(theMetaDataUser.getBuildNumber()).toString());
            xmlProject.addElement(xmlHammerBuild);

            electric.xml.Element xmlRendererVersion = new electric.xml.Element("RendererVersion");
            xmlRendererVersion.setText(sRendererVersion);
            xmlProject.addElement(xmlRendererVersion);
            // Metadata version is used to allow automatic updates.
            electric.xml.Element xmlMetadataVersion = new electric.xml.Element("MetadataVersion");
            electric.xml.Element xmlMetadataVersionNumber = new electric.xml.Element("MetadataVersionNumber");
            electric.xml.Element xmlMetadataRevisionNumber = new electric.xml.Element("MetadataRevisionNumber");
            electric.xml.Element xmlMetadataSubrevisionNumber = new electric.xml.Element("MetadataSubrevisionNumber");
            electric.xml.Element xmlMetadataBuildNumber = new electric.xml.Element("MetadataBuildNumber");
            if (theMetaDataAdministrator != null) {
                xmlMetadataVersionNumber.setText(new Integer(theMetaDataAdministrator.iVersionNumber).toString());
                xmlMetadataRevisionNumber.setText(new Integer(theMetaDataAdministrator.iRevisionNumber).toString());
                xmlMetadataSubrevisionNumber.setText(new Integer(theMetaDataAdministrator.iSubrevisionNumber).toString());
                xmlMetadataBuildNumber.setText(new Integer(theMetaDataAdministrator.iBuildNumber).toString());
            } else {
                xmlMetadataVersionNumber.setText(new Integer(iMetadataVersion).toString());
                xmlMetadataRevisionNumber.setText(new Integer(iMetadataRevision).toString());
                xmlMetadataSubrevisionNumber.setText(new Integer(iMetadataSubrevision).toString());
                xmlMetadataBuildNumber.setText(new Integer(iMetadataBuild).toString());
            }
            xmlMetadataVersion.addElement(xmlMetadataVersionNumber);
            xmlMetadataVersion.addElement(xmlMetadataRevisionNumber);
            xmlMetadataVersion.addElement(xmlMetadataSubrevisionNumber);
            xmlMetadataVersion.addElement(xmlMetadataBuildNumber);
            xmlProject.addElement(xmlMetadataVersion);

            Date dRightNow = new Date();
            SimpleDateFormat abaDateFormat = new SimpleDateFormat("E yyyy.MM.dd hh:mm:ss a zzz");
            electric.xml.Element xmlTimeStamp = new electric.xml.Element("TimeStamp");
            xmlTimeStamp.setText(abaDateFormat.format(dRightNow));
            xmlProject.addElement(xmlTimeStamp);

            // Process the languages.
            HammerLanguagePresentation theLanguage = theFirstLanguage;
            if (theLanguage == null) {
                theLanguage = new HammerLanguagePresentation(HammerLanguagePresentation.DEFAULT, this);
                electric.xml.Element xmlLanguage = new electric.xml.Element("Language");
                xmlProject.addElement(xmlLanguage);
                xmlLanguage.setAttribute("Name", new Integer(theLanguage.theLanguage).toString());
            } else
                while (theLanguage != null) {
                    theLanguage.save(xmlProject);
                    theLanguage = theLanguage.theNextLanguage;
                }


            // Load nls document descriptions
            if ((this.theLocalNLSDocuments != null) && (this.theLocalNLSDocuments.size() > 0)) {
                electric.xml.Element xmlLocalNLSDocs = new electric.xml.Element("LocalNLSDocuments");
                if (xmlLocalNLSDocs != null) {
                    for (int i = 0; i < this.theLocalNLSDocuments.size(); i++) {
                        HammerNLSAccess theAccess = (HammerNLSAccess) theLocalNLSDocuments.get(i);
                        electric.xml.Element xmlLocalNLSDoc = new electric.xml.Element("LocalNLSDocument");
                        electric.xml.Element xmlDocKey = new electric.xml.Element("Key");
                        electric.xml.Element xmlDocPath = new electric.xml.Element("Path");
                        xmlDocKey.setText(theAccess.sKey);
                        xmlDocPath.setText(theAccess.sDocument);
                        xmlLocalNLSDoc.addElement(xmlDocKey);
                        xmlLocalNLSDoc.addElement(xmlDocPath);
                        xmlLocalNLSDocs.addElement(xmlLocalNLSDoc);
                    }
                }
                xmlProject.addElement(xmlLocalNLSDocs);
            }

            MetaObject theObject = theFirstObject;
            while (theObject != null) {
                theObject.save(xmlProject);
                theObject = theObject.theNextObject;
            }
        }
        return true;

    }


    public boolean load(electric.xml.Element theElement) {
        electric.xml.Element xmlName = theElement.getElement("Name");
        sName = xmlName.getTextString();
        electric.xml.Element xmlAuthor = theElement.getElement("Author");
        sAuthor = xmlAuthor.getTextString();
        if(this.getMetaDataUser().getOpenSourceState())
        {
            electric.xml.Element xmlGenCodeLAF = theElement.getElement("GeneratedCodeLookAndFeel");
            if(xmlGenCodeLAF!=null)
                sGenLookFeelName = xmlGenCodeLAF.getTextString();

            electric.xml.Element xmlAdditionalImports= theElement.getElement("AdditionalImports");
            if (xmlAdditionalImports != null)
                AdditionalImports=xmlAdditionalImports.getTextString();
            if(AdditionalImports==null)
                AdditionalImports = new String();
        }
        electric.xml.Element xmlNLSTranslationOff = theElement.getElement("NLSTranslationOff");
        if (xmlNLSTranslationOff != null)
        {
                isNLSTranslation=false;
        }

        electric.xml.Element xmlGenerateAccessorOff = theElement.getElement("GenerateAccessorOff");
        if (xmlGenerateAccessorOff!= null)
        {
                bGenerateAccessor=false;
        }

        electric.xml.Element xmlDeclVariablePrefix = theElement.getElement("DeclVariablePrefix");
        if (xmlDeclVariablePrefix != null)
            setDeclVariablePrefix(xmlDeclVariablePrefix.getTextString());


        electric.xml.Element xmlDocumentVersion = theElement.getElement("DocumentVersion");
        sDocumentVersion = xmlDocumentVersion.getTextString();
        electric.xml.Element xmlHammerVersion = theElement.getElement("HammerVersion");
        if (xmlHammerVersion != null)
            sHammerVersion = xmlHammerVersion.getTextString();
        electric.xml.Element xmlHammerRevision = theElement.getElement("HammerRevision");
        if (xmlHammerRevision != null)
            sHammerRevision = xmlHammerRevision.getTextString();
        electric.xml.Element xmlHammerSubRevision = theElement.getElement("HammerSubRevision");
        if (xmlHammerSubRevision != null)
            sHammerSubRevision = xmlHammerSubRevision.getTextString();
        electric.xml.Element xmlHammerBuild = theElement.getElement("HammerBuild");
        if (xmlHammerBuild != null)
            sHammerBuild = xmlHammerBuild.getTextString();
        lHammerVersionFactor = calculateProjectFactor(sHammerVersion, sHammerRevision, sHammerSubRevision);
        electric.xml.Element xmlRendererVersion = theElement.getElement("RendererVersion");
        sRendererVersion = xmlRendererVersion.getTextString();
        electric.xml.Element xmlMetadataVersion = theElement.getElement("MetadataVersion");
        if (xmlMetadataVersion != null) {
            electric.xml.Element xmlMetadataVersionNumber = xmlMetadataVersion.getElement("MetadataVersionNumber");
            electric.xml.Element xmlMetadataRevisionNumber = xmlMetadataVersion.getElement("MetadataRevisionNumber");
            electric.xml.Element xmlMetadataSubrevisionNumber = xmlMetadataVersion.getElement("MetadataSubrevisionNumber");
            electric.xml.Element xmlMetadataBuildNumber = xmlMetadataVersion.getElement("MetadataBuildNumber");
            iMetadataRevision = new Integer(xmlMetadataRevisionNumber.getTextString()).intValue();
            iMetadataSubrevision = new Integer(xmlMetadataSubrevisionNumber.getTextString()).intValue();
            iMetadataBuild = new Integer(xmlMetadataBuildNumber.getTextString()).intValue();
            iMetadataVersion = new Integer(xmlMetadataVersionNumber.getTextString()).intValue();
        }
        // Process the languages.
        electric.xml.Elements xmlLanguages = theElement.getElements("Language");
        electric.xml.Element xmlLanguage = xmlLanguages.next();
        // The Default Language is already created when the project is made.
        while (xmlLanguage != null) {
            // Set to defaults.
            int iLanguage = HammerLanguagePresentation.DEFAULT;
            HammerLanguagePresentation theLanguage = theFirstLanguage;
            // See if this is a different language.
            String theAttribute = xmlLanguage.getAttribute("Name");
            try {
                Integer theValue = new Integer(theAttribute);
                iLanguage = theValue.intValue();
            } catch (java.lang.NumberFormatException e1) {
            }
            if (iLanguage != HammerLanguagePresentation.DEFAULT)
                theLanguage = new HammerLanguagePresentation();
            theLanguage.theDesignProject = this;
            theLanguage.load(xmlLanguage);
            if (theLanguage.theLanguage != HammerLanguagePresentation.DEFAULT)
                addLanguage(theLanguage);
            xmlLanguage = xmlLanguages.next();
        }
        theCurrentLanguage = theFirstLanguage;

        // Load nls document descriptions
        electric.xml.Element xmlLocalNLSDocs = theElement.getElement("LocalNLSDocuments");
        if (xmlLocalNLSDocs != null) {
            electric.xml.Elements theConfigurationElements = xmlLocalNLSDocs.getElements("LocalNLSDocument");
            electric.xml.Element theNLSPath;
            for (int i = 0; i < theConfigurationElements.size(); i++) {
                theNLSPath = theConfigurationElements.next();
                electric.xml.Element xmlNLSDocumentKey = theNLSPath.getElement("Key");
                electric.xml.Element xmlNLSDocumentPath = theNLSPath.getElement("Path");
                String sDocumentKey = xmlNLSDocumentKey.getTextString();
                String sDocumentPath = xmlNLSDocumentPath.getTextString();
                HammerNLSAccess theNLSDoc = new HammerNLSAccess(sDocumentKey, sDocumentPath);
                this.theLocalNLSDocuments.add(theNLSDoc);
            }
        }
        electric.xml.Elements theObjects = theElement.getElements("Object");
        electric.xml.Element theObject = theObjects.next();
        while (theObject != null) {
            MetaObject theNewObject = new MetaObject();
            theNewObject.theDesignProject = this;
            boolean bTestLoadObject = theNewObject.load(theObject);
            if (bTestLoadObject)
                addObject(theNewObject);
            else
                getMetaDataUser().getLogFile().doLogEntry("Fatal Error:", "Cannot load Object " + theNewObject.getName());
            theObject = theObjects.next();
        }
        if (theMetaDataAdministrator != null) {
            int iChangeCount = theMetaDataAdministrator.getChangeCount();
            // show changes
            for (int iChange = 0; iChange < iChangeCount; iChange++)
                System.out.println(theMetaDataAdministrator.getChangeDescription(iChange));
            // ask if they want to do changes.

        }
        if (theMetaDataAdministrator != null)
            theMetaDataAdministrator.applyChanges();
        setProjectChangedState(false);
        return true;
    }

    static public long calculateProjectFactor(String sHammerVersion, String sHammerRevision, String sHammerSubRevision) {
        long lRetVal = 0;
        if (sHammerVersion != null) {
            Integer iHammerVersion = new Integer(sHammerVersion);
            lRetVal += (iHammerVersion.intValue() * 65536);  // no more than 256 revisions before version change
        }
        if (sHammerRevision != null) {
            Integer iHammerRevision = new Integer(sHammerRevision);
            lRetVal += (iHammerRevision.intValue() * 256);  // no more than 256 subrevisions before revision change
        }
        if (sHammerSubRevision != null) {
            Integer iHammerSubRevision = new Integer(sHammerSubRevision);
            lRetVal += (iHammerSubRevision.intValue());
        }
        return lRetVal;
    }

    public void setProjectChangedState(boolean bState) {
        if (bState != bChanged) {
            bChanged = bState;
            theMetaDataUser.processProjectChangedState(bState);
        }
    }

    public boolean getProjectChangedState() {
        return bChanged;
    }

    public void addObject(MetaObject theNewObject) {
        if (theFirstObject == null)
            theFirstObject = theNewObject;
        else {
            theNewObject.thePreviousObject = theLastObject;
            theLastObject.theNextObject = theNewObject;
        }
        theLastObject = theNewObject;
    }

    public boolean loadResource(String sResource, InputStream inputStream, boolean bTryNew) throws HammerException {
        // input stream is of a proz file.
        BufferedReader theReader = null;
        try {
            if (sResource.endsWith("proz")) {
                // get the class name by itself
                String sClassName = getRenderingClassName(sResource);
                // get the component to load - try the class first.
                CompressedProjectDocument storage = new CompressedProjectDocument(this);
                if (bTryNew)
                    try {
                        // First if we are rendering check for class.
                        if (this.theMetaDataUser instanceof AbaRenderer) {
                            if (storage.readRenderingClass(inputStream, sClassName) != null) {
                                setInputType(MetaProject.FROM_CLASS);

                                //ALEX: Small debug output
                                System.out.println( "***********AbaRenderer will be rendering from compiled class");
                                System.out.flush ();

                                return true;  // class is set in project
                            }
                        }
                        storage.open(inputStream);
                        byte[] bytesProj = storage.readProjSource();
                        if (bytesProj != null) {
                            ByteArrayInputStream is = new ByteArrayInputStream(bytesProj);
                            InputStreamReader rin = new InputStreamReader(is, "UTF8");
                            theReader = new BufferedReader(rin);
                        }
                    } catch (HammerException e1) {
                        // old type of file.
                        return false;  // mark/reset not supported here - need to start over.
                    }
                else {
                    // old type of file.
                    GZIPInputStream fzip = new GZIPInputStream(inputStream);
                    InputStreamReader rin = new InputStreamReader(fzip, "UTF8");
                    theReader = new BufferedReader(rin);
                }
            } else {  // from a project file.
                InputStreamReader rin = new InputStreamReader(inputStream, "UTF8");
                theReader = new BufferedReader(rin);
            }

            //   Load it as an XML document.
            //ALEX: Small debug output
                                System.out.println( "***********AbaRenderer will be rendering from XML");
                                System.out.flush ();

            xmlProjectDocument = new electric.xml.Document(theReader);

        } catch (electric.xml.ParseException e1) {
            throw new HammerException(HammerException.BAD_XML_IN_PROJ, sResource + " contains bad XML and cannot be parsed.");
        } catch (java.io.IOException e3) {
            throw new HammerException(HammerException.CANNOT_READ_PROJ, sResource + " caused file input error.");
        }

        electric.xml.Element xmlRoot = xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            electric.xml.Element xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (load(xmlProject) == true) {
                    setInputType(MetaProject.FROM_RESOURCE);
                    return true;
                } else
                    return false;
            } else
                return false;
        } else
            return false;

    }


    InputStream getResourceInputStream(String sResource) throws HammerException {
        InputStream inputStream = null;
        if (iMode == AbaMetaDataUser.EXECUTION_MODE) {
            inputStream = theMetaDataUser.getClassLoader().getLoader().getResourceAsStream(sResource);
        } else if (iMode == AbaMetaDataUser.DESIGN_MODE) {
            HammerJarAccess theJarAccess = theMetaDataUser.getClassLoader().getLoader().getResourceAccess(sResource);
            if (theJarAccess != null) {
                inputStream = theMetaDataUser.getClassLoader().getLoader().getResourceAsStream(theJarAccess);
                this.theJarAccess = theJarAccess;
            } else
                this.theJarAccess = null;
        } else
            return null;
        return inputStream;
    }

    public boolean loadResource(String sResource) throws HammerException {
        setInputType(MetaProject.UNDEFINED_INPUT_TYPE);
        if (sResource == null)
            return false;
        xmlProjectDocument = null;

        InputStream inputStream = getResourceInputStream(sResource);
        if (inputStream == null)
            return false;

        boolean b = loadResource(sResource, inputStream, true);

        if (b == false) {
            try {
                inputStream.close();
            } catch (IOException e1) {
                throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Cannot close intermediate input stream.");
            }
            inputStream = getResourceInputStream(sResource);
            if (inputStream == null)
                return false;
            b = loadResource(sResource, inputStream, false);
        }
        return b;
    }

    public boolean loadProzBuffer(String _Classname, byte[] _Buffer) throws HammerException {
        setInputType(MetaProject.UNDEFINED_INPUT_TYPE);
        if (_Buffer == null)
            return false;

        InputStream inputStream = new ByteArrayInputStream(_Buffer);
        if (inputStream == null)
            return false;

        return loadResource(_Classname, inputStream, true);
    }

    public boolean loadXML(String sData) {
        setInputType(MetaProject.UNDEFINED_INPUT_TYPE);
        if (sData == null)
            return false;
        xmlProjectDocument = null;
        try {
            StringReader inputData = new StringReader(sData);
            BufferedReader theReader = new BufferedReader(inputData);
            //   Load it as an XML document.

            xmlProjectDocument = new electric.xml.Document(theReader);
        } catch (electric.xml.ParseException e1) {
            e1.printStackTrace();
            return false;
        }

        electric.xml.Element xmlRoot = xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            electric.xml.Element xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (load(xmlProject) == true) {
                    setInputType(MetaProject.FROM_STRING);
                    return true;
                } else
                    return false;
            } else
                return false;
        } else
            return false;

    }

    public boolean load(HammerJarAccess theJarAccess) {
        setInputType(MetaProject.UNDEFINED_INPUT_TYPE);
        if (theJarAccess == null)
            return true;
        xmlProjectDocument = null;
        this.theJarAccess = theJarAccess;
        boolean bTest = false;
        try {
            InputStream fin = theJarAccess.theJarFile.getInputStream(theJarAccess.theJarEntry);
            bTest = loadResource(theJarAccess.theJarEntry.getName(), fin, true);
            if (bTest == false) {
                fin.close();
                fin = theJarAccess.theJarFile.getInputStream(theJarAccess.theJarEntry);
                bTest = loadResource(theJarAccess.theJarEntry.getName(), fin, false);
            }
        } catch (HammerException e1) {
            return false;
        } catch (java.io.IOException e2) {
            return false;
        }
        return bTest;
    }


    public boolean load(String sProjectDocument) {
        File fileInput;
        setInputType(MetaProject.UNDEFINED_INPUT_TYPE);
        if (sProjectDocument == null)
            return true;
        if (sProjectDocument.equals ( "") )
            return true;
        xmlProjectDocument = null;

        try {
            fileInput = new File(sProjectDocument);
            FileInputStream fin = new FileInputStream(fileInput);
            String sFullPath = fileInput.getCanonicalPath();
            String sSeparator = System.getProperty("file.separator");
            int iSeparator = sFullPath.lastIndexOf(sSeparator);
            if (iSeparator != -1) {
                String sDirectoryName = sFullPath.substring(0, iSeparator + 1);
                setProjectDirectory(sDirectoryName);
            }
            BufferedReader theReader = null;
            boolean isOpenSource = this.getMetaDataUser().getOpenSourceState();
            if (sProjectDocument.endsWith("proz") || (isOpenSource == true && iMode == AbaMetaDataUser.EXECUTION_MODE)) {
            // MHC
                String sClassName = getRenderingClassName(sProjectDocument);
                // get the component to load - try the class first.
                CompressedProjectDocument storage = new CompressedProjectDocument(this);
                try {  // This is the new file format.
                    // First if we are rendering check for class.
                    if (this.theMetaDataUser instanceof AbaRenderer) {
                        if (storage.readRenderingClass(fin, sClassName) != null) {
                            setInputType(MetaProject.FROM_CLASS);
                            return true;  // class is set in project
                        }
                    }
                    storage.open(fin);
                    byte[] bytesProj = storage.readProjSource();
                    if (bytesProj != null) {
                        ByteArrayInputStream is = new ByteArrayInputStream(bytesProj);
                        InputStreamReader rin = new InputStreamReader(is, "UTF8");
                        theReader = new BufferedReader(rin);
                    }
                    storage.close();
                }  // This is the old file format.
                catch (HammerException e1) {
                    // old type of file.
                    fin.close();
                    // mark/reset is not supported!
                    fin = new FileInputStream(fileInput);
                    GZIPInputStream fzip = new GZIPInputStream(fin);
                    InputStreamReader rin = new InputStreamReader(fzip);
                    theReader = new BufferedReader(rin);
                }
            } else {  // from a project file.
                InputStreamReader rin = new InputStreamReader(fin, "UTF8");
                theReader = new BufferedReader(rin);
            }
            //   Load it as an XML document.

            xmlProjectDocument = new electric.xml.Document(theReader);
        } catch (electric.xml.ParseException e1) {
            e1.printStackTrace();
            return false;
        } catch (java.io.FileNotFoundException e2) {
            return false;
        } catch (java.io.IOException e3) {
            e3.printStackTrace();

            return false;
        }

        electric.xml.Element xmlRoot = xmlProjectDocument.getRoot();
        if (xmlRoot != null) {
            electric.xml.Element xmlProject = xmlRoot.getElement("Project");
            if (xmlProject != null) {
                if (load(xmlProject) == true) {
                    resetProjectNameIfCorrupt(fileInput.getName());
                    setInputType(MetaProject.FROM_XML_DOCUMENT);
                    return true;
                } else
                    return false;
            } else
                return false;
        } else
            return false;
    }

    /**
     * The Project name in the project file should always match the filename.
     *  If not, this method will correct it. This can happen when people copy/edit the file outside of the IDE
     * @param projectName - the name of the project as defined in the project XML.
     */
    private void resetProjectNameIfCorrupt(String projectName) {
        if (projectName.equals(this.sName) == false) {
            //System.out.println("MISMATCH ON NAME! Corrected to " + projectName);
            this.sName = projectName;
        }
    }

    public void setProjectDirectory(String sDirectoryName) {
        this.sDirectoryName = sDirectoryName;
    }

    public String getProjectDirectory() {
        return sDirectoryName;
    }

    public String getGenCodeLAF() {
        return sGenLookFeelName;
    }

    public boolean isNLSCodeTranslation() {
        return isNLSTranslation;
    }

    public boolean isGenerateAccessor() {
            return bGenerateAccessor;
    }

    public void setGenCodeLAF(String pLAF) {
        sGenLookFeelName=pLAF;
    }

    public void writeDeclarations(ProjectDocument theDocumentManager) {
        MetaObject objTest = this.theFirstObject;
        while (objTest != null) {
            objTest.writeDeclarations(theDocumentManager);
            objTest = objTest.theNextObject;
        }
    }


    /**
     * setMetaDataUser - accessor method for theMetaDataUser property.  This object is the controller
     * of the project which can be either the renderer or the design cockpit.
     *
     * @param objUser
     */
    public void setMetaDataUser(AbaMetaDataUser objUser) {
        this.theMetaDataUser = objUser;
    }

    public final AbaMetaDataUser getMetaDataUser() {
        return theMetaDataUser;
    }

    public HammerLanguagePresentation getCurrentLanguage() {
        return this.theCurrentLanguage;
    }

    public boolean needsFixed() {
        if (lHammerVersionFactor < MetaProject.FIX_ORDER_IN_PARAMETERS)
            return true;
        else
            return false;
    }

    /**
     * getRenderingClassName - one method to generate the class name to render.
     *
     * @param sClassName - the name we receive from a resource or a file name.
     * @return The name of the class to render.
     */
    static public String getRenderingClassName(String sClassName) {
        int iDotMatch = sClassName.lastIndexOf(".");
        if (iDotMatch != -1)
            sClassName = sClassName.substring(0, iDotMatch);
        iDotMatch = sClassName.lastIndexOf(".");
        if (iDotMatch != -1)
            sClassName = sClassName.substring(iDotMatch + 1);
        int iPathMatch = sClassName.lastIndexOf("/");  // always forward slash in jar.
        if (iPathMatch != -1)
            sClassName = sClassName.substring(iPathMatch + 1);
        iPathMatch = sClassName.lastIndexOf("\\");  // always take backslash too.
        if (iPathMatch != -1)
            sClassName = sClassName.substring(iPathMatch + 1);

        sClassName = "AbaRenderer_" + sClassName;
        return sClassName;
    }

    /**
     * Returns an ArrayList of MetaObjects that have duplicate object names
     * @return
     */
    public ArrayList getDuplicateObjectNames() {
        if (getFirstObject() == null)
            return null;

        final ArrayList allObjects = new ArrayList();
        final ArrayList duplicateObjects = new ArrayList();
        EnumerateProjectMetaObjectInterface enumerator = new EnumerateProjectMetaObjectInterface() {
            public void callbackProjectMetaObject(MetaObject metaObject) {
                String sObjectName = metaObject.getName();
                if (allObjects.contains(sObjectName))
                    duplicateObjects.add(sObjectName);
                allObjects.add(sObjectName);
            }

        };
        enumerateObjects(enumerator, getFirstObject());
        return duplicateObjects;
    }

    public ProjectCodeGenerator getCodeGenerator() {
        return codeGenerator;
    }

    public void setCodeGenerator(ProjectCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public void setNLSTranslation(boolean NLSTranslation) {
        isNLSTranslation = NLSTranslation;
    }

    public void setGenerateAccessor(boolean bGenerateAccessor) {
        this.bGenerateAccessor = bGenerateAccessor;
    }

    /**
     * Returns the user-defined prefix for the object variables in the DECL file
     * @return the prefix
     */
    public String getDeclVariablePrefix () {
        return declVariablePrefix;
    }

    /**
     * Sets the user-defined prefix for object variables in teh DECL file.
     * @param declVariablePrefix - the prefix to use (the deault is "")
     */
    public void setDeclVariablePrefix (String declVariablePrefix) {
        this.declVariablePrefix = declVariablePrefix;
    }

    public int getGenCodeLookFeel(String sPLAF) {
        if(sPLAF==null)  // Sanity check
            return DEFAULT_LOOK;
        if (sPLAF.equals("Default"))
            return DEFAULT_LOOK;
        if (sPLAF.equals("PlasticXPLookAndFeel"))
            return PLASTICXP_LOOK;
        if (sPLAF.equals("Plastic3DLookAndFeel"))
            return PLASTIC3D_LOOK;
        if (sPLAF.equals("PlasticLookAndFeel"))
            return PLASTIC_LOOK;
        return DEFAULT_LOOK;
     }

    public void setAdditionalImports(String imports)
    {
        if(imports==null)
           AdditionalImports ="\n";
        else
            AdditionalImports = imports;
    }

    public String  getAdditionalImports()
    {
        return AdditionalImports;
    }

    public String  getRepositoryPath()
    {
        return sRepositPath;
    }

}
