/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import electric.xml.Element;
import electric.xml.Elements;

import java.util.ArrayList;
import java.util.Vector;
import java.util.Map;
import java.util.HashMap;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *
 *      {Property Declarations}
 <Property>
 <Name> Text value that denotes the data for this property.
 { Parameter Declaration }
 </Property>
 *
 */

public class MetaProperty {
    public MetaProperty theNextProperty = null;
    public MetaProperty thePreviousProperty = null;
    public ArrayList theIndexedValue = null; //new MetaParameter[1];  // supports arrays
    public String theName = "";
    boolean bAllowMultipleValues = false;
    public MetaPropertyDescriptor thePropertyInfo;
    public MetaObject theObject;

    private static HashMap ClassforName;

    public MetaProperty(String theName, MetaParameter theValue, MetaPropertyDescriptor thePropertyInfo, MetaObject theObject) {
        this.theName = theName;
        this.theIndexedValue = new ArrayList(1);
        this.theIndexedValue.add(0, theValue);
        this.thePropertyInfo = thePropertyInfo;
        this.theObject = theObject;
        if(ClassforName==null)
            ClassforName = new HashMap();
    }

//    public MetaProperty() {
//    }

    public MetaProperty(MetaPropertyDescriptor thePropertyInfo, MetaObject theObject) {
        this.theIndexedValue = new ArrayList(1);
        this.thePropertyInfo = thePropertyInfo;
        this.theObject = theObject;
        if(ClassforName==null)
            ClassforName = new HashMap();
    }

    public MetaProperty(MetaObject theObject) {
        this.theIndexedValue = new ArrayList(1);
        this.theObject = theObject;
        if(ClassforName==null)
            ClassforName = new HashMap();
    }

    public void attachToProject(MetaProject theProj) {
        int iPropertyArrayCount = this.getValueCount();
        if (iPropertyArrayCount == 0)
            iPropertyArrayCount = 1;
        for (int i = 0; i < iPropertyArrayCount; i++) {
            MetaParameter theParam = (MetaParameter) theIndexedValue.get(i);
            if (theParam != null) {
                theParam.theDesignProject = theProj;
                theParam.attachToProject(theProj);
            }
        }
    }

    public MetaProperty Clone(MetaObject theObject) {
        MetaProperty theReturnValue = new MetaProperty(theObject);
        theReturnValue.theName = this.theName;
        int iPropertyArrayCount = this.getValueCount();
        if (iPropertyArrayCount == 0)
            iPropertyArrayCount = 1;
        ArrayList theReturnValues = new ArrayList(iPropertyArrayCount);
        for (int i = 0; i < iPropertyArrayCount; i++) {
            if (theIndexedValue.get(i) != null)
                theReturnValues.add(i, ((MetaParameter) theIndexedValue.get(i)).Clone());
        }
        theReturnValue.theIndexedValue = theReturnValues;
        theReturnValue.bAllowMultipleValues = bAllowMultipleValues;
        return theReturnValue;
    }

    public boolean save(MetaProject theProject, Element theParent) {
        // create the property element.
        // Discriminate on default value for single value things.
        if (theIndexedValue.size() == 1) {
            String sTestValue = this.getLiteralValue(0);
            MetaPropertyDescriptor thePropDetail = theObject.theClass.getProperty(theName, true);
            if (thePropDetail != null) { // skip fake properties like attached.
                String sTestDefaultValue = thePropDetail.getDefaultValue();
                String sConciseValue = thePropDetail.getConciseValue(theProject, sTestValue);
                if (sConciseValue.equals(sTestDefaultValue))
                    return true;
                // we will do one level only for now.
                if (thePropDetail.theFirstSubproperty != null) {
                    MetaProperty theDefaultPropertyValue = theObject.theClass.getDefaultProperty(theName);
                    if (theDefaultPropertyValue!=null) {
                        sTestDefaultValue = theDefaultPropertyValue.getLiteralValue(0);
                        if (sTestDefaultValue.equals(sTestValue))
                            return true;
                    }
                    else
                        System.out.println("EXCEPTION!");
                }
            }
        }
        Element theMetaProperty = new Element("Property");
        Element xmlName = new Element("Name");
        xmlName.setText(theName);
        theMetaProperty.addElement(xmlName);
        theParent.addElement(theMetaProperty);
        if (bAllowMultipleValues) {
            theMetaProperty.addElement(new Element("Array"));
        }
        // add node for parameter.
        for (int i = 0; i < theIndexedValue.size(); i++) {
            ((MetaParameter) (theIndexedValue.get(i))).save(theMetaProperty);
        }
        return true;
    }

    public boolean load(Element theElement, MetaProject theDesignProject, MetaClass theClass) {
        Element xmlName = theElement.getElement("Name");
        theName = xmlName.getTextString();
        boolean bMnemonic = false;
        if (theName.equals("Mnemonic"))
            bMnemonic = true;
        Element xmlArray = theElement.getElement("Array");
        if (xmlArray != null)
            bAllowMultipleValues = true;
        Elements xmlValues = theElement.getElements("Parameter");
        if (theClass == null)
            return false;
        thePropertyInfo = theClass.getProperty(theName, true);
        int i = 0;
        theIndexedValue = new ArrayList(1);
        Element xmlValue = xmlValues.next();
        while (xmlValue != null) {
            if (theIndexedValue != null) {
                MetaParameter theParameter = new MetaParameter();
                theParameter.theDesignProject = theDesignProject;
                theParameter.load(xmlValue, i);
                if (bMnemonic)
                    theParameter.setMnemonic();
                theIndexedValue.add(i++, theParameter);
            } else
                System.out.println("Missing Value element for property " + theName);
            xmlValue = xmlValues.next();
        }
        return true;
    }

    public Object[] Create() {
        Object[] retVal = new Object[theIndexedValue.size()];
        for (int i = 0; i < theIndexedValue.size(); i++) {
            MetaParameter theParam = (MetaParameter) theIndexedValue.get(i);
            retVal[i] = theParam.Create();
            if (retVal[i] instanceof MetaPropertyValueEx) {
                MetaPropertyValueEx theValue = (MetaPropertyValueEx) retVal[i];
                theValue.setResolveAsObject(theParam.bObjectReference);
                try {
                    if(ClassforName.containsKey(theParam.theSimpleType))
                        theValue.objectClass = (Class)ClassforName.get(theParam.theSimpleType);
                    else
                    {
                        theValue.objectClass = Class.forName(theParam.theSimpleType);  // MHC
                        ClassforName.put(theParam.theSimpleType,theValue.objectClass);
                    }
                } catch (Exception e) {
                    theValue.objectClass = null;
                    ClassforName.put(theParam.theSimpleType,null);
                }
            }
        }
        return retVal;
    }

    public int getValueCount() {
        return theIndexedValue.size();
    }

    public boolean addParameter(int iOrder, int iArrayLink, String sParameterName, String sType,
                                Object aValue, MetaProject theDesignProject,
                                boolean bAllowMultipleLanguages, boolean bObjectReference) {
        MetaParameter theNewParameter = new MetaParameter(iOrder, new MetaPropertyValueEx(sType, aValue.toString(), theDesignProject, bAllowMultipleLanguages), sParameterName,
                theDesignProject, bAllowMultipleLanguages, bObjectReference);
        MetaParameter theTestParameter = (MetaParameter) theIndexedValue.get(iArrayLink);
        MetaParameter theLastParameter = null;
        while (theTestParameter != null) {
            theLastParameter = theTestParameter;
            theTestParameter = theTestParameter.theNextParameter;
        }
        if (theLastParameter != null) {
            theNewParameter.thePreviousParameter = theLastParameter;
            theLastParameter.theNextParameter = theNewParameter;
        } else
            theIndexedValue.add(iArrayLink, theNewParameter);
        return true;
    }

    public Class getParameterClass() {
            MetaParameter theMetaParameter = (MetaParameter) theIndexedValue.get(0);
            if (theMetaParameter == null)
                return null;
            try {
                try {
                    if(ClassforName.containsKey(theMetaParameter.theSimpleType))
                    {
                        Class rtClass = (Class) ClassforName.get(theMetaParameter.theSimpleType);
                        if(rtClass!=null)
                            return rtClass;
                        else
                        {
                            rtClass = (Class) Class.forName("java.lang." + theMetaParameter.theSimpleType);
                            ClassforName.put(theMetaParameter.theSimpleType,rtClass);
                            return rtClass;
                        }
                    }
                    else
                    {
                        Class rtClass = (Class) Class.forName(theMetaParameter.theSimpleType);
                        ClassforName.put(theMetaParameter.theSimpleType,rtClass);
                        return rtClass;
                    }
                } catch (ClassNotFoundException e1) {
                    Class rtClass = (Class) Class.forName("java.lang." + theMetaParameter.theSimpleType);
                    ClassforName.put("java.lang." + theMetaParameter.theSimpleType,rtClass);
                    return rtClass;
                }
            } catch (ClassNotFoundException e1) {
                try {
                    if (theMetaParameter.theSimpleType.equals("Color"))
                    {
                        if(ClassforName.containsKey("java.awt.Color"))
                        {
                            Class rtClass = (Class) ClassforName.get(("java.awt.Color"));
                            return rtClass;
                        }
                        else
                        {
                            Class rtClass = (Class) Class.forName("java.awt.Color");
                            ClassforName.put("java.awt.Color",rtClass);
                            return rtClass;
                        }
                    }
                    else if (theMetaParameter.theSimpleType.equals("Font"))
                    {
                        if(ClassforName.containsKey("java.awt.Font"))
                        {
                            Class rtClass = (Class) ClassforName.get(("java.awt.Font"));
                            return rtClass;
                        }
                        else
                        {
                            Class rtClass = (Class) Class.forName("java.awt.Font");
                            ClassforName.put("java.awt.Font",rtClass);
                            return rtClass;
                        }
                    }
                } catch (Exception e2) {
                    return null;
                }
                return null;
            }
        }

    public String getLiteralValue(int iItem) {
        String sValue = null;
        MetaParameter theParameter = (MetaParameter) theIndexedValue.get(iItem);
        while (theParameter != null) {
            if (sValue == null)
                sValue = "";
            else
                sValue = sValue + ",";
            sValue = sValue + theParameter.getLiteralValue();
            theParameter = theParameter.theNextParameter;
        }
        return sValue;
    }


}