/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 9, 2003
 * Time: 11:48:55 AM
 * To change this template use Options | File Templates.
 */
public class MetadataChange {

    int iChangeType = 0;
    static final int CLASS_ADDED = 1;
    // Remedy - none. It's ok.
    static final int PROPERTY_ADDED = 2;
    // Remedy - none. It's ok. New objects will gain new property default value.
    static final int CLASS_REMOVED = 3;
    // Remedy - Objects with this class are changed to a class that must be changed
    // in the project file.
    static final int PROPERTY_REMOVED = 4;
    // Remedy - Objects with this property remove this property.
    static final int CLASS_NAME_CHANGED = 5;
    // Remedy - Objects with the class that changed names get their class name automatically changed.
    static final int PROPERTY_NAME_CHANGED = 6;
    // Remedy - Objects with the property that changed names have their property name automatically changed.
    static final int CLASS_INFORMATION_CHANGED = 7;
    // Remedy - Objects with the type, factory name, or long type name have their definitions changed accordingly.
    static final int DEFAULT_VALUE_CHANGED = 8;
    // Remedy - none - it should just work.
    static final int CONSTANT_DEFINITION_ADDED = 9;
    // Remedy - none - the new constant can be added and used.
    static final int CONSTANT_DEFINITION_REMOVED = 10;
    // Remedy - none - there may be an error translating the constant value.  It may
    // appear untranslated.
    static final int CONSTANT_DEFINITION_CHANGED = 11;
    // Remedy - Objects that use this constant will have the value automatically changed.

    static final int PROPERTY_TYPE_CHANGED = 12;


    String sOldClassName;
    String sOldPropertyName;
    String sOldTypeName;
    String sOldTypeLongName;
    String sOldFactoryName;
    String sOldConstant;
    String sOldValue;
    String sOldConstantGroup;
    String sOldPropertyType;
    String sNewClassName;
    String sNewPropertyName;
    String sNewTypeName;
    String sNewTypeLongName;
    String sNewFactoryName;
    String sNewConstant;
    String sNewValue;
    String sNewConstantGroup;
    String sNewPropertyType;

    public MetadataChange(int iChangeType) {
        this.iChangeType = iChangeType;
    }

    public static MetadataChange createClassAdditionTrace(String sNewClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CLASS_ADDED);
        theMetaDataChange.sNewClassName = sNewClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyAdditionTrace(String sNewPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.PROPERTY_ADDED);
        theMetaDataChange.sNewPropertyName = sNewPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createClassRemovalTrace(String sOldClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CLASS_REMOVED);
        theMetaDataChange.sOldClassName = sOldClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyRemovalTrace(String sOldPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.PROPERTY_REMOVED);
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createClassNameChangedTrace(String sOldClassName, String sNewClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CLASS_NAME_CHANGED);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sNewClassName = sNewClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyNameChangedTrace(String sClassName, String sPropertyName, String sOldPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.PROPERTY_NAME_CHANGED);
        theMetaDataChange.sOldClassName = sClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sNewPropertyName = sPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyTypeChangedTrace(String sOldClassName, String sOldPropertyName, String sOldType, String sNewType) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.DEFAULT_VALUE_CHANGED);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sOldPropertyType = sOldType;
        theMetaDataChange.sNewPropertyType = sNewType;
        return theMetaDataChange;
    }

    public static MetadataChange createClassInformationChangedTrace(
            String sNewFactoryName, String sNewTypeName, String sNewTypeLongName,
            String sOldFactoryName, String sOldTypeName, String sOldTypeLongName) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CLASS_INFORMATION_CHANGED);
        theMetaDataChange.sNewFactoryName = sNewFactoryName;
        theMetaDataChange.sNewTypeName = sNewTypeName;
        theMetaDataChange.sNewTypeLongName = sNewTypeLongName;
        theMetaDataChange.sOldFactoryName = sOldFactoryName;
        theMetaDataChange.sOldTypeName = sOldTypeName;
        theMetaDataChange.sOldTypeLongName = sOldTypeLongName;
        return theMetaDataChange;
    }

    public static MetadataChange createDefaultValueChangedTrace(String sOldClassName, String sOldPropertyName, String sOldValue, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.DEFAULT_VALUE_CHANGED);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sOldValue = sOldValue;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public static MetadataChange createConstantDefinitonAdditionTrace(String sNewConstantGroup, String sNewConstant, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CONSTANT_DEFINITION_ADDED);
        theMetaDataChange.sNewConstantGroup = sNewConstantGroup;
        theMetaDataChange.sNewConstant = sNewConstant;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public static MetadataChange createConstantDefinitonRemovalTrace(String sOldConstantGroup, String sOldConstant, String sOldValue) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CONSTANT_DEFINITION_REMOVED);
        theMetaDataChange.sOldConstantGroup = sOldConstantGroup;
        theMetaDataChange.sOldConstant = sOldConstant;
        theMetaDataChange.sOldValue = sOldValue;
        return theMetaDataChange;
    }


    public static MetadataChange createConstantDefinitonRemovalTrace(String sOldConstantGroup, String sOldConstant, String sOldValue, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(MetadataChange.CONSTANT_DEFINITION_CHANGED);
        theMetaDataChange.sOldConstantGroup = sOldConstantGroup;
        theMetaDataChange.sOldConstant = sOldConstant;
        theMetaDataChange.sOldValue = sOldValue;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public String getDescription() {
        switch (iChangeType) {
            case MetadataChange.CLASS_ADDED:
                return "Adding class " + sNewClassName;
            case MetadataChange.CLASS_INFORMATION_CHANGED:
                return "Changed class information for " + sOldClassName;
            case MetadataChange.CLASS_NAME_CHANGED:
                return "Changed class name from " + sOldClassName + " to " + sNewClassName;
            case MetadataChange.CLASS_REMOVED:
                return "Removed class " + sOldClassName;
            case MetadataChange.CONSTANT_DEFINITION_ADDED:
                return "Added constant definition " + sNewConstant + " to " + sNewConstantGroup;
            case MetadataChange.CONSTANT_DEFINITION_CHANGED:
                return "Changed constant definition of " + sOldConstant + " of " + sOldConstantGroup;
            case MetadataChange.CONSTANT_DEFINITION_REMOVED:
                return "Removed constant definition of " + sOldConstant + " from " + sOldConstantGroup;
            case MetadataChange.PROPERTY_ADDED:
                return "Added property " + sNewPropertyName + " to " + sNewClassName;
            case MetadataChange.PROPERTY_NAME_CHANGED:
                return "Changed the property name of class " + sOldClassName + " from " +
                        sOldPropertyName + " to " + sNewPropertyName;
            case MetadataChange.PROPERTY_REMOVED:
                return "Removed property " + sOldPropertyName;
            case MetadataChange.PROPERTY_TYPE_CHANGED:
                return "Changed property type of property " + sOldPropertyName + " from " +
                        sOldPropertyType + " to " + sNewPropertyType;
            default:
                return "I don't know what changed!";
        }
    }


}
