/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Aug 2, 2004
 * Time: 12:27:49 AM
 */
package ch.abacus.lib.ui.renderer.common.generator;

import ch.abacus.lib.ui.renderer.common.*;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

/**
 *
 * We need to produce all of the classes to implement the droplets.
 *
 * classname = xxx
 *
 * UserInterface    xxxWindow
 * Protocol         xxxProtocol
 * Adapter          xxxAdapter
 * Factory          ***Factory
 *
 * Also, build.bat and a drp file.
 *
 */


public class DropletCodeGenerator implements ProjectCodeGenerator {

    ProjectDocument theDocument;
    public Vector vectorConstants = new Vector(0);
    /**
     * Variables - The key is the identifier, the value is the value of the identifier
     */
    HashMap Variables = new HashMap();
    /**
     * VariableClasses - The key is the classname, the value stored is the number of vars.
     */
    HashMap VariableClasses = new HashMap();

    BufferCollection theBufferCollection = new BufferCollection();
    HashMap theLookupTable = new HashMap();
    ListenerCollection theListenerCollection = new ListenerCollection();

    public DropletCodeGenerator(ProjectDocument theDocument) {
        this.theDocument = theDocument;
    }

    public ProjectDocument getProjectDocument() {
        return theDocument;
    }

    public void setProjectDocument(ProjectDocument theDocument) {
        this.theDocument = theDocument;
    }

    // lookup table.
    private String getValue(MetaObject theObject, String sKey) {
        sKey = theObject.getName() + "|" + sKey;
        return (String) this.theLookupTable.get(sKey);
    }

    private void setValue(MetaObject theObject, String sKey, String sValue) {
        sKey = theObject.getName() + "|" + sKey;
        theLookupTable.put(sKey, sValue);
    }

    private String getIdentifier(MetaObject theObject) {
        return getValue(theObject, "Identifier");
    }

    private void setIdentifier(MetaObject theObject, String value) {
        setValue(theObject, "Identifier", value);
    }

    private String getContainerName(MetaObject theObject) {
        return getValue(theObject, "ContainerName");
    }

    private void setContainerName(MetaObject theObject, String value) {
        setValue(theObject, "ContainerName", value);
    }

    private String getLayoutName(MetaObject theObject) {
        return getValue(theObject, "LayoutName");
    }

    private void setLayoutName(MetaObject theObject, String value) {
        setValue(theObject, "LayoutName", value);
    }

    private String getGroupName(MetaObject theObject) {
        return getValue(theObject, "GroupName");
    }

    private void setGroupName(MetaObject theObject, String value) {
        setValue(theObject, "GroupName", value);
    }

    // code generation.
    //
    // define class
    // define members
    // define object accessors
    // define constructor  (creates objects, calls property setting, calls attachment code)
    // define property setting
    // define attachment code
    //

    public void generateObjectCode(MetaObject theObject) throws HammerException {
        String sProjectName = theObject.theDesignProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        //sIdentifier = "AbaRenderer_"+ sProjectName + "_" + getName();
         if (!theObject.isFrame()&&!theObject.isAbalet()) {
            setIdentifier(theObject, theObject.getName());
            generateMember(theObject);
            generateAccessor(theObject);
            generateBuilder(theObject);
            generatePropertySettings(theObject);
            generateAttachmentCode(theObject);
        }
        else {
            generateAccessor(theObject);
            // do property settings for interior panel etc.
            generateAttachmentCode(theObject);
        }
        MetaObject objTest = theObject.theFirstChild;
        while (objTest != null) {
            generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
    }

    public void generateMember(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        String sDeclaration = "    private DropletCustomComponent " + getIdentifier(theObject) + ";";
        theBufferCollection.sDeclBuffer += sDeclaration;
        theBufferCollection.sDeclBuffer += "\r\n";
    }

    public void generateAccessor(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        if (theObject.equals(theObject.theDesignProject.getFirstObject())) {
            String sAccessorCode = "public Object getRenderingDestination() {\r\n";
            sAccessorCode += "return this.thePanel;\r\n}\r\n\r\n";
            theBufferCollection.sAccessorBuffer += sAccessorCode;
        }
        String sAccessorCode = "public DropletCustomComponent get" + theObject.getName() + "() {\r\n";
        sAccessorCode += "return " + getIdentifier(theObject) + ";\r\n}\r\n\r\n";
        theBufferCollection.sAccessorBuffer += sAccessorCode;
    }

    public void generateBuilder(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        String sBuildCode = getIdentifier(theObject) +
                " = (DropletCustomComponent) theRenderer.createInterfaceObject(\"" +
                theObject.getName() + "\", \"" +
                theObject.theClass.theMetadata.sClassName + "\");";
        theBufferCollection.sAssignmentBuffer += sBuildCode;
        theBufferCollection.sAssignmentBuffer += "\r\n";
    }

    public void generatePropertySettings(MetaObject theObject) throws HammerException {
        String sSetCode = "";
        MetaProperty theProperty = theObject.theFirstProperty;

        String metaClassName = theProperty.theObject.theType.theName;
        while (theProperty != null) {
            String sPropertySet = generatePropertyCode(theProperty);
            if (theProperty.thePropertyInfo != null) {
                String sSetMethod = theProperty.thePropertyInfo.getSetMethod();
                boolean bIsObjReference = theProperty.thePropertyInfo.bObjectReference;// MHC
                String sObjectPrefix = "";
                // TODO:  Scroll panels for Droplets.
//                if (theObject.bAutoEmbed) {
//                    sObjectPrefix = "scr_";
//                }
                if (sSetMethod.equals("setSize")) {
                    sSetCode += sObjectPrefix + getIdentifier(theObject) + ".setSize(" + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if (sSetMethod.equals("setLocation")) {
                    sSetCode += sObjectPrefix + getIdentifier(theObject) + ".setLocation(" + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if (sSetMethod.equals("setBackground")) {
                    sSetCode += sObjectPrefix + getIdentifier(theObject) + ".setBackground(" + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if (sSetMethod.equals("setForeground")) {
                    sSetCode += sObjectPrefix + getIdentifier(theObject) + ".setForeground(" + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if (sSetMethod.equals("setFont")) {
                    sSetCode += sObjectPrefix + getIdentifier(theObject) + ".setFont(" + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if ((sSetMethod != null) && (sSetMethod.length() > 0) && (bIsObjReference == false)) {
                    // last parameter is skin name - we don't use it.
                    sSetCode += getIdentifier(theObject) + ".setRemoteAttributeValue(\"" + theProperty.thePropertyInfo.getName() + "\"," + sPropertySet + ")";
                    sSetCode += ";\r\n";
                } else if ((sSetMethod != null) && (sSetMethod.length() > 0) && (bIsObjReference == true)) { // MHC
                    String sProjectName = theObject.theDesignProject.getName();
                    int iIndex = sProjectName.indexOf(".");
                    sProjectName = sProjectName.substring(0, iIndex);
                    sSetCode += getIdentifier(theObject) + ".setRemoteAttributeObjectReference(" + theProperty.thePropertyInfo.getName() + sPropertySet + ")";
                    sSetCode += ";\r\n";
                }
            }
            theProperty = theProperty.theNextProperty;
        }
        // add events.
        sSetCode = generateObjectEventClasses(sSetCode, theObject);

        theBufferCollection.sPropertyMethodBuffer += "\r\nvoid set_" + getIdentifier(theObject) + "_properties(AbaRendererInterface theRenderer) {\r\n" +
                sSetCode + "\r\n}\r\n";
        if (metaClassName.equalsIgnoreCase("JSSDataSource"))
            theBufferCollection.sPropertyBuffer = "set_" + getIdentifier(theObject) + "_properties(theRenderer);\r\n" + theBufferCollection.sPropertyBuffer;
        else
            theBufferCollection.sPropertyBuffer += "set_" + getIdentifier(theObject) + "_properties(theRenderer);\r\n";
    }


    /**
     *
     *  Droplet Code
     *
     **/


    public void generateAttachmentCode(MetaObject theObject) {
        int iContainerType = theObject.getContainerType();
        // Do layout construction for the current object.
        String sLayoutConstruction = "";
        switch (iContainerType) {
            case MetaContainerType.CONTAINER_TABBEDPANE:
                setContainerName(theObject, getIdentifier(theObject));
                break;
            case MetaContainerType.CONTAINER_BUTTONGROUP:
//                setGroupName(theObject, "grp_" + getIdentifier(theObject));
//                theBufferCollection.sDeclBuffer += "ButtonGroup " + getGroupName(theObject) + " = new ButtonGroup();";
//                setContainerName(theObject, getIdentifier(theObject));
//                setLayoutName(theObject, "lm_" + getIdentifier(theObject));
//                theBufferCollection.sDeclBuffer += "AnchoringLayoutManager " + getLayoutName(theObject) + " = new AnchoringLayoutManager();" + "\r\n";
//                sLayoutConstruction += getContainerName(theObject) + ".setLayout(" + getLayoutName(theObject) + ");\r\n";
                break;
            case MetaContainerType.CONTAINER_TABPAGE:
            case MetaContainerType.CONTAINER_PANEL:
                setLayoutName(theObject, getIdentifier(theObject));
                setContainerName(theObject, getIdentifier(theObject));
                break;
            case MetaContainerType.CONTAINER_ABALET:
            case MetaContainerType.CONTAINER_FRAME:
                setLayoutName(theObject, "this.thePanel");
                setContainerName(theObject, "thePanel");
                sLayoutConstruction += "theRenderer.addFocus(null," + getIdentifier(theObject) + ");\r\n";
                break;
            case MetaContainerType.CONTAINER_NONE:
            case MetaContainerType.CONTAINER_SCROLLPANE:
                break;
            case MetaContainerType.CONTAINER_HSPLIT:
            case MetaContainerType.CONTAINER_VSPLIT:
                setContainerName(theObject, getIdentifier(theObject));
                break;
            case MetaContainerType.CONTAINER_SCROLLING_PANEL:
                setContainerName(theObject, getIdentifier(theObject));
//                sLayoutConstruction += getContainerName(theObject) + ".setLayout(null);\r\n";
                break;
        }
        String sVariableToAttach = getIdentifier(theObject);
//        if (theObject.bAutoEmbed) {
        // TODO: Autoembed for droplets!!!
//            theBufferCollection.sDeclBuffer += "JAScrollPane scr_" + getIdentifier(theObject) + ";\r\n";
//            sVariableToAttach = "scr_" + getIdentifier(theObject);
//            theBufferCollection.sAssignmentBuffer += "scr_" + getIdentifier(theObject) + " = new JAScrollPane(" + getIdentifier(theObject) + ");\r\n";
//            if (iContainerType == MetaContainerType.CONTAINER_SCROLLING_PANEL)
//                theBufferCollection.sAssignmentBuffer += getIdentifier(theObject) +
//                        ".setScrollPane(scr_" + getIdentifier(theObject) + ");\r\n";
//        }
        // Do attachment.
        String sAttachmentCode = "";
        MetaObject theParentContainer = theObject.getVisualContainerObject(true);

        if (theParentContainer != null) {
            int iParentContainerType = theParentContainer.getContainerType();
            switch (iParentContainerType) {
                case MetaContainerType.CONTAINER_NONE:
                    // this should throw an exception.
                    break;
                case MetaContainerType.CONTAINER_SCROLLPANE:
                    {
                        // TODO:  Droplet scrollpane!
//                        JAScrollPane thePane = new JAScrollPane();
//                        JViewport theViewport = new JViewport();
//                        theViewport.setView(theObject.theVisualObject);
//                        thePane.setViewport(theViewport);
//                        sAttachmentCode = "JViewport vp_" + getIdentifier(theParentContainer) + "= new JViewport();\r\n";
//                        sAttachmentCode += "vp_" + getIdentifier(theParentContainer) + ".setView(" + getIdentifier(theObject) + ");\r\n";
//                        sAttachmentCode += getContainerName(theParentContainer) + ".setViewport(vp_" + getIdentifier(theParentContainer) + ");\r\n";
//                        theParentContainer = theParentContainer.getVisualContainerObject(true);
//                        sAttachmentCode += "theRenderer.addFocus(" + getIdentifier(theParentContainer) + "," + getIdentifier(theObject) + ");\r\n";
                    }
                    break;
                case MetaContainerType.CONTAINER_SCROLLING_PANEL:
                    // TODO: Droplet scrolling panel.
//                    sAttachmentCode += getContainerName(theParentContainer) + ".add(" + sVariableToAttach + ");\r\n";
//                    sAttachmentCode += "theRenderer.addFocus(" + getIdentifier(theParentContainer) + "," + sVariableToAttach + ");\r\n";
                    break;
                case MetaContainerType.CONTAINER_BUTTONGROUP:
                    // TODO: Droplet Buttongroup
//                    sAttachmentCode = "if (" + getIdentifier(theObject) + " instanceof JRadioButton)\r\n";
//                    sAttachmentCode = getGroupName(theParentContainer) + ".add(" + getIdentifier(theObject) + ");\r\n";
//                    theParentContainer = theParentContainer.getVisualContainerObject(true);
                    // no break!
                case MetaContainerType.CONTAINER_PANEL:
                case MetaContainerType.CONTAINER_TABPAGE:
                case MetaContainerType.CONTAINER_ABALET:
                case MetaContainerType.CONTAINER_FRAME:
                    {
                        sAttachmentCode += getContainerName(theParentContainer) + ".addComponent(" + sVariableToAttach + ");\r\n";
                        String sAnchoringValue = "";
                        if (theObject.bLeftAnchoring)
                            sAnchoringValue += "Component.ANCHOR_WEST +";
                        if (theObject.bRightAnchoring)
                            sAnchoringValue += "Component.ANCHOR_EAST +";
                        if (theObject.bTopAnchoring)
                            sAnchoringValue += "Component.ANCHOR_TOP +";
                        if (theObject.bBottomAnchoring)
                            sAnchoringValue += "Component.ANCHOR_SOUTH +";
                        if (sAnchoringValue.length() > 0)
                            sAttachmentCode += getIdentifier(theObject) + ".setAnchor(" + sAnchoringValue + ");\r\n";
                        sAttachmentCode += "theRenderer.addFocus(" + getIdentifier(theParentContainer) + "," + sVariableToAttach + ");\r\n";
                    }
                    break;
                case MetaContainerType.CONTAINER_TABBEDPANE:
                    {
                        // TODO: Droplet Tabs
//                        int iIndex = theParentContainer.getChildIndex(theObject);
//                        MetaPropertyValueEx theTabTitle = theParentContainer.getPropertyValue("TabTitle", iIndex);
//                        String sTabTitle = "Tab " + iIndex;
//                        if (theTabTitle != null) {
//                            sTabTitle = theTabTitle.getStringValue();
//                        }
//                        sAttachmentCode += getContainerName(theParentContainer) + ".addTab(theRenderer.doNLSTranslation(\"" + sTabTitle + "\"), " + getIdentifier(theObject) + ");\r\n";
//                        sAttachmentCode += "theRenderer.addFocus(" + getIdentifier(theParentContainer) + "," + getIdentifier(theObject) + ");\r\n";
                    }
                    break;
                case MetaContainerType.CONTAINER_HSPLIT:
                    {
                        // TODO: Droplet HSPLIT
//                        if (this.equals(theParentContainer.theFirstChild))
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setLeftComponent(" + sVariableToAttach + ");\r\n";
//                        else {
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setRightComponent(" + sVariableToAttach + ");\r\n";
//                            String sDividerLocation = theParentContainer.getPropertyValue("DividerLocation", 0).getLocalString();
//                            sAttachmentCode += getContainerName(theParentContainer) + ".resetToPreferredSizes();\r\n";
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setDividerLocation(" + sDividerLocation + ");\r\n";
//                        }
                    }
                    break;
                case MetaContainerType.CONTAINER_VSPLIT:
                    {
                        // TODO: Droplet VSPLIT
//                        if (this.equals(theParentContainer.theFirstChild))
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setTopComponent(" + sVariableToAttach + ");\r\n";
//                        else {
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setBottomComponent(" + sVariableToAttach + ");\r\n";
//                            String sDividerLocation = theParentContainer.getPropertyValue("DividerLocation", 0).getLocalString();
//                            sAttachmentCode += getContainerName(theParentContainer) + ".resetToPreferredSizes();\r\n";
//                            sAttachmentCode += getContainerName(theParentContainer) + ".setDividerLocation(" + sDividerLocation + ");\r\n";
//                        }
                    }
                    break;
            }
        }
        theBufferCollection.sAssignmentBuffer += sLayoutConstruction;
        theBufferCollection.sAttachmentBuffer += sAttachmentCode;
    }

    /**
     * generateCode - This is the code generator for the optimized output option that builds java
     * programs for compilation.
     *
     */

    public void generateProjectCode(String sClassName, MetaProject theProject) throws HammerException {
        Variables = new HashMap(0);
        VariableClasses = new HashMap(0);
        vectorConstants = new Vector(0);
        generatePrologCode(theProject, sClassName);
        MetaObject objTest = theProject.getFirstObject();
        while (objTest != null) {
            generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
        generateEpilogCode(theProject);
    }

    /**
     * doImports - This method writes imports for a given class, if necessary.
     * It adds the imports to a vector that is later processed to generate code.
     *
     * @param theProject MetaProject - this is the project to generate import statements for.
     * @param theClass  MetaClass - This is the class that is being tested for imports.
     * @param vImports  Vector - These are the imports so far.
     * @return  Vector - The imports after processing.
     */
    public Vector doImports(MetaProject theProject, MetaClass theClass, Vector vImports) {
        String sSuperClass = theClass.theMetadata.sFullClassName;
//        if (theClass.theFirstObject != null) {
//            if ((sSuperClass != null) && (sSuperClass.length() > 0)) {
//                if (vImports.contains(sSuperClass) == false)
//                    vImports.add(sSuperClass);
//                try {
//                    theProject.getMetaDataUser().getClassLoader().getLoader().loadClass(sSuperClass);
//                } catch (ClassNotFoundException e) {
//                    // class not found - write the code.
//                    String sClassDefinition = "class " + sSuperClass + " extends " + theClass.theMetadata.getSuperClassName() + "{\r\n}\r\n\r\n";
//                    theBufferCollection.sDeclBuffer += sClassDefinition;
//                }
//            }
//        }
//        theClass = theClass.getFirstClass();
//        while (theClass != null) {
//            vImports = doImports(theProject, theClass, vImports);
//            theClass = theClass.getNextSibling();
//        }
//        vImports.add("java.util.*");
//        vImports.add("ch.abacus.lib.ui.renderer.*");
//        vImports.add("com.droplets.api.*");
        return vImports;
    }

    /**
     * doImports - This method collects import statements from all the classes of all the objects of
     * a project.
     *
     * @param theProject MetaProject = the project to generate imports for
     * @return String - a buffer of import statements.
     */
    public String doImports(MetaProject theProject) {
        String sImports = "";
        Vector vImports = new Vector();
//        MetaClass theClass = theProject.getFirstClass();
        // make sure we don't add stupid things.
//        vImports.add("java.lang.Object");
//        while (theClass != null) {
//            vImports = doImports(theProject, theClass, vImports);
//            theClass = theClass.getNextSibling();
//        }
//        sImports += "import java.awt.*;\r\n";
//        sImports += "import java.util.*;\r\n";
//        sImports += "import javax.swing.*;\r\n";
//        sImports += "import javax.swing.event.*;\r\n";
//        sImports += "import java.awt.event.*;\r\n";
//        sImports += "import ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface;\r\n";
//        sImports += "import ch.abacus.lib.ui.renderer.common.RenderingProjectInterface;\r\n";
//        sImports += "import ch.abacus.lib.ui.layout.AnchoringLayoutManager;\r\n";
//        sImports += "import ch.abacus.lib.ui.renderer.common.jdbc.*;\r\n"; // MHC
//        sImports += "import ch.abacus.lib.ui.JAScrollPane;\r\n"; // SWB. I don't really like this. It would be better to go through the classes used to see if any of them use a scrollpane and output this conditionally.
        vImports.add("java.util.*");
        vImports.add("ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletRenderer");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletPanel");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletCustomComponent");
        vImports.add("ch.abacus.lib.ui.renderer.common.RenderingProjectInterface");
        vImports.add("com.droplets.api.*");

        for (int i = 0; i < vImports.size(); i++) {
            String sImport = (String) vImports.get(i);
            sImports += "import " + sImport + ";\r\n";
        }
        return sImports;
    }

    /**
     * addLocalNLSDocuments - write code to load local nls documents in rendered class.
     * @param theProject - MetaProject - the project to add nls docs for.
     */
    public void addLocalNLSDocuments(MetaProject theProject) {
        int iDocCount = theProject.theLocalNLSDocuments.size();
        for (int i = 0; i < iDocCount; i++) {
            HammerNLSAccess theNLSDoc = (HammerNLSAccess) theProject.theLocalNLSDocuments.get(i);
            theBufferCollection.sAssignmentBuffer += "theRenderer.addNLSDocument(\"" +
                    MetaConstantGroup.preserveEscapeSequences(theNLSDoc.sDocument) +
                    "\",\"" + theNLSDoc.sKey + "\");\r\n";
        }
    }

    /**
     * generatePrologCode - This method generates the code that occurs before the class declaration.
     *
     */


    public void generatePrologCode(MetaProject theProject, String sClassName) {
        String sImports = doImports(theProject);
        // make sure there is no extension trailing the classname.
        int iMatch = sClassName.indexOf('.');
        if (iMatch != -1) {
            sClassName = sClassName.substring(0, iMatch);
        }
        theBufferCollection.sImportBuffer = sImports + "\r\n";
        theBufferCollection.sDeclBuffer += "\r\n" + "public class " + sClassName + " implements RenderingProjectInterface {\r\n";
        theBufferCollection.sDeclBuffer += "DropletRenderer theRenderer;\r\n";
        theBufferCollection.sDeclBuffer += "DropletPanel thePanel;\r\n";
        theBufferCollection.sAssignmentBuffer = "public " + sClassName + "(DropletRenderer theRenderer, DropletPanel panel) {\r\n";
        theBufferCollection.sAssignmentBuffer += "this.theRenderer = theRenderer;\r\n";
        theBufferCollection.sAssignmentBuffer += "theRenderer.theLog.writeMessage((\"Inside the AbaRenderer_Droplet constructor\"));\r\n";
        theBufferCollection.sAssignmentBuffer += "this.thePanel = thePanel;\r\n";
        theBufferCollection.sAssignmentBuffer += "theRenderer.theLog.writeMessage((\"Invoking add all components for class "+sClassName+"\"));\r\n";
        theBufferCollection.sAssignmentBuffer += "addAllComponents(theRenderer, panel); \r\n}\r\n";
        theBufferCollection.sAssignmentBuffer += "\r\n";
        //String sMainObjectIdentifier = sClassName + "_" + theFirstObject.getName();
        String sMainObjectIdentifier = theProject.getFirstObject().getName();   // MHC
//        theBufferCollection.sAssignmentBuffer3 += "// do frame insets\r\n";
//        theBufferCollection.sAssignmentBuffer3 += "Dimension dimSize = " + sMainObjectIdentifier + ".getSize();\r\n";
//        theBufferCollection.sAssignmentBuffer3 += sMainObjectIdentifier + ".setVisible(false);\r\n";
//        theBufferCollection.sAssignmentBuffer3 += sMainObjectIdentifier + ".show();\r\n";
//        theBufferCollection.sAssignmentBuffer3 += "Insets theInsets = " + sMainObjectIdentifier + ".getInsets();\r\n";
//        theBufferCollection.sAssignmentBuffer3 += sMainObjectIdentifier +
//                ".setSize((int) dimSize.getWidth() + theInsets.left + theInsets.right," +
//                "(int) dimSize.getHeight() + theInsets.top + theInsets.bottom);\r\n" +
//                sMainObjectIdentifier + ".setVisible(true);\r\n"
//                + "}\r\n";
        theBufferCollection.sAssignmentBuffer += "void addAllComponents(DropletRenderer theRenderer, DropletPanel thePanel) {\r\n";
        theBufferCollection.sAssignmentBuffer += "theRenderer.theLog.writeMessage((\"Inside add all components for class "+sClassName+"\"));\r\n";
        addLocalNLSDocuments(theProject);
    }

    /**
     if (theFabricatedObject instanceof JFrame) {
     JFrame theFrame = (JFrame) theFabricatedObject;
     Dimension dimSize = theFrame.getSize();
     // This is how you have to fix the non-client area sizing.
     // It has to be _exactly_ like this.
     theFrame.setVisible(false);
     theFrame.show();
     Insets theInsets = theFrame.getInsets();
     theFrame.setSize((int) dimSize.getWidth() + theInsets.left + theInsets.right,
     (int) dimSize.getHeight() + theInsets.top + theInsets.bottom);
     }

     */

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; i++) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theDiscriminators.get(i);
            if (theDiscriminator.theClass.equals(theClass))
                return theDiscriminator;
        }
        return null;
    }

    public void listenerPrint(String sOutputString) {
        theBufferCollection.sEventClassBuffer += sOutputString;
    }

    public void listenerPrintln(String sOutputString) {
        sOutputString += "\r\n";
        listenerPrint(sOutputString);
    }

    public String generateObjectEventClasses(String sSetCode, MetaObject theObject) {
        // Make a class for each listener for the object.
        // The class name is identifier of object plus name of listener concatenated
        // Implements is the name of the listener
        // One method for each event
        // Class is written to buffer that will be added before epilog code.

        MetaMethodLinkage theMethod = theObject.theFirstMethod;
        ArrayList theListeners = new ArrayList(0);
        ArrayList theDiscriminators = new ArrayList(0);
        ArrayList theSpecialDiscriminators = new ArrayList(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (theListeners.contains(theClass) == false) {
                theListeners.add(theMethod.theListener);
                ListenerDiscriminator theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                ListenerDiscriminator theDiscriminator = findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        // remove listeners that have no special implementation.
        for (int i = 0; i < theDiscriminators.size(); i++) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theDiscriminators.get(i);
            if (theDiscriminator.isSpecial() == true)
                theSpecialDiscriminators.add(theDiscriminator);
        }

        // generate classes for the others.
        for (int i = 0; i < theSpecialDiscriminators.size(); i++) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator) theSpecialDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator.theClass;
            String sListenerName = theListener.sClassName;
            String sOutputIdentifier = getIdentifier(theObject);
            int iMatchingListener = theListenerCollection.getDefaultListenerClass(sListenerName);

            sSetCode += sOutputIdentifier + ".";
            ListenerEntry theEntry = theListenerCollection.objDefaultListeners[iMatchingListener];
            sSetCode += theEntry.getAddListenerMethod() + "(";
            sSetCode += "new " + sOutputIdentifier + "$$$" + sListenerName + "());\r\n";
            listenerPrintln("/***__@Listener: [" + sOutputIdentifier + "$$$" + sListenerName + "] ***/");
            listenerPrint("class " + sOutputIdentifier + "$$$" + sListenerName);
            // Check if it's a listener or an adapter.  Adapter extends.  Listener implements interface.
            boolean bIsAdapter = (sListenerName.lastIndexOf("Adapter") == -1) ? false : true;
            if (bIsAdapter)
                listenerPrintln(" extends " + sListenerName + "  {");
            else
                listenerPrintln(" implements " + sListenerName + "  {");
            // Now write the methods.
            for (int j = 0; j < theDiscriminator.theMethods.size(); j++) {
                MetaMethodLinkage theListenerMethodLink = (MetaMethodLinkage) theDiscriminator.theMethods.get(j);
                MetaMethod theListenerMethod = theListenerMethodLink.theMethod;
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() != 0) {
                    listenerPrintln("/***__@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                    listenerPrintln(sCode);
                    listenerPrintln("/***__@@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                }
                theListenerMethod = theListenerMethod.getNextMethod();
            }
            // Close the class.
            listenerPrintln("  }");
            listenerPrintln("/***__@@Listener: [" + sListenerName + "] ***/");
        }
        return sSetCode;
    }


    /**
     * generateEpilogCode - This method writes any code that can only be written after processing.
     * This includes some types of declarations (constants etc) and the code that finishes the
     * class declaration.
     *
     */

    public void generateEpilogCode(MetaProject theProject) {
        String sProjectName = theProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        // close up the init function.
        theBufferCollection.sDeclBuffer += "Object oTemp;\r\n";
        for (int i = 0; i < vectorConstants.size(); i++) {
            String sCombinedKey = (String) vectorConstants.get(i);
            int iMatch1 = sCombinedKey.indexOf("|?|");
            int iMatch2 = sCombinedKey.indexOf("|?|", iMatch1 + 1);
            String sClassName = sCombinedKey.substring(0, iMatch1);
            String sConstantName = sCombinedKey.substring(iMatch1 + 3, iMatch2);
            String sValue = sCombinedKey.substring(iMatch2 + 3);
            theBufferCollection.sDeclBuffer += sClassName + " " + sValue + ";\r\n";
            if (sClassName.equals("int")) {
                theBufferCollection.sAssignmentBuffer += "oTemp = theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
                theBufferCollection.sAssignmentBuffer += "if (oTemp instanceof String)\r\n";
                theBufferCollection.sAssignmentBuffer += "oTemp = new Integer((String)oTemp);\r\n";
                theBufferCollection.sAssignmentBuffer += sValue + " = ((Integer)oTemp).intValue();\r\n";
            } else {
                theBufferCollection.sAssignmentBuffer += sValue + " = (" + sClassName + ") theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
            }
        }
        Object[] identifiers = Variables.keySet().toArray();
        for (int i = 0; i < identifiers.length; i++) {
            String sKey = (String) identifiers[i];
            int iMatch = sKey.indexOf("|*|");
            String sClassName = sKey.substring(0, iMatch);
            String identifier = sKey.substring(iMatch + 3);
            String sValue = (String) Variables.get(sKey);
            theBufferCollection.sDeclBuffer += sClassName + " " + identifier + ";";
            theBufferCollection.sAssignmentBuffer += identifier + " = (" + sClassName + ") theRenderer.resolveConstantValue(\"" + sValue + "\");\r\n";
        }
        theBufferCollection.sAccessorBuffer += "\r\n" + theBufferCollection.sPropertyMethodBuffer;
        // Add the event classes.
    }


    public String generatePropertyCode(MetaProperty theProperty) throws HammerException {
        String sReturnValue = "";
        int iSize = theProperty.theIndexedValue.size();
        for (int i = 0; i < iSize; i++) {
            if (sReturnValue.length() > 0)
                sReturnValue += ",";
            MetaParameter theParameter = (MetaParameter) theProperty.theIndexedValue.get(i);
            sReturnValue += generateParameterCode(theParameter, theProperty.thePropertyInfo);
        }
        return sReturnValue;
    }

    public String generateParameterCode(MetaParameter theParameter, MetaPropertyDescriptor thePropDesc) throws HammerException {
        String sTestValue = theParameter.getLiteralValue();
        if (thePropDesc == null)
            return "";
        if ((theParameter.theSimpleType != null) && ((theParameter.theSimpleType.equalsIgnoreCase("java.lang.String") || (theParameter.theSimpleType.equalsIgnoreCase("String"))))) {
            if ((sTestValue.indexOf('\\') != -1) || (sTestValue.indexOf('\"') != -1)) {
                sTestValue = MetaConstantGroup.preserveEscapeSequences("\"" + sTestValue + "\"");
            } else
                sTestValue = "theRenderer.doNLSTranslation(\"" + sTestValue + "\")";  // surround by quotes.
        } else if (theParameter.getMnemonic()) {
            if (thePropDesc.getName() != null) {
                if (thePropDesc.getName().equalsIgnoreCase("mnemonic"))
                    sTestValue = "theRenderer.doNLSMnemonicTranslation(\"" + sTestValue + "\")";  // surround by quotes.
            }
        }
        return doCodeGenerationForConstants(theParameter, theParameter.theDesignProject, sTestValue, thePropDesc);
    }

    public String doCodeGenerationForConstants(MetaParameter theParameter, MetaProject theProject, String sTestValue, MetaPropertyDescriptor thePropDesc) throws HammerException {
        String sMatch = null;
        if ((thePropDesc != null) && (thePropDesc.getIncludeTypeConstants() != null)) {
            MetaConstantGroup theConstantTable = theProject.findConstantGroup(thePropDesc.getIncludeTypeConstants());
            if (theConstantTable != null) {
                sMatch = theConstantTable.getKey(sTestValue);
            } else {
                MetaConstantGroupCollection theConstantTableCollection =
                        theProject.findConstantGroupCollection(thePropDesc.getIncludeTypeConstants());
                if (theConstantTableCollection != null) {
                    sMatch = theConstantTableCollection.getKey(sTestValue);
                }
            }
            if (sMatch != null) {
                String sCombinedKey = thePropDesc.getClassName() + "|?|" + thePropDesc.getIncludeTypeConstants() + "|?|" + sMatch;
                if (vectorConstants.contains(sCombinedKey) == false)
                    vectorConstants.add(sCombinedKey);
                sTestValue = sMatch;
            } else {
                // look for an object definition.  Rule out standard classes.
                Object theThing = MetaConstantGroup.resolve(sTestValue,
                        theParameter.theDesignProject.getMetadataDispenser(),
                        theParameter.theDesignProject.getMetaDataUser().getClassLoader().getLoader());
                String sClass = thePropDesc.getClassName();
                if (sClass.equals("String") == false) {
                    if (theThing instanceof String == false) {
                        // See if it is made already.
                        // If it is not present add it.
                        sMatch = lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                        if (sMatch == null)
                            sMatch = makeIdentifier(thePropDesc.getClassName(), sTestValue);
                        sTestValue = sMatch;
                    }
                }
            }
        } else {
            String sClassName = thePropDesc.getClassName();
            if ((sClassName.endsWith("String") == false) && (sTestValue.indexOf("construct") != -1)) {
//                Object theThing = MetaConstantGroup.resolve(sTestValue,
//                        theParameter.theDesignProject.getMetadataDispenser(),
//                        theParameter.theDesignProject.getMetaDataUser().getClassLoader().getLoader());
                sMatch = lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                if (sMatch == null)
                    sMatch = makeIdentifier(thePropDesc.getClassName(), sTestValue);
                sTestValue = sMatch;
            }
        }
        return sTestValue;
    }

    public String getDeclarationBuffer() {
        return theBufferCollection.sDeclBuffer;
    }

    public String getAssignmentBuffer() {
        return theBufferCollection.sAssignmentBuffer;
    }

    public BufferCollection getBufferCollection() {
        return theBufferCollection;
    }

    public void setAssignmentBuffer(String sAssignmentBuffer) {
        theBufferCollection.sAssignmentBuffer = sAssignmentBuffer;
    }

    public void setDeclarationBuffer(String sDeclarationBuffer) {
        theBufferCollection.sDeclBuffer = sDeclarationBuffer;
    }

    /**
     * lookupIdentifier - Simple method to search for an identifier from a hash map.  It pairs
     * the class name with the test value to return the unique key.  This is used to lookup vars for
     * constant declarations.
     *
     * @param className   String - Class name of the variable.
     * @param sTestValue  String - Value to assign.
     * @return String - the identifier associated.
     */
    public String lookupIdentifier(String className, String sTestValue) {
        return (String) Variables.get(className + "|*|" + sTestValue);
    }

    /**
     * makeIdentifier  - makes a unique identifier to use for a given value of a given class.
     * This is used to associate named values and constants in code generation.
     *
     * @param className String - Class name of the variable.
     * @param sTestValue String - Value to assign.
     * @return String - the Identifier to use to reference this value of this class.
     */
    public String makeIdentifier(String className, String sTestValue) {
        Integer classVariableCount = (Integer) VariableClasses.get(className);
        int iClassVarCount = 0;
        if (classVariableCount != null) {
            try {
                iClassVarCount = classVariableCount.intValue() + 1;
            } catch (NumberFormatException e1) {
                // stays 0
            }
        }
        String sIdentifier = className;
        int iDotPos = sIdentifier.lastIndexOf(".");
        sIdentifier = className.substring(iDotPos + 1) + "_" + iClassVarCount;
        Variables.put(className + "|*|" + sIdentifier, sTestValue);
        VariableClasses.put(className, new Integer(iClassVarCount));
        return sIdentifier;
    }

    public ListenerCollection getListenerCollection() {
        return theListenerCollection;
    }

    public void setListenerCollection(ListenerCollection theListenerCollection) {
        this.theListenerCollection = theListenerCollection;
    }

    public String getFormattedSource() {                       // use default delims
        String sSourceCode = theBufferCollection.sImportBuffer +
                "\r\n" + theBufferCollection.sDeclBuffer +
                "\r\n" + theBufferCollection.sAccessorBuffer +
                "\r\n" + theBufferCollection.sAssignmentBuffer1 + "\r\n" +
                "\r\n" + theBufferCollection.sAssignmentBuffer2 + "\r\n" +
                "\r\n" + theBufferCollection.sAssignmentBuffer3 + "\r\n" +
                theBufferCollection.sEventClassBuffer + "\r\n" +
                theBufferCollection.sAssignmentBuffer + "\r\n" +
                theBufferCollection.sPropertyBuffer + "\r\n" +
                theBufferCollection.sAttachmentBuffer + "\r\n" + "}\r\n}\r\n";
        com.ibm.cf.CodeFormatter theFormatter = new com.ibm.cf.CodeFormatter();
        StringReader theReader = new StringReader(sSourceCode);
        StringWriter theWriter = new StringWriter(sSourceCode.length());
        theFormatter.formatCode(theReader, theWriter);
        return theWriter.getBuffer().toString();
    }

    public void reset() {
        theBufferCollection = new BufferCollection();
    }

    static String sFindString = "X_X__X___X_";
    static String sStub = "X_X__X___X_";

    public boolean doTemplateFile(String sTemplateFile, String sReplaceString, String sExtension) {
        String sOutputFile = sReplaceString + sTemplateFile;
        sOutputFile = sOutputFile.substring(0, sOutputFile.lastIndexOf(".") + 1) + sExtension;
        sTemplateFile = sStub + sTemplateFile;
        BufferedInputStream streamIn = null;
        BufferedOutputStream streamOut = null;
        File fileInputTest = new File(sTemplateFile);
        if (fileInputTest.isFile() == false)
            return false;  // Can't proceed - no input file.
        File fileOutputTest = new File(sOutputFile);
        if (fileOutputTest.isFile() == false) {
            try {
                fileOutputTest.createNewFile();
            } catch (java.io.IOException e1) {
                return false;
            }
        }
        // Now we have a file to copy to.
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(fileInputTest));
        } catch (FileNotFoundException e) {
            return false; // shouldn't happen though
        }
        try {
            writer = new BufferedWriter(new FileWriter(fileOutputTest));
        } catch (FileNotFoundException e) {
            return false; // should happen though
        } catch (IOException e) {
            return false;
        }
        String sLine = "";
        try {
            while ((sLine = reader.readLine()) != null) {
                sLine = sLine.replaceAll(sFindString, sReplaceString);
                sLine += "\r\n";
                writer.write(sLine);
            }
            reader.close();
            writer.close();
        } catch (IOException e) {
            return false;
        }
        return true;
    }

    public void doTemplateFiles(String sDocumentName) {
        int iDotPos = sDocumentName.lastIndexOf(".");
        if (iDotPos != -1) {
            String sBase = sDocumentName.substring(0, iDotPos - 1);
            String sFileSeparator = System.getProperty("file.separator");
            int iMatchSlash = sBase.lastIndexOf(sFileSeparator);
            if (iMatchSlash != -1) {
                sBase = sBase.substring(iMatchSlash + sFileSeparator.length());
            }
            doTemplateFile("AppFactory.template", sBase, "java");
            doTemplateFile("MainWindow.template", sBase, "java");
        }
    }
}