/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* $Header: /cvs/v2006_cdnew/aba/java/src/ch/abacus/lib/ui/renderer/programmableCompiler/ClassByteFileLoader.java,v 1.6 2004/08/31 16:25:50 gouker Exp $
 * $Log: ClassByteFileLoader.java,v $
 * Revision 1.6  2004/08/31 16:25:50  gouker
 * Changes for optimization.  Droplet code generator changes.
 * This code still has some debugging that must be removed.
 *
 * Revision 1.5  2003/12/12 16:26:56  gouker
 * Moved source code from design cockpit to renderer
 * Merged in all 11/30 fixes for resource losses
 * Added metadata dispenser
 *
 * Revision 1.1  2003/07/02 18:53:18  gouker
 * Design Cockpit - New check in after refactoring.  In progress still so don't even try to build yet.
 *
 * Thanks!
 *
 * Revision 1.1  2003/03/24 14:59:57  gouker
 * First time checking in design cockpit.  This time it allows renderer.
 *
 * Revision 1.1  1998/11/06 10:37:03  graham
 * Initial revision
 *
 *
 */

/* Copyright (C) 1998 Graham Kirby
 *
 * This library is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
 *
 * To receive a copy of the GNU Library General Public License, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

package ch.abacus.lib.ui.renderer.programmableCompiler;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * Supports loading of class byte code from the file system.<P>
 *
 * The <A HREF="../../compiler/ClassByteFileLoader.java">source code</A> is available.
 *
 * @author	Graham Kirby (<A HREF="mailto:graham@dcs.st-and.ac.uk">graham@dcs.st-and.ac.uk</A>)
 * @version 1.2 2-Nov-98
 */
public class ClassByteFileLoader implements ClassByteLoader {

    private Vector classPathVector;

    private Hashtable properties;

    /**
     * @param classPathVector	vector of directories forming class path with index 0 being searched first
     * @param properties		hash table containing entries for various constants including "packageSeparator" and "compiledSuffix"
     */
    public ClassByteFileLoader(Vector classPathVector, Hashtable properties) {

        this.classPathVector = classPathVector;
        this.properties = properties;
    }

    /**
     * Finds the byte array corresponding to the given class name.
     *
     * @param name	a fully qualified class name
     * @return		an array containing the byte code for the given class, or null if it is not found
     */
    public byte[] get(String name) {

        byte[] classBytes = null;

        // Get the file containing the byte code.
        File classFile = findClassFile(name);

        try {

            // Create an input stream from the file.
            FileInputStream classFileInputStream = new FileInputStream(classFile);

            // Get the file length.
            int fileLength = classFileInputStream.available();

            // Create an array the same length as the file to hold the compiled class.
            classBytes = new byte[fileLength];

            // Read class definition into the array.
            classFileInputStream.read(classBytes);

            // Close the file.
            classFileInputStream.close();
        } catch (Exception e) {
        }

        return classBytes;
    }

    /**
     * Finds the .class file corresponding to the given class name.
     *
     * @param fullClassName	a full class name
     * @return				the file containing the byte code for the given class
     */
    public File findClassFile(String fullClassName) {

        File classFile = null;

        String packageSeparator = (String) properties.get("packageSeparator");
        String compiledSuffix = (String) properties.get("compiledSuffix");

        Enumeration classDirs = classPathVector.elements();
        while (classDirs.hasMoreElements()) {

            // Create tokenizer to extract the package name components.
            StringTokenizer st = new StringTokenizer(fullClassName, packageSeparator);

            // Start at the root directory.
            File packageDir = (File) classDirs.nextElement();

            // Get the first token.
            String s = st.nextToken();

            // Add the sub-directories for the package structure in turn, if any.
            while (st.hasMoreTokens()) {

                // Generate the name of the next directory.
                packageDir = new File(packageDir, s);

                // Get the next token.
                s = st.nextToken();
            }

            // Get the class file.
            classFile = new File(packageDir, s + compiledSuffix);

            // Return the class file if found.
            if (classFile.exists()) break;
        }

        return classFile;
    }
}
